/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.reteoo.nodes.ReteBetaNodeUtils;

public class ReteNotNode
extends NotNode {
    public ReteNotNode() {
    }

    public ReteNotNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, leftInput, rightInput, joinNodeBinder, context);
    }

    public void attach(BuildContext context) {
        ReteBetaNodeUtils.attach((BetaNode)this, context);
    }

    public boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        return ReteBetaNodeUtils.doRemove((BetaNode)this, context, builder, workingMemories);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteBetaNodeUtils.modifyObject((BetaNode)this, factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple((InternalFactHandle)factHandle, (ModifyPreviousTuples)modifyPreviousTuples, (PropagationContext)context, (InternalWorkingMemory)workingMemory, (LeftTupleSink)this, (ObjectTypeNode.Id)this.getLeftInputOtnId(), (BitMask)this.getLeftInferredMask());
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        TupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, (Tuple)leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple((Tuple)leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)it.next((Entry)rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        if (leftTuple.getBlocker() == null) {
            if (useLeftMemory) {
                memory.getLeftTupleMemory().add((Tuple)leftTuple);
            }
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        RightTuple rightTuple = this.createRightTuple(factHandle, (RightTupleSink)this, pctx);
        rightTuple.setPropagationContext(pctx);
        this.assertRightTuple(rightTuple, pctx, wm);
    }

    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        memory.getRightTupleMemory().add((Tuple)rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        TupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, it);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)it.next((Entry)leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), (Tuple)leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove((Tuple)leftTuple);
                this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        rightTuple.setPropagationContext(context);
        TupleMemory rtm = memory.getRightTupleMemory();
        if (rightTuple.getBlocked() != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, memory.getLeftTupleMemory(), rightTuple.getBlocked(), rtm, false);
            rightTuple.setBlocked(null);
        } else {
            rtm.remove((Tuple)rightTuple);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
            memory.getLeftTupleMemory().remove((Tuple)leftTuple);
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        } else {
            blocker.removeBlocked(leftTuple);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        TupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple firstRightTuple = this.getFirstRightTuple((Tuple)leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove((Tuple)leftTuple);
        } else if (rightMemory.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, (Tuple)leftTuple);
        if (blocker != null && !this.isLeftUpdateOptimizationAllowed()) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
            }
            RightTuple newBlocker = firstRightTuple;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next((Entry)newBlocker);
            }
            if (leftTuple.getBlocker() != null) {
                if (leftTuple.getFirstChild() != null) {
                    this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
                }
            } else if (leftTuple.getFirstChild() == null) {
                memory.getLeftTupleMemory().add((Tuple)leftTuple);
                this.propagateAssertLeftTuple(context, workingMemory, leftTuple);
            } else {
                memory.getLeftTupleMemory().add((Tuple)leftTuple);
                this.propagateModifyChildLeftTuple(context, workingMemory, leftTuple);
            }
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().removeAdd((Tuple)rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        TupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple firstLeftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, leftIt);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.setBlocked(null);
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftIt.next((Entry)leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), (Tuple)leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove((Tuple)leftTuple);
                this.propagateRetractLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
        TupleMemory rightTupleMemory = memory.getRightTupleMemory();
        if (firstBlocked != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, leftMemory, firstBlocked, rightTupleMemory, true);
        } else {
            rightTupleMemory.removeAdd((Tuple)rightTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
    }

    private void updateLeftTupleToNewBlocker(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory, TupleMemory leftMemory, LeftTuple firstBlocked, TupleMemory rightTupleMemory, boolean removeAdd) {
        FastIterator rightIt;
        boolean resumeFromCurrent = !this.indexedUnificationJoin && !rightTupleMemory.getIndexType().isComparison();
        RightTuple rootBlocker = null;
        if (resumeFromCurrent) {
            TupleList currentRtm = rightTuple.getMemory();
            rightIt = currentRtm.fastIterator();
            rootBlocker = (RightTuple)rightTuple.getNext();
            if (removeAdd) {
                rightTupleMemory.removeAdd((Tuple)rightTuple);
            } else {
                rightTupleMemory.remove((Tuple)rightTuple);
            }
            if (rootBlocker == null && rightTuple.getMemory() == currentRtm) {
                rootBlocker = rightTuple;
            }
        } else {
            rightIt = this.getRightIterator(rightTupleMemory);
            if (removeAdd) {
                rightTupleMemory.removeAdd((Tuple)rightTuple);
            } else {
                rightTupleMemory.remove((Tuple)rightTuple);
            }
        }
        LeftTuple leftTuple = firstBlocked;
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.clearBlocker();
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, (Tuple)leftTuple);
            if (!resumeFromCurrent) {
                rootBlocker = this.getFirstRightTuple((Tuple)leftTuple, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
            }
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next((Entry)newBlocker);
            }
            if (leftTuple.getBlocker() == null) {
                leftMemory.add((Tuple)leftTuple);
                this.propagateAssertLeftTuple(context, workingMemory, leftTuple);
            }
            leftTuple = temp;
        }
    }

    protected void propagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
    }

    protected void propagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
    }

    protected void propagateModifyChildLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)this);
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            sink.assertLeftTuple(sink.createLeftTuple(leftTuple, (Sink)sink, context, true), context, workingMemory);
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public RightTuple getFirstRightTuple(Tuple leftTuple, TupleMemory memory, InternalFactHandle factHandle, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return memory instanceof TupleIndexHashTable ? (RightTuple)((TupleIndexHashTable)memory).getFirst(leftTuple, factHandle) : (RightTuple)memory.getFirst(leftTuple);
        }
        return (RightTuple)it.next(null);
    }
}

