/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.api;

import org.drools.persistence.api.TransactionManager;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManagerFactory.class);
    private static TransactionManagerFactory INSTANCE;

    private static void setInstance() {
        String factoryClassName = System.getProperty("org.kie.txm.factory.class", "org.drools.persistence.jta.JtaTransactionManagerFactory");
        try {
            TransactionManagerFactory factory;
            INSTANCE = factory = Class.forName(factoryClassName).asSubclass(TransactionManagerFactory.class).newInstance();
            logger.info("Using " + factory);
        }
        catch (Exception e) {
            logger.error("Unable to instantiate " + factoryClassName, (Throwable)e);
        }
    }

    public static void resetInstance() {
        TransactionManagerFactory.setInstance();
    }

    public static final TransactionManagerFactory get() {
        return INSTANCE;
    }

    public abstract TransactionManager newTransactionManager();

    public abstract TransactionManager newTransactionManager(Environment var1);

    static {
        TransactionManagerFactory.setInstance();
    }
}

