/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.workitemconsequence;

import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class WorkItemConsequenceExample2 {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"WorkItemConsequence2.drl", WorkItemConsequenceExample2.class), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Compilation error.\n" + kbuilder.getErrors().toString());
        }
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.getWorkItemManager().registerWorkItemHandler("GreetingWorkItemHandler", (WorkItemHandler)new GreetingWorkItemHandler());
        ksession.insert((Object)new Greeting("Michael"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static class GreetingWorkItemHandler
    implements WorkItemHandler {
        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            String name = (String)workItem.getParameter("name");
            String response = "Hello, " + name;
            workItem.getResults().put("response", response);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    public static class Greeting {
        private String name;
        private String response;

        public Greeting(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public String getResponse() {
            return this.response;
        }
    }
}

