/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures.model;

import org.drools.games.adventures.model.Key;
import org.drools.games.adventures.model.LockStatus;
import org.drools.games.adventures.model.Room;
import org.drools.games.adventures.model.Thing;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.PropertyReactive;

@PropertyReactive
public class Door
extends Thing {
    @Position(value=2)
    private Room fromRoom;
    @Position(value=3)
    private Room toRoom;
    @Position(value=4)
    private LockStatus lockStatus;
    @Position(value=5)
    private Key key;

    public Door(Room fromRoom, Room toRoom) {
        super("Door from " + fromRoom.getName() + " to " + toRoom.toString(), false);
        this.fromRoom = fromRoom;
        this.toRoom = toRoom;
        this.lockStatus = LockStatus.UNLOCKED;
    }

    public Room getFromRoom() {
        return this.fromRoom;
    }

    public void setFromRoom(Room fromRoom) {
        this.fromRoom = fromRoom;
    }

    public Room getToRoom() {
        return this.toRoom;
    }

    public void setToRoom(Room toRoom) {
        this.toRoom = toRoom;
    }

    public LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Door door = (Door)o;
        if (!this.fromRoom.equals(door.fromRoom)) {
            return false;
        }
        return this.toRoom.equals(door.toRoom);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fromRoom.hashCode();
        result = 31 * result + this.toRoom.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Door{fromRoom=" + this.fromRoom + ", toRoom=" + this.toRoom + '}';
    }
}

