/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.troubleticket;

import org.drools.examples.troubleticket.Customer;
import org.drools.examples.troubleticket.Ticket;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.DecisionTableConfiguration;
import org.kie.builder.DecisionTableInputType;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.FactHandle;

public class TroubleTicketExampleWithDT {
    public static final void main(String[] args) {
        TroubleTicketExampleWithDT launcher = new TroubleTicketExampleWithDT();
        launcher.executeExample();
    }

    public void executeExample() {
        DecisionTableConfiguration dtableconfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtableconfiguration.setInputType(DecisionTableInputType.XLS);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"TroubleTicket.xls", TroubleTicketExampleWithDT.class), ResourceType.DTABLE, (ResourceConfiguration)dtableconfiguration);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Customer a = new Customer("A", "Drools", "Gold");
        Customer b = new Customer("B", "Drools", "Platinum");
        Customer c = new Customer("C", "Drools", "Silver");
        Customer d = new Customer("D", "Drools", "Silver");
        Ticket t1 = new Ticket(a);
        Ticket t2 = new Ticket(b);
        Ticket t3 = new Ticket(c);
        Ticket t4 = new Ticket(d);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        ksession.insert((Object)d);
        ksession.insert((Object)t1);
        ksession.insert((Object)t2);
        FactHandle ft3 = ksession.insert((Object)t3);
        ksession.insert((Object)t4);
        ksession.fireAllRules();
        t3.setStatus("Done");
        ksession.update(ft3, (Object)t3);
        try {
            System.err.println("[[ Sleeping 5 seconds ]]");
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.err.println("[[ awake ]]");
        ksession.dispose();
    }
}

