/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures;

import java.awt.EventQueue;
import org.drools.games.adventures.AdventureFrame;
import org.drools.games.adventures.GameEngine;
import org.drools.games.adventures.UserSession;

public class TextAdventure {
    public static void main(String[] args) {
        new TextAdventure().init(true);
    }

    public void init(final boolean exitOnClose) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GameEngine engine = new GameEngine();
                engine.createGame();
                TextAdventure.createFrame(engine, exitOnClose ? 3 : 2);
            }
        });
    }

    public static void createFrame(GameEngine engine, int onClose) {
        UserSession session = new UserSession();
        AdventureFrame frame = new AdventureFrame(session, onClose);
        frame.setVisible(true);
        session.getChannels().put("output", new AdventureFrame.JTextAreaChannel(frame.getOutputTextArea()));
        session.getChannels().put("events", new AdventureFrame.JTextAreaChannel(frame.getLocalEventsTextArea()));
        session.getChannels().put("exits", new AdventureFrame.JTableChannel(frame.getExitsTable()));
        session.getChannels().put("things", new AdventureFrame.JTableChannel(frame.getThingsTable()));
        session.getChannels().put("inventory", new AdventureFrame.JTableChannel(frame.getInventoryTable()));
        session.getChannels().put("characters", new AdventureFrame.JComboBoxChannel(frame.getCharacterSelectCombo()));
        frame.setGameEngine(engine);
        engine.ksession.insert((Object)session);
        engine.ksession.fireAllRules();
    }
}

