/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.cli;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.drlonyaml.cli.Yaml2Drl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="batch2drl", description={"Converts all .yml files to DRL from the given directory, recursively. Converted files will get postfixed with .drl in their names."})
public class Batch2Drl
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Batch2Drl.class);
    @CommandLine.Parameters(index="0", paramLabel="INPUT_DIR", description={"The directory containing .yml files; the directory is walked recursively."})
    private File inputDir;

    @Override
    public Integer call() throws Exception {
        this.inputDir.toPath();
        try (Stream<Path> walk = Files.walk(this.inputDir.toPath().toAbsolutePath(), new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".yml")).forEach(p -> Batch2Drl.convertFile(p.toAbsolutePath()));
        }
        return 0;
    }

    public static void convertFile(Path drlFile) {
        try {
            String drlTxt = Files.readAllLines(drlFile).stream().collect(Collectors.joining("\n"));
            Path to = Path.of(drlFile.toString() + ".drl", new String[0]);
            LOG.info("writing to: {}", (Object)to);
            String fileContent = "// Automatically generated from: " + drlFile.toFile().getName().toString() + "\n" + Yaml2Drl.yaml2drl(drlTxt);
            Files.writeString(to, (CharSequence)fileContent, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

