/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.drools.base.RuleBuildContext;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleComponent;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.rule.constraint.XpathConstraint;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.time.TemporalDependencyMatrix;

public class BuildContext
implements RuleBuildContext {
    private final List<TerminalNode> terminals = new ArrayList<TerminalNode>();
    private LeftTupleSource tupleSource;
    private ObjectSource objectSource;
    private List<Pattern> patterns;
    private final InternalRuleBase ruleBase;
    private RuleImpl rule;
    private GroupElement subRule;
    private final Deque<RuleComponent> ruleComponent = new ArrayDeque<RuleComponent>();
    private Deque<RuleConditionElement> buildstack;
    private List<BetaNodeFieldConstraint> betaconstraints;
    private List<AlphaNodeFieldConstraint> alphaConstraints;
    private List<XpathConstraint> xpathConstraints;
    private EntryPointId currentEntryPoint;
    private boolean tupleMemoryEnabled;
    private boolean query;
    private int subRuleIndex;
    private final List<PathEndNode> pathEndNodes = new ArrayList<PathEndNode>();
    private List<BaseNode> nodes = new ArrayList<BaseNode>();
    private RuleBasePartitionId partitionId;
    private TemporalDependencyMatrix temporal;
    private ObjectTypeNode rootObjectTypeNode;
    private Pattern[] lastBuiltPatterns;
    private boolean emptyForAllBetaConstraints;
    private boolean attachPQN;
    private boolean terminated;
    private String consequenceName;
    private final Collection<InternalWorkingMemory> workingMemories;

    public BuildContext(InternalRuleBase ruleBase, Collection<InternalWorkingMemory> workingMemories) {
        this.ruleBase = ruleBase;
        this.workingMemories = workingMemories;
        this.tupleMemoryEnabled = true;
        this.currentEntryPoint = EntryPointId.DEFAULT;
        this.attachPQN = true;
        this.emptyForAllBetaConstraints = false;
    }

    public List<TerminalNode> getTerminals() {
        return this.terminals;
    }

    public boolean isEmptyForAllBetaConstraints() {
        return this.emptyForAllBetaConstraints;
    }

    void setEmptyForAllBetaConstraints() {
        this.emptyForAllBetaConstraints = true;
    }

    public void syncObjectTypesWithObjectCount() {
        if (this.patterns == null) {
            return;
        }
        if (this.tupleSource != null) {
            while (this.patterns.size() > this.tupleSource.getObjectCount()) {
                this.patterns.remove(this.patterns.size() - 1);
            }
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public List<Pattern> getPatterns() {
        return this.patterns == null ? Collections.emptyList() : this.patterns;
    }

    public void addPattern(Pattern pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<Pattern>();
        }
        this.patterns.add(pattern);
    }

    public LeftTupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    public Collection<InternalWorkingMemory> getWorkingMemories() {
        return this.workingMemories;
    }

    public int getNextNodeId() {
        return this.ruleBase.getReteooBuilder().getNodeIdsGenerator().getNextId();
    }

    public int getNextMemoryId() {
        return this.ruleBase.getReteooBuilder().getMemoryIdsGenerator().getNextId();
    }

    public void releaseId(NetworkNode node) {
        this.ruleBase.getReteooBuilder().releaseId(node);
    }

    public void push(RuleConditionElement rce) {
        if (this.buildstack == null) {
            this.buildstack = new ArrayDeque<RuleConditionElement>();
        }
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        return this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        return this.buildstack.getLast();
    }

    public Collection<RuleConditionElement> getBuildstack() {
        return this.buildstack == null ? Collections.emptyList() : this.buildstack;
    }

    public List<BetaNodeFieldConstraint> getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List<BetaNodeFieldConstraint> betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public List<AlphaNodeFieldConstraint> getAlphaConstraints() {
        return this.alphaConstraints;
    }

    void setAlphaConstraints(List<AlphaNodeFieldConstraint> alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }

    List<XpathConstraint> getXpathConstraints() {
        return this.xpathConstraints;
    }

    List<PathEndNode> getPathEndNodes() {
        return this.pathEndNodes;
    }

    public void addPathEndNode(PathEndNode node) {
        this.pathEndNodes.add(node);
    }

    void setXpathConstraints(List<XpathConstraint> xpathConstraints) {
        this.xpathConstraints = xpathConstraints;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean hasLeftMemory) {
        this.tupleMemoryEnabled = hasLeftMemory;
    }

    public boolean isQuery() {
        return this.query;
    }

    public EntryPointId getCurrentEntryPoint() {
        return this.currentEntryPoint;
    }

    public void setCurrentEntryPoint(EntryPointId currentEntryPoint) {
        this.currentEntryPoint = currentEntryPoint;
    }

    public List<BaseNode> getNodes() {
        return this.nodes;
    }

    BaseNode getLastNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void setNodes(List<BaseNode> nodes) {
        this.nodes = nodes;
    }

    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public boolean isStreamMode() {
        return this.temporal != null && !this.rule.isEager();
    }

    public long getExpirationOffset(Pattern pattern) {
        return this.temporal != null ? this.temporal.getExpirationOffset(pattern) : -1L;
    }

    void setTemporalDistance(TemporalDependencyMatrix temporal) {
        this.temporal = temporal;
    }

    @Override
    public RuleImpl getRule() {
        return this.rule;
    }

    public void setRule(RuleImpl rule) {
        this.rule = rule;
        if (rule.isQuery()) {
            this.query = true;
        }
    }

    public GroupElement getSubRule() {
        return this.subRule;
    }

    void setSubRule(GroupElement subRule) {
        this.subRule = subRule;
    }

    public RuleComponent popRuleComponent() {
        return this.ruleComponent.pop();
    }

    public RuleComponent peekRuleComponent() {
        return this.ruleComponent.isEmpty() ? null : this.ruleComponent.peek();
    }

    public void pushRuleComponent(RuleComponent ruleComponent) {
        this.ruleComponent.push(ruleComponent);
    }

    public ObjectTypeNode getRootObjectTypeNode() {
        return this.rootObjectTypeNode;
    }

    public void setRootObjectTypeNode(ObjectTypeNode source) {
        this.rootObjectTypeNode = source;
    }

    public Pattern[] getLastBuiltPatterns() {
        return this.lastBuiltPatterns;
    }

    public void setLastBuiltPattern(Pattern lastBuiltPattern) {
        if (this.lastBuiltPatterns == null) {
            this.lastBuiltPatterns = new Pattern[]{lastBuiltPattern, null};
        } else {
            this.lastBuiltPatterns[1] = this.lastBuiltPatterns[0];
            this.lastBuiltPatterns[0] = lastBuiltPattern;
        }
    }

    boolean isAttachPQN() {
        return this.attachPQN;
    }

    void setAttachPQN(boolean attachPQN) {
        this.attachPQN = attachPQN;
    }

    boolean isTerminated() {
        return this.terminated;
    }

    void terminate() {
        this.terminated = true;
    }

    public String getConsequenceName() {
        return this.consequenceName;
    }

    public void setConsequenceName(String consequenceName) {
        this.consequenceName = consequenceName;
    }

    public int getSubRuleIndex() {
        return this.subRuleIndex;
    }

    public void setSubRuleIndex(int subRuleIndex) {
        this.subRuleIndex = subRuleIndex;
    }
}

