/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.BaseTuple;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.AbstractTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.util.Entry;
import org.drools.core.util.index.TupleList;
import org.kie.api.runtime.rule.FactHandle;

public interface Tuple
extends BaseTuple,
Serializable,
Entry<AbstractTuple> {
    public static final short NONE = 0;
    public static final short INSERT = 1;
    public static final short UPDATE = 2;
    public static final short DELETE = 3;
    public static final short NORMALIZED_DELETE = 4;

    @Override
    default public Object[] toObjects() {
        return this.toObjects(false);
    }

    public void setFactHandle(FactHandle var1);

    public InternalFactHandle getOriginalFactHandle();

    public Tuple getSubTuple(int var1);

    @Override
    public Object getContextObject();

    public void setContextObject(Object var1);

    public short getStagedType();

    public void setStagedType(short var1);

    default public boolean isDeleted() {
        return this.getStagedType() == 3 || this.getStagedType() == 4;
    }

    public Tuple getStagedPrevious();

    public void setStagedPrevious(Tuple var1);

    public <T extends Tuple> T getStagedNext();

    public void setStagedNext(Tuple var1);

    public void clear();

    public void clearStaged();

    public void reAdd();

    public void unlinkFromRightParent();

    public void unlinkFromLeftParent();

    public PropagationContext getPropagationContext();

    public void setPropagationContext(PropagationContext var1);

    public Tuple getPrevious();

    public void setPrevious(Tuple var1);

    public <S extends Sink> S getTupleSink();

    public TupleList getMemory();

    public void setMemory(TupleList var1);

    public Tuple getRootTuple();

    @Override
    public Tuple skipEmptyHandles();

    public LeftTuple getFirstChild();

    public void setFirstChild(LeftTuple var1);

    public LeftTuple getLastChild();

    public void setLastChild(LeftTuple var1);

    public <T extends Tuple> T getHandlePrevious();

    @Override
    public Tuple getParent();

    public void setHandlePrevious(Tuple var1);

    public <T extends Tuple> T getHandleNext();

    public void setHandleNext(Tuple var1);

    public ObjectTypeNode.Id getInputOtnId();

    public <N extends NetworkNode> N getTupleSource();

    public boolean isExpired();

    default public PropagationContext findMostRecentPropagationContext() {
        PropagationContext mostRecentContext = this.getPropagationContext();
        for (Tuple lt = this.getParent(); lt != null; lt = lt.getParent()) {
            PropagationContext currentContext = lt.getPropagationContext();
            if (currentContext == null || currentContext.getPropagationNumber() <= mostRecentContext.getPropagationNumber()) continue;
            mostRecentContext = currentContext;
        }
        return mostRecentContext;
    }
}

