/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.facttemplates.Fact;
import org.drools.base.facttemplates.FactImpl;
import org.drools.base.rule.EntryPointId;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FactTemplateTypeConf;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.consequence.InternalMatch;

public class ObjectTypeConfigurationRegistry
implements Serializable {
    private static final long serialVersionUID = 510L;
    private final Map<Object, ObjectTypeConf> typeConfMap = new ConcurrentHashMap<Object, ObjectTypeConf>();
    private final InternalRuleBase ruleBase;

    public ObjectTypeConfigurationRegistry(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public ObjectTypeConf getObjectTypeConf(Object object) {
        return this.typeConfMap.get(this.getKey(object));
    }

    public ObjectTypeConf getOrCreateObjectTypeConf(EntryPointId entrypoint, Object object) {
        ObjectTypeConf existingConf;
        Object key = this.getKey(object);
        ObjectTypeConf conf = this.typeConfMap.get(key);
        if (conf == null && (existingConf = this.typeConfMap.putIfAbsent(key, conf = this.createObjectTypeConf(entrypoint, key, object))) != null) {
            conf = existingConf;
        }
        return conf;
    }

    private Object getKey(Object object) {
        if (object instanceof RuleTerminalNodeLeftTuple) {
            return ClassObjectType.Match_ObjectType.getClassType();
        }
        if (object instanceof FactImpl) {
            return ((FactImpl)object).getFactTemplate().getName();
        }
        if (object instanceof Fact) {
            return ((Fact)object).getFactTemplate().getName();
        }
        if (object instanceof InternalMatch) {
            return ClassObjectType.Match_ObjectType.getClassType();
        }
        return object.getClass();
    }

    private ObjectTypeConf createObjectTypeConf(EntryPointId entrypoint, Object key, Object object) {
        return object instanceof Fact ? new FactTemplateTypeConf(entrypoint, ((Fact)object).getFactTemplate(), this.ruleBase) : new ClassObjectTypeConf(entrypoint, (Class)key, this.ruleBase);
    }

    public ObjectTypeConf getConfForObjectType(ObjectType objectType) {
        return this.typeConfMap.get(objectType.getTypeKey());
    }

    public Collection<ObjectTypeConf> values() {
        return this.typeConfMap.values();
    }
}

