/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.base.rule.ConditionalElement;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.QueryArgument;
import org.drools.base.rule.RuleConditionElement;

public class QueryElement
extends ConditionalElement
implements Externalizable {
    private Pattern resultPattern;
    private String queryName;
    private QueryArgument[] arguments;
    private int[] variableIndexes;
    private boolean openQuery;
    private boolean abductive;
    private Declaration[] requiredDeclarations;

    public QueryElement() {
    }

    public QueryElement(Pattern resultPattern, String queryName, QueryArgument[] arguments, int[] variableIndexes, Declaration[] requiredDeclarations, boolean openQuery, boolean abductive) {
        this.resultPattern = resultPattern;
        this.queryName = queryName;
        this.arguments = arguments;
        this.variableIndexes = variableIndexes;
        this.requiredDeclarations = requiredDeclarations;
        this.openQuery = openQuery;
        this.abductive = abductive;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.resultPattern);
        out.writeObject(this.queryName);
        out.writeObject(this.arguments);
        out.writeObject(this.variableIndexes);
        out.writeObject(this.requiredDeclarations);
        out.writeBoolean(this.openQuery);
        out.writeBoolean(this.abductive);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.resultPattern = (Pattern)in.readObject();
        this.queryName = (String)in.readObject();
        this.arguments = (QueryArgument[])in.readObject();
        this.variableIndexes = (int[])in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.openQuery = in.readBoolean();
        this.abductive = in.readBoolean();
    }

    public int[] getVariableIndexes() {
        return this.variableIndexes;
    }

    public void setVariableIndexes(int[] variableIndexes) {
        this.variableIndexes = variableIndexes;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public QueryArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.resultPattern.getInnerDeclarations();
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return this.resultPattern.getOuterDeclarations();
    }

    @Override
    public List<? extends RuleConditionElement> getNestedElements() {
        return Collections.EMPTY_LIST;
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public boolean isAbductive() {
        return this.abductive;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.resultPattern.resolveDeclaration(identifier);
    }

    @Override
    public QueryElement clone() {
        return new QueryElement(this.resultPattern.clone(), this.queryName, this.arguments, this.variableIndexes, this.requiredDeclarations, this.openQuery, this.abductive);
    }

    public String toString() {
        return "QueryElement [resultPattern=" + this.resultPattern + ", queryName=" + this.queryName + ", argTemplate=" + Arrays.toString(this.arguments) + ", openQuery=" + this.openQuery + ", abductive=" + this.abductive + ", requiredDeclarations=" + Arrays.toString(this.requiredDeclarations) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.abductive ? 1231 : 1237);
        result = 31 * result + (this.queryName == null ? 0 : this.queryName.hashCode());
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + (this.resultPattern == null ? 0 : this.resultPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryElement other = (QueryElement)obj;
        if (!Arrays.equals(this.arguments, other.arguments)) {
            return false;
        }
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (this.abductive != other.abductive) {
            return false;
        }
        if (this.queryName == null ? other.queryName != null : !this.queryName.equals(other.queryName)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        return !(this.resultPattern == null ? other.resultPattern != null : !this.resultPattern.equals(other.resultPattern));
    }
}

