/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.descr.RestrictionDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConnectiveDescr
extends RestrictionDescr {
    private static final long serialVersionUID = 510L;
    public static final RestrictionConnectiveType AND = RestrictionConnectiveType.AND;
    public static final RestrictionConnectiveType OR = RestrictionConnectiveType.OR;
    private RestrictionConnectiveType connective;
    private List<Object> restrictions;

    public StringConnectiveDescr(RestrictionConnectiveType connective) {
        this.connective = connective;
        this.restrictions = Collections.emptyList();
    }

    public RestrictionConnectiveType getConnective() {
        return this.connective;
    }

    public void add(Object object) {
        if (object instanceof StringConnectiveDescr && ((StringConnectiveDescr)object).connective == this.connective) {
            if (this.restrictions == Collections.EMPTY_LIST) {
                this.restrictions = new ArrayList<Object>();
            }
            this.restrictions.addAll(((StringConnectiveDescr)object).getRestrictions());
        } else {
            this.restrictions.add(object);
        }
    }

    public List<Object> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("( ");
        Iterator<Object> it = this.restrictions.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(this.connective.toString());
        }
        buf.append("  )");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RestrictionConnectiveType {
        AND{

            public String toString() {
                return "&&";
            }
        }
        ,
        OR{

            public String toString() {
                return "||";
            }
        };

    }
}

