/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.core.util.ClassUtils;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.AbstractJavaRuleBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.parser.JavaBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaCatchBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaContainerBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaElseBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaFinalBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaForBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaIfBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaInterfacePointsDescr;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.rule.builder.dialect.java.parser.JavaModifyBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaRetractBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaThrowBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaTryBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaUpdateBlockDescr;
import org.drools.rule.builder.dialect.java.parser.JavaWhileBlockDescr;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PatternExtractor;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConsequenceBuilder
extends AbstractJavaRuleBuilder
implements ConsequenceBuilder {
    private final Pattern lineBreakFinder = Pattern.compile("\\r\\n|\\r|\\n");

    @Override
    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push((RuleConditionElement)context.getRule().getLhs());
        String className = consequenceName + "Consequence";
        RuleDescr ruleDescr = context.getRuleDescr();
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        context.getDeclarationResolver();
        BoundIdentifiers bindings = new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getPackageBuilder().getGlobals(), null, KnowledgeHelper.class);
        String consequenceStr = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
        consequenceStr = consequenceStr + "\n";
        JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, ruleDescr, consequenceStr, bindings);
        if (analysis == null) {
            return;
        }
        ArrayList<JavaBlockDescr> blocks = new ArrayList<JavaBlockDescr>();
        this.buildBlockDescrs(blocks, analysis.getBlockDescrs());
        String fixedConsequence = this.fixBlockDescr(context, consequenceStr, blocks, bindings, decls);
        if (fixedConsequence == null) {
            return;
        }
        fixedConsequence = ((JavaDialect)context.getDialect()).getKnowledgeHelperFixer().fix(fixedConsequence);
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        String[] declrStr = new String[declarations.length];
        int j = 0;
        Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
        while (i$.hasNext()) {
            String str;
            declrStr[j] = str = i$.next();
            declarations[j++] = (Declaration)decls.get(str);
        }
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        for (int i = 0; i < declrStr.length; ++i) {
            declrStr[i] = declarations[i].getIdentifier();
        }
        context.getRule().setRequiredDeclarations(declrStr);
        Map<String, Object> map = this.createVariableContext(className, fixedConsequence, context, declarations, null, usedIdentifiers.getGlobals(), analysis);
        map.put("consequenceName", consequenceName);
        Integer[] indexes = new Integer[declarations.length];
        Boolean[] notPatterns = new Boolean[declarations.length];
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            indexes[i] = i;
            Boolean bl = notPatterns[i] = declarations[i].getExtractor() instanceof PatternExtractor ? Boolean.FALSE : Boolean.TRUE;
            if (indexes[i] != -1) continue;
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), ruleDescr, null, "Internal Error : Unable to find declaration in list while generating the consequence invoker"));
        }
        map.put("indexes", indexes);
        map.put("notPatterns", notPatterns);
        JavaConsequenceBuilder.generatTemplates("consequenceMethod", "consequenceInvoker", context, className, map, context.getRule(), ruleDescr);
        context.getBuildStack().pop();
    }

    protected String fixBlockDescr(RuleBuildContext context, String originalCode, List<JavaBlockDescr> blocks, BoundIdentifiers bindings, Map<String, Declaration> decls) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        Collections.sort(blocks, new Comparator<JavaBlockDescr>(){

            @Override
            public int compare(JavaBlockDescr o1, JavaBlockDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        block4: for (JavaBlockDescr block : blocks) {
            if (block.getEnd() == 0) continue;
            consequence.append(originalCode.substring(lastAdded, block.getStart() - 1));
            lastAdded = block.getEnd();
            switch (block.getType()) {
                case MODIFY: 
                case UPDATE: 
                case RETRACT: {
                    this.rewriteDescr(context, originalCode, mvel, consequence, block, bindings, decls);
                    continue block4;
                }
                case ENTRY: 
                case EXIT: 
                case CHANNEL: {
                    this.rewriteInterfacePoint(context, originalCode, consequence, (JavaInterfacePointsDescr)block);
                    continue block4;
                }
            }
            consequence.append(originalCode.substring(block.getStart() - 1, lastAdded));
        }
        consequence.append(originalCode.substring(lastAdded));
        return consequence.toString();
    }

    public void buildBlockDescrs(List<JavaBlockDescr> descrs, JavaContainerBlockDescr parentBlock) {
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block instanceof JavaContainerBlockDescr) {
                this.buildBlockDescrs(descrs, (JavaContainerBlockDescr)block);
                continue;
            }
            descrs.add(block);
        }
    }

    protected void setContainerBlockInputs(RuleBuildContext context, List<JavaBlockDescr> descrs, JavaContainerBlockDescr parentBlock, String originalCode, BoundIdentifiers bindings, Map<String, Class<?>> parentVars, int offset) {
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block.getEnd() == 0) continue;
            if (block.getType() == JavaBlockDescr.BlockType.TRY) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaTryBlockDescr tryDescr = (JavaTryBlockDescr)block;
                lastAdded = tryDescr.getFinal() != null ? tryDescr.getFinal().getEnd() - offset : tryDescr.getCatches().get(tryDescr.getCatches().size() - 1).getEnd() - offset;
                this.stripTryDescr(context, originalCode, consequence, (JavaTryBlockDescr)block, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.THROW) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaThrowBlockDescr throwBlock = (JavaThrowBlockDescr)block;
                this.addWhiteSpaces(originalCode, consequence, throwBlock.getStart() - offset, throwBlock.getTextStart() - offset);
                consequence.append(originalCode.substring(throwBlock.getTextStart() - offset - 1, throwBlock.getEnd() - 1 - offset) + ";");
                lastAdded = throwBlock.getEnd() - offset;
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.IF) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaIfBlockDescr ifDescr = (JavaIfBlockDescr)block;
                lastAdded = ifDescr.getEnd() - offset;
                this.stripBlockDescr(context, originalCode, consequence, ifDescr, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.ELSE) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaElseBlockDescr elseDescr = (JavaElseBlockDescr)block;
                lastAdded = elseDescr.getEnd() - offset;
                this.stripBlockDescr(context, originalCode, consequence, elseDescr, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.WHILE) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaWhileBlockDescr whileDescr = (JavaWhileBlockDescr)block;
                lastAdded = whileDescr.getEnd() - offset;
                this.stripBlockDescr(context, originalCode, consequence, whileDescr, offset);
                continue;
            }
            if (block.getType() != JavaBlockDescr.BlockType.FOR) continue;
            consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
            JavaForBlockDescr forDescr = (JavaForBlockDescr)block;
            lastAdded = forDescr.getEnd() - offset;
            this.stripBlockDescr(context, originalCode, consequence, forDescr, offset);
        }
        consequence.append(originalCode.substring(lastAdded));
        MacroProcessor macroProcessor = new MacroProcessor();
        HashMap<String, Macro> macros = new HashMap<String, Macro>(MVELConsequenceBuilder.macros);
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "with  ";
            }
        });
        macroProcessor.setMacros(macros);
        String mvelCode = macroProcessor.parse(consequence.toString());
        Map<String, Class<?>> inputs = this.getInputs(context, mvelCode, bindings, parentVars);
        inputs.putAll(parentVars);
        parentBlock.setInputs(inputs);
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block.getType() == JavaBlockDescr.BlockType.TRY) {
                JavaTryBlockDescr tryBlock = (JavaTryBlockDescr)block;
                this.setContainerBlockInputs(context, descrs, tryBlock, originalCode.substring(tryBlock.getTextStart() - offset, tryBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                for (JavaCatchBlockDescr catchBlock : tryBlock.getCatches()) {
                    this.setContainerBlockInputs(context, descrs, catchBlock, catchBlock.getClause() + "=null;" + originalCode.substring(catchBlock.getTextStart() - offset, catchBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                }
                if (tryBlock.getFinal() == null) continue;
                JavaFinalBlockDescr finalBlock = tryBlock.getFinal();
                this.setContainerBlockInputs(context, descrs, finalBlock, originalCode.substring(finalBlock.getTextStart() - offset, finalBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.IF) {
                JavaIfBlockDescr ifBlock = (JavaIfBlockDescr)block;
                int adjustBlock = originalCode.charAt(ifBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                this.setContainerBlockInputs(context, descrs, ifBlock, originalCode.substring(ifBlock.getTextStart() - offset + adjustBlock, ifBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, ifBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.ELSE) {
                JavaElseBlockDescr elseBlock = (JavaElseBlockDescr)block;
                int adjustBlock = originalCode.charAt(elseBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                this.setContainerBlockInputs(context, descrs, elseBlock, originalCode.substring(elseBlock.getTextStart() - offset + adjustBlock, elseBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, elseBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.WHILE) {
                JavaWhileBlockDescr whileBlock = (JavaWhileBlockDescr)block;
                int adjustBlock = originalCode.charAt(whileBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                this.setContainerBlockInputs(context, descrs, whileBlock, originalCode.substring(whileBlock.getTextStart() - offset + adjustBlock, whileBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, whileBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.FOR) {
                JavaForBlockDescr forBlock = (JavaForBlockDescr)block;
                int adjustBlock = originalCode.charAt(forBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                this.setContainerBlockInputs(context, descrs, forBlock, originalCode.substring(forBlock.getStartParen() - offset, forBlock.getInitEnd() - offset) + originalCode.substring(forBlock.getTextStart() - offset + adjustBlock, forBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, forBlock.getTextStart() - (forBlock.getInitEnd() - forBlock.getStartParen()));
                continue;
            }
            block.setInputs(inputs);
            descrs.add(block);
        }
    }

    public Map<String, Class<?>> getInputs(RuleBuildContext context, String code, BoundIdentifiers bindings, Map<String, Class<?>> parentVars) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        MVELAnalysisResult mvelAnalysis = null;
        try {
            mvelAnalysis = (MVELAnalysisResult)mvel.analyzeBlock(context, context.getRuleDescr(), null, code, bindings, parentVars, "drools", KnowledgeHelper.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        return mvelAnalysis != null ? mvelAnalysis.getMvelVariables() : new HashMap();
    }

    private void addWhiteSpaces(String original, StringBuilder consequence, int start, int end) {
        block3: for (int i = start; i < end; ++i) {
            switch (original.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    consequence.append(original.charAt(i));
                    continue block3;
                }
                default: {
                    consequence.append(" ");
                }
            }
        }
    }

    private void stripTryDescr(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaTryBlockDescr block, int offset) {
        this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getTextStart() - offset);
        this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
        for (JavaCatchBlockDescr catchBlock : block.getCatches()) {
            this.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getTextStart() - offset);
            this.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getEnd() - offset);
        }
        if (block.getFinal() != null) {
            this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getTextStart() - offset);
            this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getEnd() - offset);
        }
    }

    private void stripBlockDescr(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaBlockDescr block, int offset) {
        this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
    }

    private void stripElseDescr(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaElseBlockDescr block, int offset) {
        this.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
    }

    private void rewriteInterfacePoint(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaInterfacePointsDescr ep) {
        consequence.append("drools.get");
        if (ep.getType() == JavaBlockDescr.BlockType.EXIT) {
            consequence.append("ExitPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.ENTRY) {
            consequence.append("EntryPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.CHANNEL) {
            consequence.append("Channel( ");
        } else {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), ep, "Unable to rewrite code block: " + ep + "\n"));
            return;
        }
        consequence.append(ep.getId());
        consequence.append(" )");
        String originalBlock = originalCode.substring(ep.getStart() - 1, ep.getEnd());
        int end = originalBlock.indexOf("]");
        this.addLineBreaks(consequence, originalBlock.substring(0, end));
    }

    private boolean rewriteDescr(RuleBuildContext context, String originalCode, MVELDialect mvel, StringBuilder consequence, JavaBlockDescr d, BoundIdentifiers bindings, Map<String, Declaration> decls) {
        if (d.getEnd() == 0) {
            return false;
        }
        boolean typeSafety = context.isTypesafe();
        context.setTypesafe(false);
        Map<String, Class<?>> localTypes = d.getInputs();
        if (d.getInScopeLocalVars() != null && !d.getInScopeLocalVars().isEmpty()) {
            localTypes = new HashMap(d.getInputs() != null ? d.getInputs() : Collections.EMPTY_MAP);
            for (JavaLocalDeclarationDescr local : d.getInScopeLocalVars()) {
                try {
                    Class type = context.getDialect("java").getPackageRegistry().getTypeResolver().resolveType(local.getType());
                    for (JavaLocalDeclarationDescr.IdentifierDescr id : local.getIdentifiers()) {
                        localTypes.put(id.getIdentifier(), type);
                    }
                }
                catch (ClassNotFoundException e) {
                    context.getErrors().add(new DescrBuildError(context.getRuleDescr(), context.getParentDescr(), null, "Unable to resolve type " + local.getType() + ":\n" + e.getMessage()));
                }
            }
        }
        MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)mvel.analyzeBlock(context, context.getRuleDescr(), mvel.getInterceptors(), d.getTargetExpression(), bindings, localTypes, "drools", KnowledgeHelper.class);
        context.setTypesafe(typeSafety);
        if (mvelAnalysis == null) {
            return false;
        }
        Class ret = mvelAnalysis.getReturnType();
        if (ret == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), originalCode, "Unable to determine the resulting type of the expression: " + d.getTargetExpression() + "\n"));
            return false;
        }
        String retString = ClassUtils.canonicalName((Class)ret);
        String declrString = d.getTargetExpression().charAt(0) == '(' ? d.getTargetExpression().substring(1, d.getTargetExpression().length() - 1).trim() : d.getTargetExpression();
        String obj = declrString;
        Declaration declr = decls.get(declrString);
        consequence.append("{ ");
        if (declr == null) {
            obj = "__obj__";
            consequence.append(retString);
            consequence.append(" ");
            consequence.append(obj);
            consequence.append(" = ");
            consequence.append(d.getTargetExpression());
            consequence.append("; ");
        }
        if (declr == null || declr.isInternalFact()) {
            consequence.append("org.drools.FactHandle ");
            consequence.append(obj);
            consequence.append("__Handle2__ = drools.getFactHandle(");
            consequence.append(obj);
            consequence.append(");");
        }
        String originalBlock = originalCode.substring(d.getStart() - 1, d.getEnd());
        if (d instanceof JavaModifyBlockDescr) {
            this.rewriteModifyDescr(context, d, originalBlock, consequence, declr, obj);
        } else if (d instanceof JavaUpdateBlockDescr) {
            this.rewriteUpdateDescr(d, originalBlock, consequence, declr, obj);
        } else if (d instanceof JavaRetractBlockDescr) {
            this.rewriteRetractDescr(d, originalBlock, consequence, declr, obj);
        }
        return declr != null;
    }

    private boolean rewriteModifyDescr(RuleBuildContext context, JavaBlockDescr d, String originalBlock, StringBuilder consequence, Declaration declr, String obj) {
        int end = originalBlock.indexOf("{");
        if (end == -1) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Block missing after modify" + d.getTargetExpression() + " ?\n"));
            return false;
        }
        this.addLineBreaks(consequence, originalBlock.substring(0, end));
        int start = end + 1;
        for (String exprStr : ((JavaModifyBlockDescr)d).getExpressions()) {
            end = originalBlock.indexOf(exprStr, start);
            this.addLineBreaks(consequence, originalBlock.substring(start, end));
            consequence.append(obj + ".");
            consequence.append(exprStr);
            consequence.append("; ");
            start = end + exprStr.length();
        }
        this.addLineBreaks(consequence, originalBlock.substring(end));
        if (declr != null && !declr.isInternalFact()) {
            consequence.append("drools.update( " + obj + "__Handle__ ); }");
        } else {
            consequence.append("drools.update( " + obj + "__Handle2__ ); }");
        }
        return declr != null;
    }

    private boolean rewriteUpdateDescr(JavaBlockDescr d, String originalBlock, StringBuilder consequence, Declaration declr, String obj) {
        if (declr != null && !declr.isInternalFact()) {
            consequence.append("drools.update( " + obj + "__Handle__ ); }");
        } else {
            consequence.append("drools.update( " + obj + "__Handle2__ ); }");
        }
        return declr != null;
    }

    private boolean rewriteRetractDescr(JavaBlockDescr d, String originalBlock, StringBuilder consequence, Declaration declr, String obj) {
        if (declr != null && !declr.isInternalFact()) {
            consequence.append("drools.retract( " + obj + "__Handle__ ); }");
        } else {
            consequence.append("drools.retract( " + obj + "__Handle2__ ); }");
        }
        return declr != null;
    }

    private void addLineBreaks(StringBuilder consequence, String chunk) {
        Matcher m = this.lineBreakFinder.matcher(chunk);
        while (m.find()) {
            consequence.append("\n");
        }
    }
}

