/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.DroolsWarning;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class ResourceTypeDeclarationWarning
extends DroolsWarning {
    private ResourceType declaredResourceType;
    private ResourceType actualResourceType;

    public ResourceTypeDeclarationWarning(Resource resource, ResourceType declaredResourceType, ResourceType actualResourceType) {
        super(resource, ResourceTypeDeclarationWarning.getSpecificMessage(resource, declaredResourceType, actualResourceType));
        this.declaredResourceType = declaredResourceType;
        this.actualResourceType = actualResourceType;
    }

    public ResourceType getDeclaredResourceType() {
        return this.declaredResourceType;
    }

    public void setDeclaredResourceType(ResourceType declaredResourceType) {
        this.declaredResourceType = declaredResourceType;
        this.setMessage(ResourceTypeDeclarationWarning.getSpecificMessage(this.getResource(), this.declaredResourceType, this.actualResourceType));
    }

    public ResourceType getActualResourceType() {
        return this.actualResourceType;
    }

    public void setActualResourceType(ResourceType actualResourceType) {
        this.actualResourceType = actualResourceType;
        this.setMessage(ResourceTypeDeclarationWarning.getSpecificMessage(this.getResource(), this.declaredResourceType, this.actualResourceType));
    }

    public int[] getLines() {
        return new int[0];
    }

    private static String getSpecificMessage(Resource resource, ResourceType declaredResourceType, ResourceType actualResourceType) {
        return "Resource " + resource.getSourcePath() + " was created with type " + actualResourceType + " but is being added as " + declaredResourceType;
    }
}

