/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.support;

import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.lang.Nullable;

public class YamlPropertySourceFactory
implements PropertySourceFactory {
    public PropertySource<?> createPropertySource(@Nullable String name, EncodedResource encodedResource) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{encodedResource.getResource()});
        Properties properties = factory.getObject();
        if (Objects.isNull(properties) || StringUtils.isBlank((CharSequence)encodedResource.getResource().getFilename())) {
            return null;
        }
        return new PropertiesPropertySource(encodedResource.getResource().getFilename(), properties);
    }
}

