/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.undertow;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.aware.TaskEnhanceAware;
import org.dromara.dynamictp.core.support.task.runnable.EnhancedRunnable;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.jboss.threads.EnhancedQueueExecutor;

public class EnhancedQueueExecutorProxy
extends EnhancedQueueExecutor
implements TaskEnhanceAware {
    private List<TaskWrapper> taskWrappers;

    public EnhancedQueueExecutorProxy(EnhancedQueueExecutor.Builder builder) {
        super(builder);
    }

    public EnhancedQueueExecutorProxy(EnhancedQueueExecutor executor) {
        this(new EnhancedQueueExecutor.Builder().setCorePoolSize(executor.getCorePoolSize()).setMaximumPoolSize(executor.getMaximumPoolSize()).setKeepAliveTime(executor.getKeepAliveTime()).setThreadFactory(executor.getThreadFactory()).setTerminationTask(executor.getTerminationTask()).setRegisterMBean(true).setMBeanName(executor.getMBeanName()));
        this.allowCoreThreadTimeOut(executor.allowsCoreThreadTimeOut());
    }

    @Override
    public void execute(Runnable runnable) {
        Runnable dtpRunnable = this.getEnhancedTask(runnable);
        AwareManager.execute((Executor)this, (Runnable)dtpRunnable);
        try {
            super.execute((Runnable)EnhancedRunnable.of((Runnable)dtpRunnable, (Executor)this));
        }
        catch (Throwable e) {
            Throwable[] suppressedExceptions;
            for (Throwable t : suppressedExceptions = e.getSuppressed()) {
                if (!(t instanceof RejectedExecutionException)) continue;
                AwareManager.beforeReject((Runnable)dtpRunnable, (Executor)this);
                return;
            }
            throw e;
        }
    }

    public List<TaskWrapper> getTaskWrappers() {
        return this.taskWrappers;
    }

    public void setTaskWrappers(List<TaskWrapper> taskWrappers) {
        this.taskWrappers = taskWrappers;
    }
}

