/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.jetty;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.adapter.ExecutorAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.AbstractWebServerDtpAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.jetty.SelectorProducerProxy;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.MonitoredQueuedThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.strategy.EatWhatYouKill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.server.WebServer;

public class JettyDtpAdapter
extends AbstractWebServerDtpAdapter<ThreadPool.SizedThreadPool> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettyDtpAdapter.class);
    private static final String TP_PREFIX = "jettyTp";
    private static final String CONNECTORS_FIELD = "connectors";
    private static final String MANAGER_FIELD = "_manager";
    private static final String SELECTORS_FIELD = "_selectors";
    private static final String STRATEGY_FIELD = "_strategy";
    private static final String PRODUCER_FIELD = "_producer";

    @Override
    public void doEnhance(WebServer webServer) {
        JettyWebServer jettyWebServer = (JettyWebServer)webServer;
        ThreadPool threadPool = jettyWebServer.getServer().getThreadPool();
        JettyExecutorAdapter adapter = new JettyExecutorAdapter((ThreadPool.SizedThreadPool)threadPool);
        this.enhanceOriginTask(jettyWebServer, threadPool);
        String tpName = this.getTpName();
        this.executors.put(tpName, new ExecutorWrapper(tpName, (Executor)((Object)adapter)));
    }

    private void enhanceOriginTask(JettyWebServer jettyWebServer, ThreadPool threadPool) {
        Connector[] connectors = (Connector[])ReflectionUtil.getFieldValue((String)CONNECTORS_FIELD, (Object)jettyWebServer);
        if (Objects.isNull(connectors)) {
            return;
        }
        for (Connector connector : connectors) {
            if (!(connector instanceof ServerConnector)) continue;
            SelectorManager selectorManager = (SelectorManager)ReflectionUtil.getFieldValue((String)MANAGER_FIELD, (Object)connector);
            if (Objects.isNull(selectorManager)) {
                return;
            }
            ManagedSelector[] managedSelectors = (ManagedSelector[])ReflectionUtil.getFieldValue((String)SELECTORS_FIELD, (Object)selectorManager);
            if (Objects.isNull(managedSelectors)) {
                return;
            }
            for (ManagedSelector managedSelector : managedSelectors) {
                EatWhatYouKill eatWhatYouKill = (EatWhatYouKill)ReflectionUtil.getFieldValue((String)STRATEGY_FIELD, (Object)managedSelector);
                if (Objects.isNull(eatWhatYouKill)) continue;
                ExecutionStrategy.Producer producer = (ExecutionStrategy.Producer)ReflectionUtil.getFieldValue((String)PRODUCER_FIELD, (Object)eatWhatYouKill);
                SelectorProducerProxy selectorProducerProxy = new SelectorProducerProxy(producer, (Executor)threadPool);
                ReflectionUtil.setFieldValue((String)PRODUCER_FIELD, (Object)eatWhatYouKill, (Object)selectorProducerProxy);
            }
        }
    }

    public void refresh(DtpProperties dtpProperties) {
        this.refresh((ExecutorWrapper)this.executors.get(this.getTpName()), dtpProperties.getPlatforms(), dtpProperties.getJettyTp());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    private static class JettyExecutorAdapter
    implements ExecutorAdapter<ThreadPool.SizedThreadPool> {
        private final ThreadPool.SizedThreadPool executor;

        JettyExecutorAdapter(ThreadPool.SizedThreadPool executor) {
            this.executor = executor;
        }

        public ThreadPool.SizedThreadPool getOriginal() {
            return this.executor;
        }

        public int getCorePoolSize() {
            return this.executor.getMinThreads();
        }

        public void setCorePoolSize(int corePoolSize) {
            this.executor.setMinThreads(corePoolSize);
        }

        public int getMaximumPoolSize() {
            return this.executor.getMaxThreads();
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.executor.setMaxThreads(maximumPoolSize);
        }

        public int getPoolSize() {
            return this.executor.getThreads();
        }

        public int getActiveCount() {
            if (this.executor instanceof QueuedThreadPool) {
                return ((QueuedThreadPool)this.executor).getBusyThreads();
            }
            return -1;
        }

        public int getLargestPoolSize() {
            if (this.executor instanceof MonitoredQueuedThreadPool) {
                return ((MonitoredQueuedThreadPool)this.executor).getMaxBusyThreads();
            }
            return -1;
        }

        public long getCompletedTaskCount() {
            if (this.executor instanceof MonitoredQueuedThreadPool) {
                return ((MonitoredQueuedThreadPool)this.executor).getTasks();
            }
            return -1L;
        }

        public BlockingQueue<Runnable> getQueue() {
            return (BlockingQueue)ReflectionUtil.getFieldValue(QueuedThreadPool.class, (String)"_jobs", (Object)this.executor);
        }

        public long getKeepAliveTime(TimeUnit unit) {
            if (this.executor instanceof QueuedThreadPool) {
                return ((QueuedThreadPool)this.executor).getIdleTimeout();
            }
            return 0L;
        }
    }
}

