/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.plugin;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.dromara.dynamictp.common.plugin.DtpInterceptor;
import org.dromara.dynamictp.common.plugin.DtpIntercepts;
import org.dromara.dynamictp.common.plugin.DtpInvocationHandler;
import org.dromara.dynamictp.common.plugin.DtpSignature;
import org.dromara.dynamictp.common.plugin.PluginException;
import org.dromara.dynamictp.common.util.UUIDUtil;

public class DtpInterceptorProxyFactory {
    private DtpInterceptorProxyFactory() {
    }

    public static Object enhance(Object target, DtpInterceptor interceptor) {
        return DtpInterceptorProxyFactory.enhance(target, null, null, interceptor);
    }

    public static Object enhance(Object target, Class<?>[] argumentTypes, Object[] arguments, DtpInterceptor interceptor) {
        Map<Class<?>, Set<Method>> signatureMap = DtpInterceptorProxyFactory.getSignatureMap(interceptor);
        if (!signatureMap.containsKey(target.getClass())) {
            return target;
        }
        try {
            Class proxyClass = new ByteBuddy().subclass(target.getClass()).name(String.format("%s$ByteBuddy$%s", target.getClass().getName(), UUIDUtil.genUuid(5))).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new DtpInvocationHandler(target, interceptor, signatureMap))).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).annotateType(target.getClass().getAnnotations()).make().load(DtpInterceptorProxyFactory.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
            if (Objects.isNull(argumentTypes) || Objects.isNull(arguments)) {
                return proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return proxyClass.getDeclaredConstructor(argumentTypes).newInstance(arguments);
        }
        catch (Exception e) {
            throw new PluginException("Failed to create proxy instance", e);
        }
    }

    private static Map<Class<?>, Set<Method>> getSignatureMap(DtpInterceptor interceptor) {
        DtpIntercepts interceptsAnno = interceptor.getClass().getAnnotation(DtpIntercepts.class);
        if (interceptsAnno == null) {
            throw new PluginException("No @DtpIntercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        DtpSignature[] signatures = interceptsAnno.signatures();
        HashMap signatureMap = Maps.newHashMap();
        for (DtpSignature signature : signatures) {
            Set methods = signatureMap.computeIfAbsent(signature.clazz(), k -> new HashSet());
            try {
                Method method = signature.clazz().getMethod(signature.method(), signature.args());
                methods.add(method);
            }
            catch (NoSuchMethodException e) {
                throw new PluginException("Could not find method on " + String.valueOf(signature.clazz()) + " named " + signature.method() + ". Cause: " + String.valueOf(e), e);
            }
        }
        return signatureMap;
    }
}

