/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.notifier;

import cn.hutool.core.net.url.UrlBuilder;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.entity.MarkdownReq;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractHttpNotifier;
import org.dromara.dynamictp.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatNotifier
extends AbstractHttpNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WechatNotifier.class);

    @Override
    public String platform() {
        return NotifyPlatformEnum.WECHAT.name().toLowerCase();
    }

    @Override
    protected String buildMsgBody(NotifyPlatform platform, String content) {
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setContent(content);
        markdownReq.setMarkdown(markdown);
        return JsonUtil.toJson(markdownReq);
    }

    @Override
    protected String buildUrl(NotifyPlatform platform) {
        if (StringUtils.isBlank((CharSequence)platform.getUrlKey())) {
            return platform.getWebhook();
        }
        UrlBuilder builder = UrlBuilder.of((String)Optional.ofNullable(platform.getWebhook()).orElse("https://qyapi.weixin.qq.com/cgi-bin/webhook/send"));
        if (StringUtils.isBlank((CharSequence)builder.getQuery().get((CharSequence)"key"))) {
            builder.addQuery("key", (Object)platform.getUrlKey());
        }
        return builder.build();
    }
}

