/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;

public class ExtensionServiceLoader {
    private static final Map<Class<?>, List<?>> EXTENSION_MAP = new ConcurrentHashMap();

    private ExtensionServiceLoader() {
    }

    public static <T> List<T> get(Class<T> clazz) {
        List<Object> services = EXTENSION_MAP.get(clazz);
        if (CollectionUtils.isEmpty(services) && CollectionUtils.isNotEmpty(services = ExtensionServiceLoader.load(clazz))) {
            EXTENSION_MAP.put(clazz, services);
        }
        return services;
    }

    public static <T> T getFirst(Class<T> clazz) {
        List<T> services = ExtensionServiceLoader.get(clazz);
        return CollectionUtils.isEmpty(services) ? null : (T)services.get(0);
    }

    private static <T> List<T> load(Class<T> clazz) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        ArrayList<T> services = new ArrayList<T>();
        for (T service : serviceLoader) {
            services.add(service);
        }
        return services;
    }
}

