/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;

public final class BeanCopierUtil {
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = new ConcurrentHashMap<String, BeanCopier>();

    public static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass) {
        String key = BeanCopierUtil.generateKey(sourceClass, targetClass);
        return BEAN_COPIER_CACHE.computeIfAbsent(key, k -> BeanCopier.create((Class)sourceClass, (Class)targetClass, (boolean)false));
    }

    private static String generateKey(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass.getName() + ":" + targetClass.getName();
    }

    public static void copyProperties(Object source, Object target) {
        BeanCopier copier = BeanCopierUtil.getBeanCopier(source.getClass(), target.getClass());
        copier.copy(source, target, null);
    }

    private BeanCopierUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

