/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.adapter.common;

import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import com.github.dadiyang.equator.GetterBaseEquator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.adapter.common.DtpAdapter;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.entity.ThreadPoolStats;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.entity.TpMainFields;
import org.dromara.dynamictp.common.event.CustomContextRefreshedEvent;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.manager.EventBusManager;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.common.util.StreamUtil;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.converter.ExecutorConverter;
import org.dromara.dynamictp.core.notifier.manager.NoticeManager;
import org.dromara.dynamictp.core.notifier.manager.NotifyHelper;
import org.dromara.dynamictp.core.support.DtpLifecycleSupport;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.adapter.ExecutorAdapter;
import org.dromara.dynamictp.core.support.proxy.ThreadPoolExecutorProxy;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDtpAdapter
implements DtpAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDtpAdapter.class);
    private static final Equator EQUATOR = new GetterBaseEquator();
    protected final Map<String, ExecutorWrapper> executors = Maps.newHashMap();

    protected AbstractDtpAdapter() {
        EventBusManager.register((Object)this);
    }

    @Subscribe
    public synchronized void onContextRefreshedEvent(CustomContextRefreshedEvent event) {
        try {
            DtpProperties dtpProperties = (DtpProperties)ContextManagerHelper.getBean(DtpProperties.class);
            this.initialize();
            this.afterInitialize();
            this.refresh(dtpProperties);
            log.info("DynamicTp adapter, {} init end, executors {}", (Object)this.getTpPrefix(), this.executors.keySet());
        }
        catch (Throwable e) {
            log.error("DynamicTp adapter, {} init failed.", (Object)this.getTpPrefix(), (Object)e);
        }
    }

    protected void initialize() {
    }

    protected void afterInitialize() {
        this.getExecutorWrappers().forEach((k, v) -> AwareManager.register((ExecutorWrapper)v));
    }

    @Override
    public Map<String, ExecutorWrapper> getExecutorWrappers() {
        return this.executors;
    }

    public List<ThreadPoolStats> getMultiPoolStats() {
        Map<String, ExecutorWrapper> executorWrappers = this.getExecutorWrappers();
        if (MapUtils.isEmpty(executorWrappers)) {
            return Collections.emptyList();
        }
        ArrayList threadPoolStats = Lists.newArrayList();
        executorWrappers.forEach((k, v) -> threadPoolStats.add(ExecutorConverter.toMetrics((ExecutorWrapper)v)));
        return threadPoolStats;
    }

    public void refresh(List<TpExecutorProps> propsList, List<NotifyPlatform> platforms) {
        Map<String, ExecutorWrapper> executorWrappers = this.getExecutorWrappers();
        if (CollectionUtils.isEmpty(propsList) || MapUtils.isEmpty(executorWrappers)) {
            return;
        }
        Map tmpMap = StreamUtil.toMap(propsList, TpExecutorProps::getThreadPoolName);
        executorWrappers.forEach((k, v) -> this.refresh((ExecutorWrapper)v, platforms, (TpExecutorProps)tmpMap.get(k)));
    }

    public void refresh(ExecutorWrapper executorWrapper, List<NotifyPlatform> platforms, TpExecutorProps props) {
        if (Objects.isNull(props) || Objects.isNull(executorWrapper) || this.containsInvalidParams(props, log)) {
            return;
        }
        TpMainFields oldFields = this.getTpMainFields(executorWrapper, props);
        this.doRefresh(executorWrapper, platforms, props);
        TpMainFields newFields = this.getTpMainFields(executorWrapper, props);
        if (oldFields.equals((Object)newFields)) {
            log.debug("DynamicTp adapter, main properties of [{}] have not changed.", (Object)executorWrapper.getThreadPoolName());
            return;
        }
        List diffFields = EQUATOR.getDiffFields((Object)oldFields, (Object)newFields);
        List diffKeys = diffFields.stream().map(FieldInfo::getFieldName).collect(Collectors.toList());
        NoticeManager.tryNoticeAsync((ExecutorWrapper)executorWrapper, (TpMainFields)oldFields, diffKeys);
        log.info("DynamicTp adapter, [{}] refreshed end, changed keys: {}, corePoolSize: [{}], maxPoolSize: [{}], keepAliveTime: [{}]", new Object[]{executorWrapper.getThreadPoolName(), diffKeys, String.format("%s => %s", oldFields.getCorePoolSize(), newFields.getCorePoolSize()), String.format("%s => %s", oldFields.getMaxPoolSize(), newFields.getMaxPoolSize()), String.format("%s => %s", oldFields.getKeepAliveTime(), newFields.getKeepAliveTime())});
    }

    protected TpMainFields getTpMainFields(ExecutorWrapper executorWrapper, TpExecutorProps props) {
        return ExecutorConverter.toMainFields((ExecutorWrapper)executorWrapper);
    }

    protected abstract String getTpPrefix();

    protected void enhanceOriginExecutor(String tpName, ThreadPoolExecutor executor, String fieldName, Object targetObj) {
        ThreadPoolExecutorProxy proxy = new ThreadPoolExecutorProxy(executor);
        boolean r = ReflectionUtil.setFieldValue((String)fieldName, (Object)targetObj, (Object)proxy);
        if (r) {
            this.putAndFinalize(tpName, executor, (Executor)proxy);
        }
    }

    protected void enhanceOriginExecutor(String tpName, ThreadPoolExecutor executor, Field field, Object targetObj) {
        ThreadPoolExecutorProxy proxy = new ThreadPoolExecutorProxy(executor);
        boolean r = ReflectionUtil.setFieldValue((Field)field, (Object)targetObj, (Object)proxy);
        if (r) {
            this.putAndFinalize(tpName, executor, (Executor)proxy);
        }
    }

    protected void enhanceOriginExecutorWithoutFinalize(String tpName, ThreadPoolExecutorProxy proxy, String fieldName, Object targetObj) {
        ReflectionUtil.setFieldValue((String)fieldName, (Object)targetObj, (Object)proxy);
        this.executors.put(tpName, new ExecutorWrapper(tpName, (Executor)proxy));
    }

    protected void putAndFinalize(String tpName, ExecutorService origin, Executor targetForWrapper) {
        this.executors.put(tpName, new ExecutorWrapper(tpName, targetForWrapper));
        this.shutdownOriginalExecutor(origin);
    }

    protected void shutdownOriginalExecutor(ExecutorService executor) {
        DtpLifecycleSupport.shutdownGracefulAsync((ExecutorService)executor, (String)this.getTpPrefix(), (int)5);
    }

    protected void doRefresh(ExecutorWrapper executorWrapper, List<NotifyPlatform> platforms, TpExecutorProps props) {
        ExecutorAdapter executor = executorWrapper.getExecutor();
        this.doRefreshPoolSize(executor, props);
        if (!Objects.equals(executor.getKeepAliveTime(props.getUnit()), props.getKeepAliveTime())) {
            executor.setKeepAliveTime(props.getKeepAliveTime(), props.getUnit());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getThreadPoolAliasName())) {
            executorWrapper.setThreadPoolAliasName(props.getThreadPoolAliasName());
        }
        List taskWrappers = TaskWrappers.getInstance().getByNames(props.getTaskWrapperNames());
        executorWrapper.setTaskWrappers(taskWrappers);
        NotifyHelper.updateNotifyInfo((ExecutorWrapper)executorWrapper, (TpExecutorProps)props, platforms);
        AwareManager.refresh((ExecutorWrapper)executorWrapper, (TpExecutorProps)props);
    }

    private void doRefreshPoolSize(ExecutorAdapter<?> executor, TpExecutorProps props) {
        if (props.getMaximumPoolSize() >= executor.getMaximumPoolSize()) {
            if (!Objects.equals(props.getMaximumPoolSize(), executor.getMaximumPoolSize())) {
                executor.setMaximumPoolSize(props.getMaximumPoolSize());
            }
            if (!Objects.equals(props.getCorePoolSize(), executor.getCorePoolSize())) {
                executor.setCorePoolSize(props.getCorePoolSize());
            }
            return;
        }
        if (!Objects.equals(props.getCorePoolSize(), executor.getCorePoolSize())) {
            executor.setCorePoolSize(props.getCorePoolSize());
        }
        if (!Objects.equals(props.getMaximumPoolSize(), executor.getMaximumPoolSize())) {
            executor.setMaximumPoolSize(props.getMaximumPoolSize());
        }
    }
}

