/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "yue_Hans" locale.
 */
public class LocalizedNamesImpl_yue_Hans extends LocalizedNamesImpl_yue {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "CN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "VU",
        "BT",
        "TO",
        "TL",
        "CN",
        "MO",
        "HK",
        "CF",
        "DK",
        "IT",
        "UA",
        "UZ",
        "UG",
        "UY",
        "GE",
        "AZ",
        "AM",
        "IL",
        "IQ",
        "IR",
        "EA",
        "RU",
        "BG",
        "HR",
        "CP",
        "GU",
        "IS",
        "GN",
        "GW",
        "LI",
        "CG",
        "CD",
        "LY",
        "GA",
        "CA",
        "IC",
        "HU",
        "KP",
        "MP",
        "TT",
        "GS",
        "AQ",
        "SS",
        "ZA",
        "KR",
        "QA",
        "RW",
        "LU",
        "ID",
        "IN",
        "ER",
        "EC",
        "SY",
        "CU",
        "TW",
        "SZ",
        "YE",
        "KG",
        "DJ",
        "KI",
        "TV",
        "KZ",
        "CO",
        "CR",
        "CM",
        "TC",
        "TM",
        "TR",
        "KN",
        "ST",
        "BL",
        "VC",
        "PM",
        "CX",
        "SH",
        "LC",
        "SM",
        "TZ",
        "EG",
        "TJ",
        "SN",
        "RS",
        "SC",
        "MX",
        "TG",
        "DO",
        "DM",
        "QO",
        "NG",
        "AX",
        "AT",
        "VE",
        "BD",
        "AO",
        "AI",
        "AG",
        "AD",
        "HN",
        "FM",
        "LA",
        "ZM",
        "NI",
        "NE",
        "NP",
        "PS",
        "BS",
        "PK",
        "PG",
        "PY",
        "PA",
        "BH",
        "BR",
        "BB",
        "BF",
        "BV",
        "GR",
        "PW",
        "CK",
        "CW",
        "KY",
        "DE",
        "TK",
        "LV",
        "NO",
        "CZ",
        "MD",
        "MA",
        "MC",
        "FJ",
        "SK",
        "SI",
        "SJ",
        "LK",
        "SG",
        "NC",
        "JP",
        "CL",
        "IM",
        "TD",
        "KH",
        "GG",
        "GD",
        "GL",
        "VA",
        "MU",
        "EZ",
        "EU",
        "BE",
        "BN",
        "SA",
        "FR",
        "TF",
        "MF",
        "GF",
        "PF",
        "FO",
        "PL",
        "PR",
        "BA",
        "BW",
        "TH",
        "JE",
        "HT",
        "AU",
        "IE",
        "EE",
        "JM",
        "TA",
        "SL",
        "BO",
        "SE",
        "CH",
        "GP",
        "GT",
        "WF",
        "GM",
        "RE",
        "BY",
        "BM",
        "PN",
        "GY",
        "GI",
        "FK",
        "KW",
        "CC",
        "XK",
        "PE",
        "TN",
        "LT",
        "SB",
        "SO",
        "JO",
        "NA",
        "NU",
        "NZ",
        "CV",
        "MM",
        "RO",
        "US",
        "UM",
        "VI",
        "AS",
        "UN",
        "KE",
        "FI",
        "SD",
        "SR",
        "GB",
        "IO",
        "VG",
        "MR",
        "NL",
        "BQ",
        "SX",
        "AW",
        "MZ",
        "PH",
        "SV",
        "WS",
        "KM",
        "PT",
        "MN",
        "MS",
        "ME",
        "BI",
        "ET",
        "EH",
        "ES",
        "NF",
        "NR",
        "CI",
        "BJ",
        "BZ",
        "LR",
        "LS",
        "CY",
        "GQ",
        "HM",
        "VN",
        "ZW",
        "GH",
        "DG",
        "AF",
        "DZ",
        "AL",
        "AE",
        "OM",
        "AR",
        "AC",
        "MQ",
        "MK",
        "ML",
        "MT",
        "MV",
        "MW",
        "MY",
        "YT",
        "MH",
        "MG",
        "LB",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("014", "东非");
    namesMap.put("030", "东亚");
    namesMap.put("034", "南亚");
    namesMap.put("035", "东南亚");
    namesMap.put("039", "南欧");
    namesMap.put("053", "澳洲同纽西兰");
    namesMap.put("054", "美拉尼西亚");
    namesMap.put("057", "密克罗尼西亚");
    namesMap.put("061", "玻里尼西亚");
    namesMap.put("142", "亚洲");
    namesMap.put("143", "中亚");
    namesMap.put("145", "西亚");
    namesMap.put("150", "欧洲");
    namesMap.put("151", "东欧");
    namesMap.put("154", "北欧");
    namesMap.put("155", "西欧");
    namesMap.put("AC", "阿森松岛");
    namesMap.put("AD", "安道尔");
    namesMap.put("AE", "阿拉伯联合大公国");
    namesMap.put("AG", "安提瓜同巴布达");
    namesMap.put("AL", "阿尔巴尼亚");
    namesMap.put("AM", "亚美尼亚");
    namesMap.put("AQ", "南极洲");
    namesMap.put("AS", "美属萨摩亚");
    namesMap.put("AT", "奥地利");
    namesMap.put("AW", "荷属阿鲁巴");
    namesMap.put("AX", "奥兰群岛");
    namesMap.put("AZ", "亚塞拜然");
    namesMap.put("BA", "波斯尼亚同黑塞哥维那");
    namesMap.put("BB", "巴贝多");
    namesMap.put("BE", "比利时");
    namesMap.put("BF", "布吉纳法索");
    namesMap.put("BG", "保加利亚");
    namesMap.put("BJ", "贝南");
    namesMap.put("BL", "圣巴瑟米");
    namesMap.put("BM", "百慕达");
    namesMap.put("BN", "汶莱");
    namesMap.put("BO", "玻利维亚");
    namesMap.put("BQ", "荷兰加勒比区");
    namesMap.put("BS", "巴哈马");
    namesMap.put("BV", "布威岛");
    namesMap.put("BY", "白俄罗斯");
    namesMap.put("BZ", "贝里斯");
    namesMap.put("CC", "科科斯（基林）群岛");
    namesMap.put("CD", "刚果（金夏沙）");
    namesMap.put("CF", "中非共和国");
    namesMap.put("CG", "刚果（布拉萨）");
    namesMap.put("CK", "库克群岛");
    namesMap.put("CM", "喀麦隆");
    namesMap.put("CN", "中华人民共和国");
    namesMap.put("CO", "哥伦比亚");
    namesMap.put("CP", "克里派顿岛");
    namesMap.put("CV", "维德角");
    namesMap.put("CW", "库拉索");
    namesMap.put("CX", "圣诞岛");
    namesMap.put("CY", "赛普勒斯");
    namesMap.put("DE", "德国");
    namesMap.put("DG", "迪亚哥加西亚岛");
    namesMap.put("DK", "丹麦");
    namesMap.put("DO", "多明尼加共和国");
    namesMap.put("DZ", "阿尔及利亚");
    namesMap.put("EA", "休达与梅利利亚");
    namesMap.put("EE", "爱沙尼亚");
    namesMap.put("ER", "厄利垂亚");
    namesMap.put("ET", "衣索比亚");
    namesMap.put("EU", "欧盟");
    namesMap.put("EZ", "欧元区");
    namesMap.put("FI", "芬兰");
    namesMap.put("FJ", "斐济");
    namesMap.put("FK", "福克兰群岛");
    namesMap.put("FM", "密克罗尼西亚群岛");
    namesMap.put("FO", "法罗群岛");
    namesMap.put("FR", "法国");
    namesMap.put("GB", "英国");
    namesMap.put("GD", "格瑞那达");
    namesMap.put("GE", "乔治亚共和国");
    namesMap.put("GF", "法属圭亚那");
    namesMap.put("GG", "根西岛");
    namesMap.put("GH", "迦纳");
    namesMap.put("GI", "直布罗陀");
    namesMap.put("GL", "格陵兰");
    namesMap.put("GM", "甘比亚");
    namesMap.put("GN", "几内亚");
    namesMap.put("GQ", "赤道几内亚");
    namesMap.put("GR", "希腊");
    namesMap.put("GS", "南佐治亚岛同南桑威奇群岛");
    namesMap.put("GT", "瓜地马拉");
    namesMap.put("GU", "关岛");
    namesMap.put("GW", "几内亚比索");
    namesMap.put("GY", "盖亚那");
    namesMap.put("HK", "中华人民共和国香港特别行政区");
    namesMap.put("HM", "赫德岛同麦克唐纳群岛");
    namesMap.put("HR", "克罗埃西亚");
    namesMap.put("IC", "加那利群岛");
    namesMap.put("IE", "爱尔兰");
    namesMap.put("IM", "曼岛");
    namesMap.put("IO", "英属印度洋领地");
    namesMap.put("IS", "冰岛");
    namesMap.put("IT", "义大利");
    namesMap.put("JE", "泽西岛");
    namesMap.put("JM", "牙买加");
    namesMap.put("JO", "约旦");
    namesMap.put("KE", "肯亚");
    namesMap.put("KG", "吉尔吉斯");
    namesMap.put("KN", "圣基茨同尼维斯");
    namesMap.put("KP", "北韩");
    namesMap.put("KR", "南韩");
    namesMap.put("KY", "开曼群岛");
    namesMap.put("KZ", "哈萨克");
    namesMap.put("LA", "寮国");
    namesMap.put("LC", "圣露西亚");
    namesMap.put("LK", "斯里兰卡");
    namesMap.put("LR", "赖比瑞亚");
    namesMap.put("LS", "赖索托");
    namesMap.put("LU", "卢森堡");
    namesMap.put("LV", "拉脱维亚");
    namesMap.put("LY", "利比亚");
    namesMap.put("MC", "摩纳哥");
    namesMap.put("MD", "摩尔多瓦");
    namesMap.put("ME", "蒙特内哥罗");
    namesMap.put("MF", "法属圣马丁");
    namesMap.put("MG", "马达加斯加");
    namesMap.put("MH", "马绍尔群岛");
    namesMap.put("MK", "马其顿");
    namesMap.put("ML", "马利");
    namesMap.put("MM", "缅甸");
    namesMap.put("MO", "中华人民共和国澳门特别行政区");
    namesMap.put("MP", "北马里亚纳群岛");
    namesMap.put("MQ", "马丁尼克岛");
    namesMap.put("MR", "茅利塔尼亚");
    namesMap.put("MS", "蒙哲腊");
    namesMap.put("MT", "马尔他");
    namesMap.put("MV", "马尔地夫");
    namesMap.put("MW", "马拉威");
    namesMap.put("MY", "马来西亚");
    namesMap.put("NA", "纳米比亚");
    namesMap.put("NC", "新喀里多尼亚");
    namesMap.put("NF", "诺福克岛");
    namesMap.put("NG", "奈及利亚");
    namesMap.put("NL", "荷兰");
    namesMap.put("NP", "尼泊尔");
    namesMap.put("NR", "诺鲁");
    namesMap.put("NU", "纽埃岛");
    namesMap.put("NZ", "纽西兰");
    namesMap.put("OM", "阿曼王国");
    namesMap.put("PA", "巴拿马");
    namesMap.put("PE", "秘鲁");
    namesMap.put("PF", "法属玻里尼西亚");
    namesMap.put("PG", "巴布亚纽几内亚");
    namesMap.put("PH", "菲律宾");
    namesMap.put("PL", "波兰");
    namesMap.put("PM", "圣皮埃尔同密克隆群岛");
    namesMap.put("PN", "皮特肯群岛");
    namesMap.put("PS", "巴勒斯坦自治区");
    namesMap.put("QA", "卡达");
    namesMap.put("QO", "大洋洲边疆群岛");
    namesMap.put("RO", "罗马尼亚");
    namesMap.put("RS", "塞尔维亚");
    namesMap.put("RU", "俄罗斯");
    namesMap.put("RW", "卢安达");
    namesMap.put("SA", "沙乌地阿拉伯");
    namesMap.put("SB", "索罗门群岛");
    namesMap.put("SC", "塞席尔");
    namesMap.put("SD", "苏丹");
    namesMap.put("SH", "圣赫勒拿岛");
    namesMap.put("SI", "斯洛维尼亚");
    namesMap.put("SJ", "斯瓦尔巴特群岛同扬马延岛");
    namesMap.put("SL", "狮子山");
    namesMap.put("SM", "圣马利诺");
    namesMap.put("SN", "塞内加尔");
    namesMap.put("SO", "索马利亚");
    namesMap.put("SR", "苏利南");
    namesMap.put("SS", "南苏丹");
    namesMap.put("ST", "圣多美同普林西比");
    namesMap.put("SV", "萨尔瓦多");
    namesMap.put("SX", "荷属圣马丁");
    namesMap.put("SY", "叙利亚");
    namesMap.put("SZ", "史瓦济兰");
    namesMap.put("TA", "特里斯坦达库尼亚群岛");
    namesMap.put("TC", "土克斯及开科斯群岛");
    namesMap.put("TF", "法属南方属地");
    namesMap.put("TH", "泰国");
    namesMap.put("TK", "托克劳群岛");
    namesMap.put("TL", "东帝汶");
    namesMap.put("TM", "土库曼");
    namesMap.put("TN", "突尼西亚");
    namesMap.put("TO", "东加");
    namesMap.put("TT", "千里达同多巴哥");
    namesMap.put("TV", "吐瓦鲁");
    namesMap.put("TW", "台湾");
    namesMap.put("TZ", "坦尚尼亚");
    namesMap.put("UA", "乌克兰");
    namesMap.put("UG", "乌干达");
    namesMap.put("UM", "美国本土外小岛屿");
    namesMap.put("UN", "联合国");
    namesMap.put("US", "美国");
    namesMap.put("UY", "乌拉圭");
    namesMap.put("UZ", "乌兹别克");
    namesMap.put("VA", "梵蒂冈");
    namesMap.put("VC", "圣文森特同格林纳丁斯");
    namesMap.put("VE", "委内瑞拉");
    namesMap.put("VG", "英属维京群岛");
    namesMap.put("VI", "美属维京群岛");
    namesMap.put("VU", "万那杜");
    namesMap.put("WF", "瓦利斯同富图纳群岛");
    namesMap.put("WS", "萨摩亚");
    namesMap.put("YE", "叶门");
    namesMap.put("YT", "马约特");
    namesMap.put("ZM", "尚比亚");
    namesMap.put("ZZ", "未知区域");
  }

}
