/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "nn" locale.
 */
public class LocalizedNamesImpl_nn extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AT",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "CA",
        "KY",
        "EA",
        "CL",
        "CX",
        "CP",
        "CO",
        "CK",
        "CR",
        "CU",
        "CW",
        "DK",
        "VI",
        "VG",
        "TF",
        "AE",
        "DO",
        "CF",
        "IO",
        "DG",
        "DJ",
        "DM",
        "EC",
        "EG",
        "GQ",
        "CI",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "PF",
        "FO",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "GR",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KH",
        "CM",
        "IC",
        "CV",
        "BQ",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CC",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "KW",
        "BY",
        "CY",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NL",
        "NP",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "KP",
        "MP",
        "NO",
        "NF",
        "NC",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "SH",
        "KN",
        "MF",
        "PM",
        "SB",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "UN",
        "SO",
        "ES",
        "LK",
        "LC",
        "VC",
        "GB",
        "SD",
        "SR",
        "SJ",
        "CH",
        "SE",
        "SZ",
        "SY",
        "ZA",
        "GS",
        "KR",
        "SS",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TM",
        "TC",
        "TV",
        "TR",
        "DE",
        "UG",
        "UA",
        "HU",
        "UY",
        "US",
        "UM",
        "UZ",
        "VU",
        "VA",
        "VE",
        "EH",
        "VN",
        "WF",
        "XA",
        "XB",
        "QO",
        "ZM",
        "ZW",
        "AX",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "verda");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nord-Amerika");
    namesMap.put("005", "Sør-Amerika");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Vest-Afrika");
    namesMap.put("013", "Sentral-Amerika");
    namesMap.put("014", "Aust-Afrika");
    namesMap.put("015", "Nord-Afrika");
    namesMap.put("017", "Sentral-Afrika");
    namesMap.put("018", "Sørlege Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "nordlege Amerika");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Aust-Asia");
    namesMap.put("034", "Sør-Asia");
    namesMap.put("035", "Søraust-Asia");
    namesMap.put("039", "Sør-Europa");
    namesMap.put("057", "Mikronesia");
    namesMap.put("143", "Sentral-Asia");
    namesMap.put("145", "Vest-Asia");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Aust-Europa");
    namesMap.put("154", "Nord-Europa");
    namesMap.put("155", "Vest-Europa");
    namesMap.put("419", "Latin-Amerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Dei sameinte arabiske emirata");
    namesMap.put("AG", "Antigua og Barbuda");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerikansk Samoa");
    namesMap.put("AT", "Austerrike");
    namesMap.put("AX", "Åland");
    namesMap.put("AZ", "Aserbajdsjan");
    namesMap.put("BA", "Bosnia-Hercegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BQ", "Karibisk Nederland");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Bouvetøya");
    namesMap.put("BY", "Kviterussland");
    namesMap.put("CC", "Kokosøyane");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Den sentralafrikanske republikken");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Sveits");
    namesMap.put("CI", "Elfenbeinskysten");
    namesMap.put("CK", "Cookøyane");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CP", "Clippertonøya");
    namesMap.put("CV", "Kapp Verde");
    namesMap.put("CX", "Christmasøya");
    namesMap.put("CY", "Kypros");
    namesMap.put("CZ", "Tsjekkia");
    namesMap.put("DE", "Tyskland");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Den dominikanske republikken");
    namesMap.put("DZ", "Algerie");
    namesMap.put("EA", "Ceuta og Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EH", "Vest-Sahara");
    namesMap.put("ES", "Spania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EZ", "eurosona");
    namesMap.put("FK", "Falklandsøyane");
    namesMap.put("FM", "Mikronesiaføderasjonen");
    namesMap.put("FO", "Færøyane");
    namesMap.put("FR", "Frankrike");
    namesMap.put("GB", "Storbritannia");
    namesMap.put("GF", "Fransk Guyana");
    namesMap.put("GL", "Grønland");
    namesMap.put("GQ", "Ekvatorial-Guinea");
    namesMap.put("GR", "Hellas");
    namesMap.put("GS", "Sør-Georgia og Sør-Sandwichøyene");
    namesMap.put("HK", "Hongkong S.A.R. Kina");
    namesMap.put("HM", "Heardøya og McDonaldøyane");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Kanariøyane");
    namesMap.put("IE", "Irland");
    namesMap.put("IM", "Man");
    namesMap.put("IO", "Det britiske territoriet I Indiahavet");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italia");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambodsja");
    namesMap.put("KM", "Komorane");
    namesMap.put("KN", "Saint Kitts og Nevis");
    namesMap.put("KP", "Nord-Korea");
    namesMap.put("KR", "Sør-Korea");
    namesMap.put("KY", "Caymanøyane");
    namesMap.put("KZ", "Kasakhstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Litauen");
    namesMap.put("MA", "Marokko");
    namesMap.put("MF", "Saint Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalløyane");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MO", "Macao S.A.R. Kina");
    namesMap.put("MP", "Nord-Marianane");
    namesMap.put("MV", "Maldivane");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Ny-Caledonia");
    namesMap.put("NF", "Norfolkøya");
    namesMap.put("NL", "Nederland");
    namesMap.put("NO", "Noreg");
    namesMap.put("PF", "Fransk Polynesia");
    namesMap.put("PG", "Papua Ny-Guinea");
    namesMap.put("PH", "Filippinane");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint-Pierre-et-Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinsk territorium");
    namesMap.put("QO", "Ytre Oseania");
    namesMap.put("RU", "Russland");
    namesMap.put("SA", "Saudi-Arabia");
    namesMap.put("SB", "Salomonøyane");
    namesMap.put("SC", "Seychellane");
    namesMap.put("SE", "Sverige");
    namesMap.put("SH", "Saint Helena");
    namesMap.put("SJ", "Svalbard og Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sør-Sudan");
    namesMap.put("ST", "São Tomé og Príncipe");
    namesMap.put("TC", "Turks- og Caicosøyane");
    namesMap.put("TD", "Tsjad");
    namesMap.put("TF", "Dei franske sørterritoria");
    namesMap.put("TJ", "Tadsjikistan");
    namesMap.put("TL", "Timor-Leste (Aust-Timor)");
    namesMap.put("TR", "Tyrkia");
    namesMap.put("TT", "Trinidad og Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "USAs ytre småøyar");
    namesMap.put("UN", "SN");
    namesMap.put("US", "USA");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikanstaten");
    namesMap.put("VC", "St. Vincent og Grenadinane");
    namesMap.put("VG", "Dei britiske Jomfruøyane");
    namesMap.put("VI", "Dei amerikanske Jomfruøyane");
    namesMap.put("WF", "Wallis og Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Sør-Afrika");
    namesMap.put("ZZ", "ukjent område");
  }

}
