/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ff" locale.
 */
public class LocalizedNamesImpl_ff extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AZ",
        "DZ",
        "AL",
        "DE",
        "AD",
        "AI",
        "AO",
        "AG",
        "AQ",
        "SA",
        "AR",
        "AM",
        "AW",
        "AX",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BR",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BG",
        "BF",
        "BN",
        "BI",
        "BT",
        "BV",
        "TD",
        "CC",
        "CL",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "US",
        "VA",
        "FK",
        "CV",
        "KY",
        "VI",
        "VG",
        "CK",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "EA",
        "ET",
        "EH",
        "EG",
        "EC",
        "SV",
        "AE",
        "IN",
        "ID",
        "ER",
        "ES",
        "EE",
        "EU",
        "EZ",
        "FR",
        "FI",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "GL",
        "GS",
        "GU",
        "GP",
        "GT",
        "HT",
        "HK",
        "HM",
        "IC",
        "IM",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JE",
        "GE",
        "GI",
        "DJ",
        "JO",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "IO",
        "KE",
        "KG",
        "KI",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "HR",
        "CR",
        "CU",
        "KW",
        "GB",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "ML",
        "MG",
        "MW",
        "MV",
        "MY",
        "MT",
        "MQ",
        "MA",
        "YT",
        "ME",
        "MK",
        "MX",
        "MF",
        "FM",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MZ",
        "MR",
        "NA",
        "NR",
        "CZ",
        "CD",
        "CF",
        "DO",
        "NL",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QO",
        "RE",
        "RU",
        "RS",
        "RO",
        "RW",
        "ZM",
        "WS",
        "AS",
        "JP",
        "ST",
        "SM",
        "PM",
        "VC",
        "SN",
        "SH",
        "KN",
        "LC",
        "SL",
        "SC",
        "CN",
        "CY",
        "ZW",
        "SG",
        "SY",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SS",
        "SD",
        "SR",
        "SE",
        "CH",
        "SZ",
        "SX",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TL",
        "TT",
        "TG",
        "TK",
        "TO",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UM",
        "UN",
        "UG",
        "UY",
        "UZ",
        "WF",
        "VU",
        "VE",
        "VN",
        "XA",
        "XB",
        "XK",
        "YE",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Anndoora");
    namesMap.put("AE", "Emiraat Araab Denntuɗe");
    namesMap.put("AF", "Afganistaan");
    namesMap.put("AG", "Antiguwaa e Barbudaa");
    namesMap.put("AI", "Anngiyaa");
    namesMap.put("AL", "Albanii");
    namesMap.put("AM", "Armenii");
    namesMap.put("AO", "Anngolaa");
    namesMap.put("AR", "Arjantiin");
    namesMap.put("AS", "Samowa Amerik");
    namesMap.put("AT", "Otiriis");
    namesMap.put("AU", "Ostaraalii");
    namesMap.put("AW", "Aruuba");
    namesMap.put("AZ", "Ajerbayjaan");
    namesMap.put("BA", "Bosnii Hersegowiin");
    namesMap.put("BB", "Barbadoos");
    namesMap.put("BD", "Banglaadees");
    namesMap.put("BE", "Beljik");
    namesMap.put("BF", "Burkibaa Faaso");
    namesMap.put("BG", "Bulgarii");
    namesMap.put("BH", "Bahreyn");
    namesMap.put("BI", "Burunndi");
    namesMap.put("BJ", "Benee");
    namesMap.put("BM", "Bermudaa");
    namesMap.put("BN", "Burnaay");
    namesMap.put("BO", "Boliwii");
    namesMap.put("BR", "Beresiil");
    namesMap.put("BS", "Bahamaas");
    namesMap.put("BT", "Butaan");
    namesMap.put("BW", "Botswaana");
    namesMap.put("BY", "Belaruus");
    namesMap.put("BZ", "Beliise");
    namesMap.put("CA", "Kanadaa");
    namesMap.put("CD", "Ndenndaandi Demokaraasiire Konngo");
    namesMap.put("CF", "Ndenndaandi Santarafrik");
    namesMap.put("CG", "Konngo");
    namesMap.put("CH", "Suwiis");
    namesMap.put("CI", "Kodduwaar");
    namesMap.put("CK", "Duuɗe Kuuk");
    namesMap.put("CL", "Cilii");
    namesMap.put("CM", "Kameruun");
    namesMap.put("CN", "Siin");
    namesMap.put("CO", "Kolombiya");
    namesMap.put("CR", "Kosta Rikaa");
    namesMap.put("CU", "Kubaa");
    namesMap.put("CV", "Duuɗe Kap Weer");
    namesMap.put("CY", "Siipar");
    namesMap.put("CZ", "Ndenndaandi Cek");
    namesMap.put("DE", "Almaañ");
    namesMap.put("DJ", "Jibutii");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Ndenndanndi Dominika");
    namesMap.put("DZ", "Alaseri");
    namesMap.put("EC", "Ekuwatoor");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Ejipt");
    namesMap.put("ER", "Eriteree");
    namesMap.put("ES", "Espaañ");
    namesMap.put("ET", "Ecoppi");
    namesMap.put("FI", "Fenland");
    namesMap.put("FJ", "Fijji");
    namesMap.put("FK", "Duuɗe Falkland");
    namesMap.put("FM", "Mikoronesii");
    namesMap.put("FR", "Farayse");
    namesMap.put("GA", "Gaboo");
    namesMap.put("GB", "Laamateeri Rentundi");
    namesMap.put("GD", "Garnaad");
    namesMap.put("GE", "Jeorgii");
    namesMap.put("GF", "Giyaan Farayse");
    namesMap.put("GH", "Ganaa");
    namesMap.put("GI", "Jibraltaar");
    namesMap.put("GL", "Gorwendland");
    namesMap.put("GM", "Gammbi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwaadalup");
    namesMap.put("GQ", "Ginee Ekuwaatoriyaal");
    namesMap.put("GR", "Gerees");
    namesMap.put("GT", "Gwaatemalaa");
    namesMap.put("GU", "Guwam");
    namesMap.put("GW", "Gine-Bisaawo");
    namesMap.put("GY", "Giyaan");
    namesMap.put("HN", "Onnduraas");
    namesMap.put("HR", "Korwasii");
    namesMap.put("HT", "Haytii");
    namesMap.put("HU", "Onngiri");
    namesMap.put("ID", "Enndonesii");
    namesMap.put("IE", "Irlannda");
    namesMap.put("IL", "Israa’iila");
    namesMap.put("IN", "Enndo");
    namesMap.put("IO", "Keeriindi britaani to maayo enndo");
    namesMap.put("IQ", "Iraak");
    namesMap.put("IR", "Iraan");
    namesMap.put("IS", "Islannda");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamayka");
    namesMap.put("JO", "Jordani");
    namesMap.put("JP", "Sapoo");
    namesMap.put("KE", "Keñaa");
    namesMap.put("KG", "Kirgistaan");
    namesMap.put("KH", "Kambodso");
    namesMap.put("KI", "Kiribari");
    namesMap.put("KM", "Komoor");
    namesMap.put("KN", "Sent Kits e Newis");
    namesMap.put("KP", "Koree Rewo");
    namesMap.put("KR", "Koree Worgo");
    namesMap.put("KW", "Kuweyti");
    namesMap.put("KY", "Duuɗe Kaymaa");
    namesMap.put("KZ", "Kasakstaan");
    namesMap.put("LA", "Lawoos");
    namesMap.put("LB", "Libaa");
    namesMap.put("LC", "Sent Lusiyaa");
    namesMap.put("LI", "Lincenstayn");
    namesMap.put("LK", "Siri Lanka");
    namesMap.put("LR", "Liberiyaa");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituaanii");
    namesMap.put("LU", "Liksembuur");
    namesMap.put("LV", "Letonii");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Maruk");
    namesMap.put("MC", "Monaakoo");
    namesMap.put("MD", "Moldawii");
    namesMap.put("MG", "Madagaskaar");
    namesMap.put("MH", "Duuɗe Marsaal");
    namesMap.put("MK", "Meceduwaan");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Miyamaar");
    namesMap.put("MN", "Monngolii");
    namesMap.put("MP", "Duuɗe Mariyaana Rewo");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Muritani");
    namesMap.put("MS", "Monseraat");
    namesMap.put("MT", "Malte");
    namesMap.put("MU", "Moriis");
    namesMap.put("MV", "Maldiiwe");
    namesMap.put("MW", "Malaawi");
    namesMap.put("MX", "Meksik");
    namesMap.put("MY", "Malesii");
    namesMap.put("MZ", "Mosammbik");
    namesMap.put("NA", "Namibii");
    namesMap.put("NC", "Nuwel Kaledonii");
    namesMap.put("NE", "Nijeer");
    namesMap.put("NF", "Duuɗe Norfolk");
    namesMap.put("NG", "Nijeriyaa");
    namesMap.put("NI", "Nikaraguwaa");
    namesMap.put("NL", "Nederlannda");
    namesMap.put("NO", "Norwees");
    namesMap.put("NP", "Nepaal");
    namesMap.put("NR", "Nawuru");
    namesMap.put("NU", "Niuwe");
    namesMap.put("NZ", "Nuwel Selannda");
    namesMap.put("OM", "Omaan");
    namesMap.put("PA", "Panamaa");
    namesMap.put("PF", "Polinesii Farayse");
    namesMap.put("PG", "Papuwaa Nuwel Gine");
    namesMap.put("PH", "Filipiin");
    namesMap.put("PK", "Pakistaan");
    namesMap.put("PL", "Poloñ");
    namesMap.put("PM", "See Piyeer e Mikeloo");
    namesMap.put("PN", "Pitkern");
    namesMap.put("PR", "Porto Rikoo");
    namesMap.put("PS", "Palestiin Sisjordani e Gaasaa");
    namesMap.put("PT", "Purtugaal");
    namesMap.put("PW", "Palawu");
    namesMap.put("PY", "Paraguwaay");
    namesMap.put("QA", "Kataar");
    namesMap.put("RE", "Rewiñoo");
    namesMap.put("RO", "Rumanii");
    namesMap.put("RU", "Riisii");
    namesMap.put("RW", "Ruwanndaa");
    namesMap.put("SA", "Arabii Sawdit");
    namesMap.put("SB", "Duuɗe Solomon");
    namesMap.put("SC", "Seysel");
    namesMap.put("SD", "Sudaan");
    namesMap.put("SE", "Suweed");
    namesMap.put("SG", "Sinngapuur");
    namesMap.put("SH", "Sent Helen");
    namesMap.put("SI", "Slowenii");
    namesMap.put("SK", "Slowakii");
    namesMap.put("SL", "Seraa liyon");
    namesMap.put("SM", "See Maree");
    namesMap.put("SN", "Senegaal");
    namesMap.put("SO", "Somalii");
    namesMap.put("SR", "Surinaam");
    namesMap.put("ST", "Sawo Tome e Perensipe");
    namesMap.put("SV", "El Salwador");
    namesMap.put("SY", "Sirii");
    namesMap.put("SZ", "Swaasilannda");
    namesMap.put("TC", "Duuɗe Turke e Keikoos");
    namesMap.put("TD", "Caad");
    namesMap.put("TG", "Togoo");
    namesMap.put("TH", "Taylannda");
    namesMap.put("TJ", "Tajikistaan");
    namesMap.put("TK", "Tokelaaw");
    namesMap.put("TL", "Timoor Fuɗnaange");
    namesMap.put("TM", "Turkmenistaan");
    namesMap.put("TN", "Tunisii");
    namesMap.put("TO", "Tonngaa");
    namesMap.put("TR", "Turkii");
    namesMap.put("TT", "Tirnidaad e Tobaago");
    namesMap.put("TV", "Tuwaluu");
    namesMap.put("TW", "Taywaan");
    namesMap.put("TZ", "Tansanii");
    namesMap.put("UA", "Ukereen");
    namesMap.put("UG", "Unganndaa");
    namesMap.put("US", "Dowlaaji Dentuɗi Amerik");
    namesMap.put("UY", "Uruguwaay");
    namesMap.put("UZ", "Usbekistaan");
    namesMap.put("VA", "Dowla Waticaan");
    namesMap.put("VC", "See Weesaa e Garnadiin");
    namesMap.put("VE", "Wenesuwelaa");
    namesMap.put("VG", "duuɗe kecce britanii");
    namesMap.put("VI", "Duuɗe Kecce Amerik");
    namesMap.put("VN", "Wiyetnaam");
    namesMap.put("VU", "Wanuwaatuu");
    namesMap.put("WF", "Walis e Futuna");
    namesMap.put("WS", "Samowaa");
    namesMap.put("YT", "Mayoot");
    namesMap.put("ZA", "Afrik bŋ Worgo");
    namesMap.put("ZM", "Sammbi");
    namesMap.put("ZW", "Simbaabuwe");
  }

}
