/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ca" locale.
 */
public class LocalizedNamesImpl_ca extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ES",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DE",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "BQ",
        "EA",
        "VA",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EG",
        "SV",
        "AE",
        "EC",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GF",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HK",
        "HU",
        "YE",
        "CX",
        "CP",
        "RE",
        "AC",
        "IM",
        "HM",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "GS",
        "FK",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MM",
        "UN",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "NO",
        "NC",
        "NZ",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "GB",
        "CF",
        "ZA",
        "DO",
        "RO",
        "RW",
        "RU",
        "EH",
        "BL",
        "KN",
        "SH",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SJ",
        "SZ",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "IO",
        "QO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "TD",
        "CZ",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "CL",
        "CN",
        "CY",
        "ZM",
        "ZW",
        "EZ",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "Món");
    namesMap.put("002", "Àfrica");
    namesMap.put("003", "Amèrica del Nord");
    namesMap.put("005", "Amèrica del Sud");
    namesMap.put("011", "Àfrica occidental");
    namesMap.put("013", "Amèrica Central");
    namesMap.put("014", "Àfrica oriental");
    namesMap.put("015", "Àfrica septentrional");
    namesMap.put("017", "Àfrica central");
    namesMap.put("018", "Àfrica meridional");
    namesMap.put("019", "Amèrica");
    namesMap.put("021", "Amèrica septentrional");
    namesMap.put("029", "Carib");
    namesMap.put("030", "Àsia oriental");
    namesMap.put("034", "Àsia meridional");
    namesMap.put("035", "Àsia sud-oriental");
    namesMap.put("039", "Europa meridional");
    namesMap.put("053", "Australàsia");
    namesMap.put("054", "Melanèsia");
    namesMap.put("057", "Regió de la Micronèsia");
    namesMap.put("061", "Polinèsia");
    namesMap.put("142", "Àsia");
    namesMap.put("143", "Àsia central");
    namesMap.put("145", "Àsia occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa oriental");
    namesMap.put("154", "Europa septentrional");
    namesMap.put("155", "Europa occidental");
    namesMap.put("202", "Àfrica subsahariana");
    namesMap.put("419", "Amèrica Llatina");
    namesMap.put("AC", "Illa de l’Ascensió");
    namesMap.put("AE", "Emirats Àrabs Units");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua i Barbuda");
    namesMap.put("AL", "Albània");
    namesMap.put("AM", "Armènia");
    namesMap.put("AQ", "Antàrtida");
    namesMap.put("AS", "Samoa Nord-americana");
    namesMap.put("AT", "Àustria");
    namesMap.put("AU", "Austràlia");
    namesMap.put("AX", "Illes Åland");
    namesMap.put("AZ", "Azerbaidjan");
    namesMap.put("BA", "Bòsnia i Hercegovina");
    namesMap.put("BD", "Bangla Desh");
    namesMap.put("BE", "Bèlgica");
    namesMap.put("BG", "Bulgària");
    namesMap.put("BJ", "Benín");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BM", "Bermudes");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BQ", "Carib Neerlandès");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahames");
    namesMap.put("BV", "Bouvet");
    namesMap.put("BY", "Belarús");
    namesMap.put("CA", "Canadà");
    namesMap.put("CC", "Illes Cocos");
    namesMap.put("CF", "República Centreafricana");
    namesMap.put("CH", "Suïssa");
    namesMap.put("CI", "Costa d’Ivori");
    namesMap.put("CK", "Illes Cook");
    namesMap.put("CL", "Xile");
    namesMap.put("CM", "Camerun");
    namesMap.put("CN", "Xina");
    namesMap.put("CO", "Colòmbia");
    namesMap.put("CP", "Illa Clipperton");
    namesMap.put("CV", "Cap Verd");
    namesMap.put("CX", "Illa Christmas");
    namesMap.put("CY", "Xipre");
    namesMap.put("CZ", "Txèquia");
    namesMap.put("DE", "Alemanya");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Algèria");
    namesMap.put("EA", "Ceuta i Melilla");
    namesMap.put("EC", "Equador");
    namesMap.put("EE", "Estònia");
    namesMap.put("EG", "Egipte");
    namesMap.put("EH", "Sàhara Occidental");
    namesMap.put("ES", "Espanya");
    namesMap.put("ET", "Etiòpia");
    namesMap.put("EU", "Unió Europea");
    namesMap.put("EZ", "zona euro");
    namesMap.put("FI", "Finlàndia");
    namesMap.put("FK", "Illes Malvines");
    namesMap.put("FM", "Micronèsia");
    namesMap.put("FO", "Illes Fèroe");
    namesMap.put("FR", "França");
    namesMap.put("GB", "Regne Unit");
    namesMap.put("GE", "Geòrgia");
    namesMap.put("GF", "Guaiana Francesa");
    namesMap.put("GL", "Grenlàndia");
    namesMap.put("GM", "Gàmbia");
    namesMap.put("GQ", "Guinea Equatorial");
    namesMap.put("GR", "Grècia");
    namesMap.put("GS", "Illes Geòrgia del Sud i Sandwich del Sud");
    namesMap.put("GW", "Guinea Bissau");
    namesMap.put("HK", "Hong Kong (RAE Xina)");
    namesMap.put("HM", "Illa Heard i Illes McDonald");
    namesMap.put("HN", "Hondures");
    namesMap.put("HR", "Croàcia");
    namesMap.put("HT", "Haití");
    namesMap.put("HU", "Hongria");
    namesMap.put("IC", "Illes Canàries");
    namesMap.put("ID", "Indonèsia");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Illa de Man");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Territori Britànic de l’Oceà Índic");
    namesMap.put("IS", "Islàndia");
    namesMap.put("IT", "Itàlia");
    namesMap.put("JO", "Jordània");
    namesMap.put("JP", "Japó");
    namesMap.put("KG", "Kirguizistan");
    namesMap.put("KH", "Cambodja");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "Saint Christopher i Nevis");
    namesMap.put("KP", "Corea del Nord");
    namesMap.put("KR", "Corea del Sud");
    namesMap.put("KY", "Illes Caiman");
    namesMap.put("LB", "Líban");
    namesMap.put("LC", "Saint Lucia");
    namesMap.put("LR", "Libèria");
    namesMap.put("LT", "Lituània");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Letònia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Marroc");
    namesMap.put("MC", "Mònaco");
    namesMap.put("MD", "Moldàvia");
    namesMap.put("MF", "Saint Martin");
    namesMap.put("MH", "Illes Marshall");
    namesMap.put("MK", "Macedònia");
    namesMap.put("MM", "Myanmar (Birmània)");
    namesMap.put("MN", "Mongòlia");
    namesMap.put("MO", "Macau (RAE Xina)");
    namesMap.put("MP", "Illes Mariannes del Nord");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MR", "Mauritània");
    namesMap.put("MU", "Maurici");
    namesMap.put("MX", "Mèxic");
    namesMap.put("MY", "Malàisia");
    namesMap.put("MZ", "Moçambic");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Nova Caledònia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NG", "Nigèria");
    namesMap.put("NL", "Països Baixos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zelanda");
    namesMap.put("PA", "Panamà");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Polinèsia Francesa");
    namesMap.put("PG", "Papua Nova Guinea");
    namesMap.put("PH", "Filipines");
    namesMap.put("PL", "Polònia");
    namesMap.put("PM", "Saint-Pierre-et-Miquelon");
    namesMap.put("PN", "Illes Pitcairn");
    namesMap.put("PS", "territoris palestins");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QO", "Territoris allunyats d’Oceania");
    namesMap.put("RE", "Illa de la Reunió");
    namesMap.put("RS", "Sèrbia");
    namesMap.put("RU", "Rússia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Aràbia Saudita");
    namesMap.put("SB", "Illes Salomó");
    namesMap.put("SE", "Suècia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Saint Helena");
    namesMap.put("SI", "Eslovènia");
    namesMap.put("SJ", "Svalbard i Jan Mayen");
    namesMap.put("SK", "Eslovàquia");
    namesMap.put("SO", "Somàlia");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sudan del Sud");
    namesMap.put("ST", "São Tomé i Príncipe");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Swazilàndia");
    namesMap.put("TA", "Tristão da Cunha");
    namesMap.put("TC", "Illes Turks i Caicos");
    namesMap.put("TD", "Txad");
    namesMap.put("TF", "Territoris Australs Francesos");
    namesMap.put("TH", "Tailàndia");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Timor Oriental");
    namesMap.put("TN", "Tunísia");
    namesMap.put("TR", "Turquia");
    namesMap.put("TT", "Trinitat i Tobago");
    namesMap.put("TZ", "Tanzània");
    namesMap.put("UA", "Ucraïna");
    namesMap.put("UM", "Illes Perifèriques Menors dels EUA");
    namesMap.put("UN", "Nacions Unides");
    namesMap.put("US", "Estats Units");
    namesMap.put("UY", "Uruguai");
    namesMap.put("VA", "Ciutat del Vaticà");
    namesMap.put("VC", "Saint Vincent i les Grenadines");
    namesMap.put("VE", "Veneçuela");
    namesMap.put("VG", "Illes Verges Britàniques");
    namesMap.put("VI", "Illes Verges Nord-americanes");
    namesMap.put("WF", "Wallis i Futuna");
    namesMap.put("YE", "Iemen");
    namesMap.put("ZA", "República de Sud-àfrica");
    namesMap.put("ZM", "Zàmbia");
    namesMap.put("ZW", "Zimbàbue");
    namesMap.put("ZZ", "Regió desconeguda");
  }

}
