package org.gwtproject.i18n.shared.cldr.impl;

import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import javax.annotation.Generated;
import org.gwtproject.i18n.shared.cldr.CurrencyData;
import org.gwtproject.i18n.shared.cldr.CurrencyDataImpl;

@Generated("gwt-cldr-importer : org.gwtproject.tools.cldr.CurrencyListProcessor, CLDR version : release-34")
public class CurrencyList_zh_Hans extends CurrencyList_zh {
  public CurrencyData getDefault() {
    return new CurrencyDataImpl("CNY","￥",2,"￥","￥");
  }

  protected HashMap<String, CurrencyData> loadCurrencyMap() {
    HashMap<String,CurrencyData> result = super.loadCurrencyMap();
    // 安道尔比塞塔
    result.put("ADP", new CurrencyDataImpl("ADP","ADP",128,"ADP","ADP"));
    // 阿联酋迪拉姆
    result.put("AED", new CurrencyDataImpl("AED","AED",2,"AED","AED"));
    // 阿富汗尼 (1927–2002)
    result.put("AFA", new CurrencyDataImpl("AFA","AFA",130,"AFA","AFA"));
    // 阿富汗尼
    result.put("AFN", new CurrencyDataImpl("AFN","AFN",0,"AFN","AFN"));
    // 阿尔巴尼亚列克(1946–1965)
    result.put("ALK", new CurrencyDataImpl("ALK","ALK",130,"ALK","ALK"));
    // 阿尔巴尼亚列克
    result.put("ALL", new CurrencyDataImpl("ALL","ALL",0,"ALL","ALL"));
    // 亚美尼亚德拉姆
    result.put("AMD", new CurrencyDataImpl("AMD","AMD",2,"AMD","AMD"));
    // 荷属安的列斯盾
    result.put("ANG", new CurrencyDataImpl("ANG","ANG",2,"ANG","ANG"));
    // 安哥拉宽扎
    result.put("AOA", new CurrencyDataImpl("AOA","AOA",2,"AOA","AOA"));
    // 安哥拉宽扎 (1977–1990)
    result.put("AOK", new CurrencyDataImpl("AOK","AOK",130,"AOK","AOK"));
    // 安哥拉新宽扎 (1990–2000)
    result.put("AON", new CurrencyDataImpl("AON","AON",130,"AON","AON"));
    // 安哥拉重新调整宽扎 (1995–1999)
    result.put("AOR", new CurrencyDataImpl("AOR","AOR",130,"AOR","AOR"));
    // 阿根廷奥斯特拉尔
    result.put("ARA", new CurrencyDataImpl("ARA","ARA",130,"ARA","ARA"));
    // 阿根廷法定比索 (1970–1983)
    result.put("ARL", new CurrencyDataImpl("ARL","ARL",130,"ARL","ARL"));
    // 阿根廷比索 (1881–1970)
    result.put("ARM", new CurrencyDataImpl("ARM","ARM",130,"ARM","ARM"));
    // 阿根廷比索 (1983–1985)
    result.put("ARP", new CurrencyDataImpl("ARP","ARP",130,"ARP","ARP"));
    // 阿根廷比索
    result.put("ARS", new CurrencyDataImpl("ARS","ARS",2,"ARS","ARS"));
    // 奥地利先令
    result.put("ATS", new CurrencyDataImpl("ATS","ATS",130,"ATS","ATS"));
    // 澳大利亚元
    result.put("AUD", new CurrencyDataImpl("AUD","AU$",2,"AU$","AU$"));
    // 阿鲁巴弗罗林
    result.put("AWG", new CurrencyDataImpl("AWG","AWG",2,"AWG","AWG"));
    // 阿塞拜疆马纳特 (1993–2006)
    result.put("AZM", new CurrencyDataImpl("AZM","AZM",130,"AZM","AZM"));
    // 阿塞拜疆马纳特
    result.put("AZN", new CurrencyDataImpl("AZN","AZN",2,"AZN","AZN"));
    // 波士尼亚-赫塞哥维纳第纳尔 (1992–1994)
    result.put("BAD", new CurrencyDataImpl("BAD","BAD",130,"BAD","BAD"));
    // 波斯尼亚-黑塞哥维那可兑换马克
    result.put("BAM", new CurrencyDataImpl("BAM","BAM",2,"BAM","BAM"));
    // 波士尼亚-赫塞哥维纳新第纳尔 (1994–1997)
    result.put("BAN", new CurrencyDataImpl("BAN","BAN",130,"BAN","BAN"));
    // 巴巴多斯元
    result.put("BBD", new CurrencyDataImpl("BBD","BBD",2,"BBD","BBD"));
    // 孟加拉塔卡
    result.put("BDT", new CurrencyDataImpl("BDT","BDT",2,"BDT","BDT"));
    // 比利时法郎（可兑换）
    result.put("BEC", new CurrencyDataImpl("BEC","BEC",130,"BEC","BEC"));
    // 比利时法郎
    result.put("BEF", new CurrencyDataImpl("BEF","BEF",130,"BEF","BEF"));
    // 比利时法郎（金融）
    result.put("BEL", new CurrencyDataImpl("BEL","BEL",130,"BEL","BEL"));
    // 保加利亚硬列弗
    result.put("BGL", new CurrencyDataImpl("BGL","BGL",130,"BGL","BGL"));
    // 保加利亚社会党列弗
    result.put("BGM", new CurrencyDataImpl("BGM","BGM",130,"BGM","BGM"));
    // 保加利亚列弗
    result.put("BGN", new CurrencyDataImpl("BGN","BGN",2,"BGN","BGN"));
    // 保加利亚列弗 (1879–1952)
    result.put("BGO", new CurrencyDataImpl("BGO","BGO",130,"BGO","BGO"));
    // 巴林第纳尔
    result.put("BHD", new CurrencyDataImpl("BHD","BHD",3,"BHD","BHD"));
    // 布隆迪法郎
    result.put("BIF", new CurrencyDataImpl("BIF","BIF",0,"BIF","BIF"));
    // 百慕大元
    result.put("BMD", new CurrencyDataImpl("BMD","BMD",2,"BMD","BMD"));
    // 文莱元
    result.put("BND", new CurrencyDataImpl("BND","BND",2,"BND","BND"));
    // 玻利维亚诺
    result.put("BOB", new CurrencyDataImpl("BOB","BOB",2,"BOB","BOB"));
    // 玻利维亚诺 (1863–1963)
    result.put("BOL", new CurrencyDataImpl("BOL","BOL",130,"BOL","BOL"));
    // 玻利维亚比索
    result.put("BOP", new CurrencyDataImpl("BOP","BOP",130,"BOP","BOP"));
    // 玻利维亚 Mvdol（资金）
    result.put("BOV", new CurrencyDataImpl("BOV","BOV",130,"BOV","BOV"));
    // 巴西新克鲁赛罗 (1967–1986)
    result.put("BRB", new CurrencyDataImpl("BRB","BRB",130,"BRB","BRB"));
    // 巴西克鲁扎多 (1986–1989)
    result.put("BRC", new CurrencyDataImpl("BRC","BRC",130,"BRC","BRC"));
    // 巴西克鲁塞罗 (1990–1993)
    result.put("BRE", new CurrencyDataImpl("BRE","BRE",130,"BRE","BRE"));
    // 巴西雷亚尔
    result.put("BRL", new CurrencyDataImpl("BRL","R$",2,"R$","R$"));
    // 巴西新克鲁扎多 (1989–1990)
    result.put("BRN", new CurrencyDataImpl("BRN","BRN",130,"BRN","BRN"));
    // 巴西克鲁塞罗 (1993–1994)
    result.put("BRR", new CurrencyDataImpl("BRR","BRR",130,"BRR","BRR"));
    // 巴西克鲁塞罗 (1942–1967)
    result.put("BRZ", new CurrencyDataImpl("BRZ","BRZ",130,"BRZ","BRZ"));
    // 巴哈马元
    result.put("BSD", new CurrencyDataImpl("BSD","BSD",2,"BSD","BSD"));
    // 不丹努尔特鲁姆
    result.put("BTN", new CurrencyDataImpl("BTN","BTN",2,"BTN","BTN"));
    // 缅元
    result.put("BUK", new CurrencyDataImpl("BUK","BUK",130,"BUK","BUK"));
    // 博茨瓦纳普拉
    result.put("BWP", new CurrencyDataImpl("BWP","BWP",2,"BWP","BWP"));
    // 白俄罗斯新卢布 (1994–1999)
    result.put("BYB", new CurrencyDataImpl("BYB","BYB",130,"BYB","BYB"));
    // 白俄罗斯卢布
    result.put("BYN", new CurrencyDataImpl("BYN","BYN",2,"BYN","BYN"));
    // 白俄罗斯卢布 (2000–2016)
    result.put("BYR", new CurrencyDataImpl("BYR","BYR",128,"BYR","BYR"));
    // 伯利兹元
    result.put("BZD", new CurrencyDataImpl("BZD","BZD",2,"BZD","BZD"));
    // 加拿大元
    result.put("CAD", new CurrencyDataImpl("CAD","CA$",2,"CA$","CA$"));
    // 刚果法郎
    result.put("CDF", new CurrencyDataImpl("CDF","CDF",2,"CDF","CDF"));
    // 欧元 (WIR)
    result.put("CHE", new CurrencyDataImpl("CHE","CHE",130,"CHE","CHE"));
    // 瑞士法郎
    result.put("CHF", new CurrencyDataImpl("CHF","CHF",2,"CHF","CHF"));
    // 法郎 (WIR)
    result.put("CHW", new CurrencyDataImpl("CHW","CHW",130,"CHW","CHW"));
    // 智利埃斯库多
    result.put("CLE", new CurrencyDataImpl("CLE","CLE",130,"CLE","CLE"));
    // 智利（资金）
    result.put("CLF", new CurrencyDataImpl("CLF","CLF",132,"CLF","CLF"));
    // 智利比索
    result.put("CLP", new CurrencyDataImpl("CLP","CLP",0,"CLP","CLP"));
    // 人民币（离岸）
    result.put("CNH", new CurrencyDataImpl("CNH","CNH",130,"CNH","CNH"));
    // CNX
    result.put("CNX", new CurrencyDataImpl("CNX","CNX",130,"CNX","CNX"));
    // 人民币
    result.put("CNY", new CurrencyDataImpl("CNY","￥",2,"￥","￥"));
    // 哥伦比亚比索
    result.put("COP", new CurrencyDataImpl("COP","COP",2,"COP","COP"));
    // 哥伦比亚币
    result.put("COU", new CurrencyDataImpl("COU","COU",130,"COU","COU"));
    // 哥斯达黎加科朗
    result.put("CRC", new CurrencyDataImpl("CRC","CRC",2,"CRC","CRC"));
    // 旧塞尔维亚第纳尔
    result.put("CSD", new CurrencyDataImpl("CSD","CSD",130,"CSD","CSD"));
    // 捷克硬克朗
    result.put("CSK", new CurrencyDataImpl("CSK","CSK",130,"CSK","CSK"));
    // 古巴可兑换比索
    result.put("CUC", new CurrencyDataImpl("CUC","CUC",2,"CUC","CUC"));
    // 古巴比索
    result.put("CUP", new CurrencyDataImpl("CUP","CUP",2,"CUP","CUP"));
    // 佛得角埃斯库多
    result.put("CVE", new CurrencyDataImpl("CVE","CVE",2,"CVE","CVE"));
    // 塞浦路斯镑
    result.put("CYP", new CurrencyDataImpl("CYP","CYP",130,"CYP","CYP"));
    // 捷克克朗
    result.put("CZK", new CurrencyDataImpl("CZK","CZK",2,"CZK","CZK"));
    // 东德奥斯特马克
    result.put("DDM", new CurrencyDataImpl("DDM","DDM",130,"DDM","DDM"));
    // 德国马克
    result.put("DEM", new CurrencyDataImpl("DEM","DEM",130,"DEM","DEM"));
    // 吉布提法郎
    result.put("DJF", new CurrencyDataImpl("DJF","DJF",0,"DJF","DJF"));
    // 丹麦克朗
    result.put("DKK", new CurrencyDataImpl("DKK","DKK",2,"DKK","DKK"));
    // 多米尼加比索
    result.put("DOP", new CurrencyDataImpl("DOP","DOP",2,"DOP","DOP"));
    // 阿尔及利亚第纳尔
    result.put("DZD", new CurrencyDataImpl("DZD","DZD",2,"DZD","DZD"));
    // 厄瓜多尔苏克雷
    result.put("ECS", new CurrencyDataImpl("ECS","ECS",130,"ECS","ECS"));
    // 厄瓜多尔 (UVC)
    result.put("ECV", new CurrencyDataImpl("ECV","ECV",130,"ECV","ECV"));
    // 爱沙尼亚克朗
    result.put("EEK", new CurrencyDataImpl("EEK","EEK",130,"EEK","EEK"));
    // 埃及镑
    result.put("EGP", new CurrencyDataImpl("EGP","EGP",2,"EGP","EGP"));
    // 厄立特里亚纳克法
    result.put("ERN", new CurrencyDataImpl("ERN","ERN",2,"ERN","ERN"));
    // 西班牙比塞塔（帐户 A）
    result.put("ESA", new CurrencyDataImpl("ESA","ESA",130,"ESA","ESA"));
    // 西班牙比塞塔（兑换帐户）
    result.put("ESB", new CurrencyDataImpl("ESB","ESB",130,"ESB","ESB"));
    // 西班牙比塞塔
    result.put("ESP", new CurrencyDataImpl("ESP","ESP",128,"ESP","ESP"));
    // 埃塞俄比亚比尔
    result.put("ETB", new CurrencyDataImpl("ETB","ETB",2,"ETB","ETB"));
    // 欧元
    result.put("EUR", new CurrencyDataImpl("EUR","€",2,"€","€"));
    // 芬兰马克
    result.put("FIM", new CurrencyDataImpl("FIM","FIM",130,"FIM","FIM"));
    // 斐济元
    result.put("FJD", new CurrencyDataImpl("FJD","FJD",2,"FJD","FJD"));
    // 福克兰群岛镑
    result.put("FKP", new CurrencyDataImpl("FKP","FKP",2,"FKP","FKP"));
    // 法国法郎
    result.put("FRF", new CurrencyDataImpl("FRF","FRF",130,"FRF","FRF"));
    // 英镑
    result.put("GBP", new CurrencyDataImpl("GBP","£",2,"£","£"));
    // 乔治亚库蓬拉瑞特
    result.put("GEK", new CurrencyDataImpl("GEK","GEK",130,"GEK","GEK"));
    // 格鲁吉亚拉里
    result.put("GEL", new CurrencyDataImpl("GEL","₾",2,"₾","₾"));
    // 加纳塞第
    result.put("GHC", new CurrencyDataImpl("GHC","GHC",130,"GHC","GHC"));
    // 加纳塞地
    result.put("GHS", new CurrencyDataImpl("GHS","GHS",2,"GHS","GHS"));
    // 直布罗陀镑
    result.put("GIP", new CurrencyDataImpl("GIP","GIP",2,"GIP","GIP"));
    // 冈比亚达拉西
    result.put("GMD", new CurrencyDataImpl("GMD","GMD",2,"GMD","GMD"));
    // 几内亚法郎
    result.put("GNF", new CurrencyDataImpl("GNF","GNF",0,"GNF","GNF"));
    // 几内亚西里
    result.put("GNS", new CurrencyDataImpl("GNS","GNS",130,"GNS","GNS"));
    // 赤道几内亚埃奎勒
    result.put("GQE", new CurrencyDataImpl("GQE","GQE",130,"GQE","GQE"));
    // 希腊德拉克马
    result.put("GRD", new CurrencyDataImpl("GRD","GRD",130,"GRD","GRD"));
    // 危地马拉格查尔
    result.put("GTQ", new CurrencyDataImpl("GTQ","GTQ",2,"GTQ","GTQ"));
    // 葡萄牙几内亚埃斯库多
    result.put("GWE", new CurrencyDataImpl("GWE","GWE",130,"GWE","GWE"));
    // 几内亚比绍比索
    result.put("GWP", new CurrencyDataImpl("GWP","GWP",130,"GWP","GWP"));
    // 圭亚那元
    result.put("GYD", new CurrencyDataImpl("GYD","GYD",2,"GYD","GYD"));
    // 港元
    result.put("HKD", new CurrencyDataImpl("HKD","HK$",2,"HK$","HK$"));
    // 洪都拉斯伦皮拉
    result.put("HNL", new CurrencyDataImpl("HNL","HNL",2,"HNL","HNL"));
    // 克罗地亚第纳尔
    result.put("HRD", new CurrencyDataImpl("HRD","HRD",130,"HRD","HRD"));
    // 克罗地亚库纳
    result.put("HRK", new CurrencyDataImpl("HRK","HRK",2,"HRK","HRK"));
    // 海地古德
    result.put("HTG", new CurrencyDataImpl("HTG","HTG",2,"HTG","HTG"));
    // 匈牙利福林
    result.put("HUF", new CurrencyDataImpl("HUF","HUF",2,"HUF","HUF"));
    // 印度尼西亚盾
    result.put("IDR", new CurrencyDataImpl("IDR","IDR",2,"IDR","IDR"));
    // 爱尔兰镑
    result.put("IEP", new CurrencyDataImpl("IEP","IEP",130,"IEP","IEP"));
    // 以色列镑
    result.put("ILP", new CurrencyDataImpl("ILP","ILP",130,"ILP","ILP"));
    // 以色列谢克尔(1980–1985)
    result.put("ILR", new CurrencyDataImpl("ILR","ILS",130,"ILS","ILS"));
    // 以色列新谢克尔
    result.put("ILS", new CurrencyDataImpl("ILS","₪",2,"₪","₪"));
    // 印度卢比
    result.put("INR", new CurrencyDataImpl("INR","₹",2,"₹","₹"));
    // 伊拉克第纳尔
    result.put("IQD", new CurrencyDataImpl("IQD","IQD",0,"IQD","IQD"));
    // 伊朗里亚尔
    result.put("IRR", new CurrencyDataImpl("IRR","IRR",0,"IRR","IRR"));
    // 冰岛克朗(1918–1981)
    result.put("ISJ", new CurrencyDataImpl("ISJ","ISJ",130,"ISJ","ISJ"));
    // 冰岛克朗
    result.put("ISK", new CurrencyDataImpl("ISK","ISK",0,"ISK","ISK"));
    // 意大利里拉
    result.put("ITL", new CurrencyDataImpl("ITL","ITL",128,"ITL","ITL"));
    // 牙买加元
    result.put("JMD", new CurrencyDataImpl("JMD","JMD",2,"JMD","JMD"));
    // 约旦第纳尔
    result.put("JOD", new CurrencyDataImpl("JOD","JOD",3,"JOD","JOD"));
    // 日元
    result.put("JPY", new CurrencyDataImpl("JPY","JP¥",0,"JP¥","JP¥"));
    // 肯尼亚先令
    result.put("KES", new CurrencyDataImpl("KES","KES",2,"KES","KES"));
    // 吉尔吉斯斯坦索姆
    result.put("KGS", new CurrencyDataImpl("KGS","KGS",2,"KGS","KGS"));
    // 柬埔寨瑞尔
    result.put("KHR", new CurrencyDataImpl("KHR","KHR",2,"KHR","KHR"));
    // 科摩罗法郎
    result.put("KMF", new CurrencyDataImpl("KMF","KMF",0,"KMF","KMF"));
    // 朝鲜元
    result.put("KPW", new CurrencyDataImpl("KPW","KPW",0,"KPW","KPW"));
    // 韩元 (1953–1962)
    result.put("KRH", new CurrencyDataImpl("KRH","KRH",130,"KRH","KRH"));
    // 韩元 (1945–1953)
    result.put("KRO", new CurrencyDataImpl("KRO","KRO",130,"KRO","KRO"));
    // 韩元
    result.put("KRW", new CurrencyDataImpl("KRW","￦",0,"￦","￦"));
    // 科威特第纳尔
    result.put("KWD", new CurrencyDataImpl("KWD","KWD",3,"KWD","KWD"));
    // 开曼元
    result.put("KYD", new CurrencyDataImpl("KYD","KYD",2,"KYD","KYD"));
    // 哈萨克斯坦坚戈
    result.put("KZT", new CurrencyDataImpl("KZT","KZT",2,"KZT","KZT"));
    // 老挝基普
    result.put("LAK", new CurrencyDataImpl("LAK","LAK",0,"LAK","LAK"));
    // 黎巴嫩镑
    result.put("LBP", new CurrencyDataImpl("LBP","LBP",0,"LBP","LBP"));
    // 斯里兰卡卢比
    result.put("LKR", new CurrencyDataImpl("LKR","LKR",2,"LKR","LKR"));
    // 利比里亚元
    result.put("LRD", new CurrencyDataImpl("LRD","LRD",2,"LRD","LRD"));
    // 莱索托洛蒂
    result.put("LSL", new CurrencyDataImpl("LSL","LSL",2,"LSL","LSL"));
    // 立陶宛立特
    result.put("LTL", new CurrencyDataImpl("LTL","LTL",130,"LTL","LTL"));
    // 立陶宛塔咯呐司
    result.put("LTT", new CurrencyDataImpl("LTT","LTT",130,"LTT","LTT"));
    // 卢森堡可兑换法郎
    result.put("LUC", new CurrencyDataImpl("LUC","LUC",130,"LUC","LUC"));
    // 卢森堡法郎
    result.put("LUF", new CurrencyDataImpl("LUF","LUF",128,"LUF","LUF"));
    // 卢森堡金融法郎
    result.put("LUL", new CurrencyDataImpl("LUL","LUL",130,"LUL","LUL"));
    // 拉脱维亚拉特
    result.put("LVL", new CurrencyDataImpl("LVL","LVL",130,"LVL","LVL"));
    // 拉脱维亚卢布
    result.put("LVR", new CurrencyDataImpl("LVR","LVR",130,"LVR","LVR"));
    // 利比亚第纳尔
    result.put("LYD", new CurrencyDataImpl("LYD","LYD",3,"LYD","LYD"));
    // 摩洛哥迪拉姆
    result.put("MAD", new CurrencyDataImpl("MAD","MAD",2,"MAD","MAD"));
    // 摩洛哥法郎
    result.put("MAF", new CurrencyDataImpl("MAF","MAF",130,"MAF","MAF"));
    // 摩纳哥法郎
    result.put("MCF", new CurrencyDataImpl("MCF","MCF",130,"MCF","MCF"));
    // 摩尔多瓦库邦
    result.put("MDC", new CurrencyDataImpl("MDC","MDC",130,"MDC","MDC"));
    // 摩尔多瓦列伊
    result.put("MDL", new CurrencyDataImpl("MDL","MDL",2,"MDL","MDL"));
    // 马达加斯加阿里亚里
    result.put("MGA", new CurrencyDataImpl("MGA","MGA",0,"MGA","MGA"));
    // 马达加斯加法郎
    result.put("MGF", new CurrencyDataImpl("MGF","MGF",128,"MGF","MGF"));
    // 马其顿第纳尔
    result.put("MKD", new CurrencyDataImpl("MKD","MKD",2,"MKD","MKD"));
    // 马其顿第纳尔 (1992–1993)
    result.put("MKN", new CurrencyDataImpl("MKN","MKN",130,"MKN","MKN"));
    // 马里法郎
    result.put("MLF", new CurrencyDataImpl("MLF","MLF",130,"MLF","MLF"));
    // 缅甸元
    result.put("MMK", new CurrencyDataImpl("MMK","MMK",0,"MMK","MMK"));
    // 蒙古图格里克
    result.put("MNT", new CurrencyDataImpl("MNT","MNT",2,"MNT","MNT"));
    // 澳门币
    result.put("MOP", new CurrencyDataImpl("MOP","MOP",2,"MOP","MOP"));
    // 毛里塔尼亚乌吉亚 (1973–2017)
    result.put("MRO", new CurrencyDataImpl("MRO","MRO",128,"MRO","MRO"));
    // 毛里塔尼亚乌吉亚
    result.put("MRU", new CurrencyDataImpl("MRU","MRU",2,"MRU","MRU"));
    // 马耳他里拉
    result.put("MTL", new CurrencyDataImpl("MTL","MTL",130,"MTL","MTL"));
    // 马耳他镑
    result.put("MTP", new CurrencyDataImpl("MTP","MTP",130,"MTP","MTP"));
    // 毛里求斯卢比
    result.put("MUR", new CurrencyDataImpl("MUR","MUR",2,"MUR","MUR"));
    // 马尔代夫卢比(1947–1981)
    result.put("MVP", new CurrencyDataImpl("MVP","MVP",130,"MVP","MVP"));
    // 马尔代夫卢菲亚
    result.put("MVR", new CurrencyDataImpl("MVR","MVR",2,"MVR","MVR"));
    // 马拉维克瓦查
    result.put("MWK", new CurrencyDataImpl("MWK","MWK",2,"MWK","MWK"));
    // 墨西哥比索
    result.put("MXN", new CurrencyDataImpl("MXN","MX$",2,"MX$","MX$"));
    // 墨西哥银比索 (1861–1992)
    result.put("MXP", new CurrencyDataImpl("MXP","MXP",130,"MXP","MXP"));
    // 墨西哥（资金）
    result.put("MXV", new CurrencyDataImpl("MXV","MXV",130,"MXV","MXV"));
    // 马来西亚林吉特
    result.put("MYR", new CurrencyDataImpl("MYR","MYR",2,"MYR","MYR"));
    // 莫桑比克埃斯库多
    result.put("MZE", new CurrencyDataImpl("MZE","MZE",130,"MZE","MZE"));
    // 旧莫桑比克美提卡
    result.put("MZM", new CurrencyDataImpl("MZM","MZM",130,"MZM","MZM"));
    // 莫桑比克美提卡
    result.put("MZN", new CurrencyDataImpl("MZN","MZN",2,"MZN","MZN"));
    // 纳米比亚元
    result.put("NAD", new CurrencyDataImpl("NAD","NAD",2,"NAD","NAD"));
    // 尼日利亚奈拉
    result.put("NGN", new CurrencyDataImpl("NGN","NGN",2,"NGN","NGN"));
    // 尼加拉瓜科多巴 (1988–1991)
    result.put("NIC", new CurrencyDataImpl("NIC","NIC",130,"NIC","NIC"));
    // 尼加拉瓜科多巴
    result.put("NIO", new CurrencyDataImpl("NIO","NIO",2,"NIO","NIO"));
    // 荷兰盾
    result.put("NLG", new CurrencyDataImpl("NLG","NLG",130,"NLG","NLG"));
    // 挪威克朗
    result.put("NOK", new CurrencyDataImpl("NOK","NOK",2,"NOK","NOK"));
    // 尼泊尔卢比
    result.put("NPR", new CurrencyDataImpl("NPR","NPR",2,"NPR","NPR"));
    // 新西兰元
    result.put("NZD", new CurrencyDataImpl("NZD","NZ$",2,"NZ$","NZ$"));
    // 阿曼里亚尔
    result.put("OMR", new CurrencyDataImpl("OMR","OMR",3,"OMR","OMR"));
    // 巴拿马巴波亚
    result.put("PAB", new CurrencyDataImpl("PAB","PAB",2,"PAB","PAB"));
    // 秘鲁印第
    result.put("PEI", new CurrencyDataImpl("PEI","PEI",130,"PEI","PEI"));
    // 秘鲁索尔
    result.put("PEN", new CurrencyDataImpl("PEN","PEN",2,"PEN","PEN"));
    // 秘鲁索尔 (1863–1965)
    result.put("PES", new CurrencyDataImpl("PES","PES",130,"PES","PES"));
    // 巴布亚新几内亚基那
    result.put("PGK", new CurrencyDataImpl("PGK","PGK",2,"PGK","PGK"));
    // 菲律宾比索
    result.put("PHP", new CurrencyDataImpl("PHP","PHP",2,"PHP","PHP"));
    // 巴基斯坦卢比
    result.put("PKR", new CurrencyDataImpl("PKR","PKR",2,"PKR","PKR"));
    // 波兰兹罗提
    result.put("PLN", new CurrencyDataImpl("PLN","PLN",2,"PLN","PLN"));
    // 波兰兹罗提 (1950–1995)
    result.put("PLZ", new CurrencyDataImpl("PLZ","PLZ",130,"PLZ","PLZ"));
    // 葡萄牙埃斯库多
    result.put("PTE", new CurrencyDataImpl("PTE","PTE",130,"PTE","PTE"));
    // 巴拉圭瓜拉尼
    result.put("PYG", new CurrencyDataImpl("PYG","PYG",0,"PYG","PYG"));
    // 卡塔尔里亚尔
    result.put("QAR", new CurrencyDataImpl("QAR","QAR",2,"QAR","QAR"));
    // 罗得西亚元
    result.put("RHD", new CurrencyDataImpl("RHD","RHD",130,"RHD","RHD"));
    // 旧罗马尼亚列伊
    result.put("ROL", new CurrencyDataImpl("ROL","ROL",130,"ROL","ROL"));
    // 罗马尼亚列伊
    result.put("RON", new CurrencyDataImpl("RON","RON",2,"RON","RON"));
    // 塞尔维亚第纳尔
    result.put("RSD", new CurrencyDataImpl("RSD","RSD",0,"RSD","RSD"));
    // 俄罗斯卢布
    result.put("RUB", new CurrencyDataImpl("RUB","RUB",2,"RUB","RUB"));
    // 俄国卢布 (1991–1998)
    result.put("RUR", new CurrencyDataImpl("RUR","RUR",130,"RUR","RUR"));
    // 卢旺达法郎
    result.put("RWF", new CurrencyDataImpl("RWF","RWF",0,"RWF","RWF"));
    // 沙特里亚尔
    result.put("SAR", new CurrencyDataImpl("SAR","SAR",2,"SAR","SAR"));
    // 所罗门群岛元
    result.put("SBD", new CurrencyDataImpl("SBD","SBD",2,"SBD","SBD"));
    // 塞舌尔卢比
    result.put("SCR", new CurrencyDataImpl("SCR","SCR",2,"SCR","SCR"));
    // 苏丹第纳尔 (1992–2007)
    result.put("SDD", new CurrencyDataImpl("SDD","SDD",130,"SDD","SDD"));
    // 苏丹镑
    result.put("SDG", new CurrencyDataImpl("SDG","SDG",2,"SDG","SDG"));
    // 旧苏丹镑
    result.put("SDP", new CurrencyDataImpl("SDP","SDP",130,"SDP","SDP"));
    // 瑞典克朗
    result.put("SEK", new CurrencyDataImpl("SEK","SEK",2,"SEK","SEK"));
    // 新加坡元
    result.put("SGD", new CurrencyDataImpl("SGD","SGD",2,"SGD","SGD"));
    // 圣赫勒拿群岛磅
    result.put("SHP", new CurrencyDataImpl("SHP","SHP",2,"SHP","SHP"));
    // 斯洛文尼亚托拉尔
    result.put("SIT", new CurrencyDataImpl("SIT","SIT",130,"SIT","SIT"));
    // 斯洛伐克克朗
    result.put("SKK", new CurrencyDataImpl("SKK","SKK",130,"SKK","SKK"));
    // 塞拉利昂利昂
    result.put("SLL", new CurrencyDataImpl("SLL","SLL",0,"SLL","SLL"));
    // 索马里先令
    result.put("SOS", new CurrencyDataImpl("SOS","SOS",0,"SOS","SOS"));
    // 苏里南元
    result.put("SRD", new CurrencyDataImpl("SRD","SRD",2,"SRD","SRD"));
    // 苏里南盾
    result.put("SRG", new CurrencyDataImpl("SRG","SRG",130,"SRG","SRG"));
    // 南苏丹镑
    result.put("SSP", new CurrencyDataImpl("SSP","SSP",2,"SSP","SSP"));
    // 圣多美和普林西比多布拉 (1977–2017)
    result.put("STD", new CurrencyDataImpl("STD","STD",128,"STD","STD"));
    // 圣多美和普林西比多布拉
    result.put("STN", new CurrencyDataImpl("STN","STN",2,"STN","STN"));
    // 苏联卢布
    result.put("SUR", new CurrencyDataImpl("SUR","SUR",130,"SUR","SUR"));
    // 萨尔瓦多科朗
    result.put("SVC", new CurrencyDataImpl("SVC","SVC",130,"SVC","SVC"));
    // 叙利亚镑
    result.put("SYP", new CurrencyDataImpl("SYP","SYP",0,"SYP","SYP"));
    // 斯威士兰里兰吉尼
    result.put("SZL", new CurrencyDataImpl("SZL","SZL",2,"SZL","SZL"));
    // 泰铢
    result.put("THB", new CurrencyDataImpl("THB","THB",2,"THB","THB"));
    // 塔吉克斯坦卢布
    result.put("TJR", new CurrencyDataImpl("TJR","TJR",130,"TJR","TJR"));
    // 塔吉克斯坦索莫尼
    result.put("TJS", new CurrencyDataImpl("TJS","TJS",2,"TJS","TJS"));
    // 土库曼斯坦马纳特 (1993–2009)
    result.put("TMM", new CurrencyDataImpl("TMM","TMM",128,"TMM","TMM"));
    // 土库曼斯坦马纳特
    result.put("TMT", new CurrencyDataImpl("TMT","TMT",2,"TMT","TMT"));
    // 突尼斯第纳尔
    result.put("TND", new CurrencyDataImpl("TND","TND",3,"TND","TND"));
    // 汤加潘加
    result.put("TOP", new CurrencyDataImpl("TOP","TOP",2,"TOP","TOP"));
    // 帝汶埃斯库多
    result.put("TPE", new CurrencyDataImpl("TPE","TPE",130,"TPE","TPE"));
    // 土耳其里拉 (1922–2005)
    result.put("TRL", new CurrencyDataImpl("TRL","TRL",128,"TRL","TRL"));
    // 土耳其里拉
    result.put("TRY", new CurrencyDataImpl("TRY","TL",2,"TL","TL"));
    // 特立尼达和多巴哥元
    result.put("TTD", new CurrencyDataImpl("TTD","TTD",2,"TTD","TTD"));
    // 新台币
    result.put("TWD", new CurrencyDataImpl("TWD","NT$",2,"NT$","NT$"));
    // 坦桑尼亚先令
    result.put("TZS", new CurrencyDataImpl("TZS","TZS",2,"TZS","TZS"));
    // 乌克兰格里夫纳
    result.put("UAH", new CurrencyDataImpl("UAH","UAH",2,"UAH","UAH"));
    // 乌克兰币
    result.put("UAK", new CurrencyDataImpl("UAK","UAK",130,"UAK","UAK"));
    // 乌干达先令 (1966–1987)
    result.put("UGS", new CurrencyDataImpl("UGS","UGS",130,"UGS","UGS"));
    // 乌干达先令
    result.put("UGX", new CurrencyDataImpl("UGX","UGX",0,"UGX","UGX"));
    // 美元
    result.put("USD", new CurrencyDataImpl("USD","US$",2,"US$","US$"));
    // 美元（次日）
    result.put("USN", new CurrencyDataImpl("USN","USN",130,"USN","USN"));
    // 美元（当日）
    result.put("USS", new CurrencyDataImpl("USS","USS",130,"USS","USS"));
    // 乌拉圭比索（索引单位）
    result.put("UYI", new CurrencyDataImpl("UYI","UYI",128,"UYI","UYI"));
    // 乌拉圭比索 (1975–1993)
    result.put("UYP", new CurrencyDataImpl("UYP","UYP",130,"UYP","UYP"));
    // 乌拉圭比索
    result.put("UYU", new CurrencyDataImpl("UYU","UYU",2,"UYU","UYU"));
    // UYW
    result.put("UYW", new CurrencyDataImpl("UYW","UYW",132,"UYW","UYW"));
    // 乌兹别克斯坦苏姆
    result.put("UZS", new CurrencyDataImpl("UZS","UZS",2,"UZS","UZS"));
    // 委内瑞拉玻利瓦尔 (1871–2008)
    result.put("VEB", new CurrencyDataImpl("VEB","VEB",130,"VEB","VEB"));
    // 委内瑞拉玻利瓦尔 (2008–2018)
    result.put("VEF", new CurrencyDataImpl("VEF","VEF",130,"VEF","VEF"));
    // 委内瑞拉玻利瓦尔
    result.put("VES", new CurrencyDataImpl("VES","VES",2,"VES","VES"));
    // 越南盾
    result.put("VND", new CurrencyDataImpl("VND","₫",0,"₫","₫"));
    // 越南盾 (1978–1985)
    result.put("VNN", new CurrencyDataImpl("VNN","VNN",130,"VNN","VNN"));
    // 瓦努阿图瓦图
    result.put("VUV", new CurrencyDataImpl("VUV","VUV",0,"VUV","VUV"));
    // 萨摩亚塔拉
    result.put("WST", new CurrencyDataImpl("WST","WST",2,"WST","WST"));
    // 中非法郎
    result.put("XAF", new CurrencyDataImpl("XAF","FCFA",0,"FCFA","FCFA"));
    // 银
    result.put("XAG", new CurrencyDataImpl("XAG","XAG",130,"XAG","XAG"));
    // 黄金
    result.put("XAU", new CurrencyDataImpl("XAU","XAU",130,"XAU","XAU"));
    // 欧洲复合单位
    result.put("XBA", new CurrencyDataImpl("XBA","XBA",130,"XBA","XBA"));
    // 欧洲货币联盟
    result.put("XBB", new CurrencyDataImpl("XBB","XBB",130,"XBB","XBB"));
    // 欧洲计算单位 (XBC)
    result.put("XBC", new CurrencyDataImpl("XBC","XBC",130,"XBC","XBC"));
    // 欧洲计算单位 (XBD)
    result.put("XBD", new CurrencyDataImpl("XBD","XBD",130,"XBD","XBD"));
    // 东加勒比元
    result.put("XCD", new CurrencyDataImpl("XCD","EC$",2,"EC$","EC$"));
    // 特别提款权
    result.put("XDR", new CurrencyDataImpl("XDR","XDR",130,"XDR","XDR"));
    // 欧洲货币单位
    result.put("XEU", new CurrencyDataImpl("XEU","XEU",130,"XEU","XEU"));
    // 法国金法郎
    result.put("XFO", new CurrencyDataImpl("XFO","XFO",130,"XFO","XFO"));
    // 法国法郎 (UIC)
    result.put("XFU", new CurrencyDataImpl("XFU","XFU",130,"XFU","XFU"));
    // 西非法郎
    result.put("XOF", new CurrencyDataImpl("XOF","CFA",0,"CFA","CFA"));
    // 钯
    result.put("XPD", new CurrencyDataImpl("XPD","XPD",130,"XPD","XPD"));
    // 太平洋法郎
    result.put("XPF", new CurrencyDataImpl("XPF","CFPF",0,"CFPF","CFPF"));
    // 铂
    result.put("XPT", new CurrencyDataImpl("XPT","XPT",130,"XPT","XPT"));
    // RINET 基金
    result.put("XRE", new CurrencyDataImpl("XRE","XRE",130,"XRE","XRE"));
    // XSU
    result.put("XSU", new CurrencyDataImpl("XSU","XSU",130,"XSU","XSU"));
    // 测试货币代码
    result.put("XTS", new CurrencyDataImpl("XTS","XTS",130,"XTS","XTS"));
    // XUA
    result.put("XUA", new CurrencyDataImpl("XUA","XUA",130,"XUA","XUA"));
    // 未知货币
    result.put("XXX", new CurrencyDataImpl("XXX","XXX",130,"XXX","XXX"));
    // 也门第纳尔
    result.put("YDD", new CurrencyDataImpl("YDD","YDD",130,"YDD","YDD"));
    // 也门里亚尔
    result.put("YER", new CurrencyDataImpl("YER","YER",0,"YER","YER"));
    // 南斯拉夫硬第纳尔 (1966–1990)
    result.put("YUD", new CurrencyDataImpl("YUD","YUD",130,"YUD","YUD"));
    // 南斯拉夫新第纳尔 (1994–2002)
    result.put("YUM", new CurrencyDataImpl("YUM","YUM",130,"YUM","YUM"));
    // 南斯拉夫可兑换第纳尔 (1990–1992)
    result.put("YUN", new CurrencyDataImpl("YUN","YUN",130,"YUN","YUN"));
    // 南斯拉夫改良第纳尔 (1992–1993)
    result.put("YUR", new CurrencyDataImpl("YUR","YUR",130,"YUR","YUR"));
    // 南非兰特 (金融)
    result.put("ZAL", new CurrencyDataImpl("ZAL","ZAL",130,"ZAL","ZAL"));
    // 南非兰特
    result.put("ZAR", new CurrencyDataImpl("ZAR","ZAR",2,"ZAR","ZAR"));
    // 赞比亚克瓦查 (1968–2012)
    result.put("ZMK", new CurrencyDataImpl("ZMK","ZMK",128,"ZMK","ZMK"));
    // 赞比亚克瓦查
    result.put("ZMW", new CurrencyDataImpl("ZMW","ZMW",2,"ZMW","ZMW"));
    // 新扎伊尔 (1993–1998)
    result.put("ZRN", new CurrencyDataImpl("ZRN","ZRN",130,"ZRN","ZRN"));
    // 扎伊尔 (1971–1993)
    result.put("ZRZ", new CurrencyDataImpl("ZRZ","ZRZ",130,"ZRZ","ZRZ"));
    // 津巴布韦元 (1980–2008)
    result.put("ZWD", new CurrencyDataImpl("ZWD","ZWD",128,"ZWD","ZWD"));
    // 津巴布韦元 (2009)
    result.put("ZWL", new CurrencyDataImpl("ZWL","ZWL",130,"ZWL","ZWL"));
    // 津巴布韦元 (2008)
    result.put("ZWR", new CurrencyDataImpl("ZWR","ZWR",130,"ZWR","ZWR"));
    return result;
  }

  @Override
  protected HashMap<String, String> loadNamesMap() {
    HashMap<String, String> result = super.loadNamesMap();
    result.put("ADP","安道尔比塞塔");
    result.put("AED","阿联酋迪拉姆");
    result.put("AFA","阿富汗尼 (1927–2002)");
    result.put("AFN","阿富汗尼");
    result.put("ALK","阿尔巴尼亚列克(1946–1965)");
    result.put("ALL","阿尔巴尼亚列克");
    result.put("AMD","亚美尼亚德拉姆");
    result.put("ANG","荷属安的列斯盾");
    result.put("AOA","安哥拉宽扎");
    result.put("AOK","安哥拉宽扎 (1977–1990)");
    result.put("AON","安哥拉新宽扎 (1990–2000)");
    result.put("AOR","安哥拉重新调整宽扎 (1995–1999)");
    result.put("ARA","阿根廷奥斯特拉尔");
    result.put("ARL","阿根廷法定比索 (1970–1983)");
    result.put("ARM","阿根廷比索 (1881–1970)");
    result.put("ARP","阿根廷比索 (1983–1985)");
    result.put("ARS","阿根廷比索");
    result.put("ATS","奥地利先令");
    result.put("AUD","澳大利亚元");
    result.put("AWG","阿鲁巴弗罗林");
    result.put("AZM","阿塞拜疆马纳特 (1993–2006)");
    result.put("AZN","阿塞拜疆马纳特");
    result.put("BAD","波士尼亚-赫塞哥维纳第纳尔 (1992–1994)");
    result.put("BAM","波斯尼亚-黑塞哥维那可兑换马克");
    result.put("BAN","波士尼亚-赫塞哥维纳新第纳尔 (1994–1997)");
    result.put("BBD","巴巴多斯元");
    result.put("BDT","孟加拉塔卡");
    result.put("BEC","比利时法郎（可兑换）");
    result.put("BEF","比利时法郎");
    result.put("BEL","比利时法郎（金融）");
    result.put("BGL","保加利亚硬列弗");
    result.put("BGM","保加利亚社会党列弗");
    result.put("BGN","保加利亚列弗");
    result.put("BGO","保加利亚列弗 (1879–1952)");
    result.put("BHD","巴林第纳尔");
    result.put("BIF","布隆迪法郎");
    result.put("BMD","百慕大元");
    result.put("BND","文莱元");
    result.put("BOB","玻利维亚诺");
    result.put("BOL","玻利维亚诺 (1863–1963)");
    result.put("BOP","玻利维亚比索");
    result.put("BOV","玻利维亚 Mvdol（资金）");
    result.put("BRB","巴西新克鲁赛罗 (1967–1986)");
    result.put("BRC","巴西克鲁扎多 (1986–1989)");
    result.put("BRE","巴西克鲁塞罗 (1990–1993)");
    result.put("BRL","巴西雷亚尔");
    result.put("BRN","巴西新克鲁扎多 (1989–1990)");
    result.put("BRR","巴西克鲁塞罗 (1993–1994)");
    result.put("BRZ","巴西克鲁塞罗 (1942–1967)");
    result.put("BSD","巴哈马元");
    result.put("BTN","不丹努尔特鲁姆");
    result.put("BUK","缅元");
    result.put("BWP","博茨瓦纳普拉");
    result.put("BYB","白俄罗斯新卢布 (1994–1999)");
    result.put("BYN","白俄罗斯卢布");
    result.put("BYR","白俄罗斯卢布 (2000–2016)");
    result.put("BZD","伯利兹元");
    result.put("CAD","加拿大元");
    result.put("CDF","刚果法郎");
    result.put("CHE","欧元 (WIR)");
    result.put("CHF","瑞士法郎");
    result.put("CHW","法郎 (WIR)");
    result.put("CLE","智利埃斯库多");
    result.put("CLF","智利（资金）");
    result.put("CLP","智利比索");
    result.put("CNH","人民币（离岸）");
    result.put("CNY","人民币");
    result.put("COP","哥伦比亚比索");
    result.put("COU","哥伦比亚币");
    result.put("CRC","哥斯达黎加科朗");
    result.put("CSD","旧塞尔维亚第纳尔");
    result.put("CSK","捷克硬克朗");
    result.put("CUC","古巴可兑换比索");
    result.put("CUP","古巴比索");
    result.put("CVE","佛得角埃斯库多");
    result.put("CYP","塞浦路斯镑");
    result.put("CZK","捷克克朗");
    result.put("DDM","东德奥斯特马克");
    result.put("DEM","德国马克");
    result.put("DJF","吉布提法郎");
    result.put("DKK","丹麦克朗");
    result.put("DOP","多米尼加比索");
    result.put("DZD","阿尔及利亚第纳尔");
    result.put("ECS","厄瓜多尔苏克雷");
    result.put("ECV","厄瓜多尔 (UVC)");
    result.put("EEK","爱沙尼亚克朗");
    result.put("EGP","埃及镑");
    result.put("ERN","厄立特里亚纳克法");
    result.put("ESA","西班牙比塞塔（帐户 A）");
    result.put("ESB","西班牙比塞塔（兑换帐户）");
    result.put("ESP","西班牙比塞塔");
    result.put("ETB","埃塞俄比亚比尔");
    result.put("EUR","欧元");
    result.put("FIM","芬兰马克");
    result.put("FJD","斐济元");
    result.put("FKP","福克兰群岛镑");
    result.put("FRF","法国法郎");
    result.put("GBP","英镑");
    result.put("GEK","乔治亚库蓬拉瑞特");
    result.put("GEL","格鲁吉亚拉里");
    result.put("GHC","加纳塞第");
    result.put("GHS","加纳塞地");
    result.put("GIP","直布罗陀镑");
    result.put("GMD","冈比亚达拉西");
    result.put("GNF","几内亚法郎");
    result.put("GNS","几内亚西里");
    result.put("GQE","赤道几内亚埃奎勒");
    result.put("GRD","希腊德拉克马");
    result.put("GTQ","危地马拉格查尔");
    result.put("GWE","葡萄牙几内亚埃斯库多");
    result.put("GWP","几内亚比绍比索");
    result.put("GYD","圭亚那元");
    result.put("HKD","港元");
    result.put("HNL","洪都拉斯伦皮拉");
    result.put("HRD","克罗地亚第纳尔");
    result.put("HRK","克罗地亚库纳");
    result.put("HTG","海地古德");
    result.put("HUF","匈牙利福林");
    result.put("IDR","印度尼西亚盾");
    result.put("IEP","爱尔兰镑");
    result.put("ILP","以色列镑");
    result.put("ILR","以色列谢克尔(1980–1985)");
    result.put("ILS","以色列新谢克尔");
    result.put("INR","印度卢比");
    result.put("IQD","伊拉克第纳尔");
    result.put("IRR","伊朗里亚尔");
    result.put("ISJ","冰岛克朗(1918–1981)");
    result.put("ISK","冰岛克朗");
    result.put("ITL","意大利里拉");
    result.put("JMD","牙买加元");
    result.put("JOD","约旦第纳尔");
    result.put("JPY","日元");
    result.put("KES","肯尼亚先令");
    result.put("KGS","吉尔吉斯斯坦索姆");
    result.put("KHR","柬埔寨瑞尔");
    result.put("KMF","科摩罗法郎");
    result.put("KPW","朝鲜元");
    result.put("KRH","韩元 (1953–1962)");
    result.put("KRO","韩元 (1945–1953)");
    result.put("KRW","韩元");
    result.put("KWD","科威特第纳尔");
    result.put("KYD","开曼元");
    result.put("KZT","哈萨克斯坦坚戈");
    result.put("LAK","老挝基普");
    result.put("LBP","黎巴嫩镑");
    result.put("LKR","斯里兰卡卢比");
    result.put("LRD","利比里亚元");
    result.put("LSL","莱索托洛蒂");
    result.put("LTL","立陶宛立特");
    result.put("LTT","立陶宛塔咯呐司");
    result.put("LUC","卢森堡可兑换法郎");
    result.put("LUF","卢森堡法郎");
    result.put("LUL","卢森堡金融法郎");
    result.put("LVL","拉脱维亚拉特");
    result.put("LVR","拉脱维亚卢布");
    result.put("LYD","利比亚第纳尔");
    result.put("MAD","摩洛哥迪拉姆");
    result.put("MAF","摩洛哥法郎");
    result.put("MCF","摩纳哥法郎");
    result.put("MDC","摩尔多瓦库邦");
    result.put("MDL","摩尔多瓦列伊");
    result.put("MGA","马达加斯加阿里亚里");
    result.put("MGF","马达加斯加法郎");
    result.put("MKD","马其顿第纳尔");
    result.put("MKN","马其顿第纳尔 (1992–1993)");
    result.put("MLF","马里法郎");
    result.put("MMK","缅甸元");
    result.put("MNT","蒙古图格里克");
    result.put("MOP","澳门币");
    result.put("MRO","毛里塔尼亚乌吉亚 (1973–2017)");
    result.put("MRU","毛里塔尼亚乌吉亚");
    result.put("MTL","马耳他里拉");
    result.put("MTP","马耳他镑");
    result.put("MUR","毛里求斯卢比");
    result.put("MVP","马尔代夫卢比(1947–1981)");
    result.put("MVR","马尔代夫卢菲亚");
    result.put("MWK","马拉维克瓦查");
    result.put("MXN","墨西哥比索");
    result.put("MXP","墨西哥银比索 (1861–1992)");
    result.put("MXV","墨西哥（资金）");
    result.put("MYR","马来西亚林吉特");
    result.put("MZE","莫桑比克埃斯库多");
    result.put("MZM","旧莫桑比克美提卡");
    result.put("MZN","莫桑比克美提卡");
    result.put("NAD","纳米比亚元");
    result.put("NGN","尼日利亚奈拉");
    result.put("NIC","尼加拉瓜科多巴 (1988–1991)");
    result.put("NIO","尼加拉瓜科多巴");
    result.put("NLG","荷兰盾");
    result.put("NOK","挪威克朗");
    result.put("NPR","尼泊尔卢比");
    result.put("NZD","新西兰元");
    result.put("OMR","阿曼里亚尔");
    result.put("PAB","巴拿马巴波亚");
    result.put("PEI","秘鲁印第");
    result.put("PEN","秘鲁索尔");
    result.put("PES","秘鲁索尔 (1863–1965)");
    result.put("PGK","巴布亚新几内亚基那");
    result.put("PHP","菲律宾比索");
    result.put("PKR","巴基斯坦卢比");
    result.put("PLN","波兰兹罗提");
    result.put("PLZ","波兰兹罗提 (1950–1995)");
    result.put("PTE","葡萄牙埃斯库多");
    result.put("PYG","巴拉圭瓜拉尼");
    result.put("QAR","卡塔尔里亚尔");
    result.put("RHD","罗得西亚元");
    result.put("ROL","旧罗马尼亚列伊");
    result.put("RON","罗马尼亚列伊");
    result.put("RSD","塞尔维亚第纳尔");
    result.put("RUB","俄罗斯卢布");
    result.put("RUR","俄国卢布 (1991–1998)");
    result.put("RWF","卢旺达法郎");
    result.put("SAR","沙特里亚尔");
    result.put("SBD","所罗门群岛元");
    result.put("SCR","塞舌尔卢比");
    result.put("SDD","苏丹第纳尔 (1992–2007)");
    result.put("SDG","苏丹镑");
    result.put("SDP","旧苏丹镑");
    result.put("SEK","瑞典克朗");
    result.put("SGD","新加坡元");
    result.put("SHP","圣赫勒拿群岛磅");
    result.put("SIT","斯洛文尼亚托拉尔");
    result.put("SKK","斯洛伐克克朗");
    result.put("SLL","塞拉利昂利昂");
    result.put("SOS","索马里先令");
    result.put("SRD","苏里南元");
    result.put("SRG","苏里南盾");
    result.put("SSP","南苏丹镑");
    result.put("STD","圣多美和普林西比多布拉 (1977–2017)");
    result.put("STN","圣多美和普林西比多布拉");
    result.put("SUR","苏联卢布");
    result.put("SVC","萨尔瓦多科朗");
    result.put("SYP","叙利亚镑");
    result.put("SZL","斯威士兰里兰吉尼");
    result.put("THB","泰铢");
    result.put("TJR","塔吉克斯坦卢布");
    result.put("TJS","塔吉克斯坦索莫尼");
    result.put("TMM","土库曼斯坦马纳特 (1993–2009)");
    result.put("TMT","土库曼斯坦马纳特");
    result.put("TND","突尼斯第纳尔");
    result.put("TOP","汤加潘加");
    result.put("TPE","帝汶埃斯库多");
    result.put("TRL","土耳其里拉 (1922–2005)");
    result.put("TRY","土耳其里拉");
    result.put("TTD","特立尼达和多巴哥元");
    result.put("TWD","新台币");
    result.put("TZS","坦桑尼亚先令");
    result.put("UAH","乌克兰格里夫纳");
    result.put("UAK","乌克兰币");
    result.put("UGS","乌干达先令 (1966–1987)");
    result.put("UGX","乌干达先令");
    result.put("USD","美元");
    result.put("USN","美元（次日）");
    result.put("USS","美元（当日）");
    result.put("UYI","乌拉圭比索（索引单位）");
    result.put("UYP","乌拉圭比索 (1975–1993)");
    result.put("UYU","乌拉圭比索");
    result.put("UZS","乌兹别克斯坦苏姆");
    result.put("VEB","委内瑞拉玻利瓦尔 (1871–2008)");
    result.put("VEF","委内瑞拉玻利瓦尔 (2008–2018)");
    result.put("VES","委内瑞拉玻利瓦尔");
    result.put("VND","越南盾");
    result.put("VNN","越南盾 (1978–1985)");
    result.put("VUV","瓦努阿图瓦图");
    result.put("WST","萨摩亚塔拉");
    result.put("XAF","中非法郎");
    result.put("XAG","银");
    result.put("XAU","黄金");
    result.put("XBA","欧洲复合单位");
    result.put("XBB","欧洲货币联盟");
    result.put("XBC","欧洲计算单位 (XBC)");
    result.put("XBD","欧洲计算单位 (XBD)");
    result.put("XCD","东加勒比元");
    result.put("XDR","特别提款权");
    result.put("XEU","欧洲货币单位");
    result.put("XFO","法国金法郎");
    result.put("XFU","法国法郎 (UIC)");
    result.put("XOF","西非法郎");
    result.put("XPD","钯");
    result.put("XPF","太平洋法郎");
    result.put("XPT","铂");
    result.put("XRE","RINET 基金");
    result.put("XTS","测试货币代码");
    result.put("XXX","未知货币");
    result.put("YDD","也门第纳尔");
    result.put("YER","也门里亚尔");
    result.put("YUD","南斯拉夫硬第纳尔 (1966–1990)");
    result.put("YUM","南斯拉夫新第纳尔 (1994–2002)");
    result.put("YUN","南斯拉夫可兑换第纳尔 (1990–1992)");
    result.put("YUR","南斯拉夫改良第纳尔 (1992–1993)");
    result.put("ZAL","南非兰特 (金融)");
    result.put("ZAR","南非兰特");
    result.put("ZMK","赞比亚克瓦查 (1968–2012)");
    result.put("ZMW","赞比亚克瓦查");
    result.put("ZRN","新扎伊尔 (1993–1998)");
    result.put("ZRZ","扎伊尔 (1971–1993)");
    result.put("ZWD","津巴布韦元 (1980–2008)");
    result.put("ZWL","津巴布韦元 (2009)");
    result.put("ZWR","津巴布韦元 (2008)");
    return result;
  }
}
