/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.css.style;

import org.docx4j.org.xhtmlrenderer.css.constants.CSSName;
import org.docx4j.org.xhtmlrenderer.css.constants.IdentValue;
import org.docx4j.org.xhtmlrenderer.css.constants.ValueConstants;
import org.docx4j.org.xhtmlrenderer.css.parser.FSColor;
import org.docx4j.org.xhtmlrenderer.css.style.CssContext;
import org.docx4j.org.xhtmlrenderer.css.style.FSDerivedValue;
import org.docx4j.org.xhtmlrenderer.util.XRRuntimeException;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class DerivedValue
implements FSDerivedValue {
    private String _asString;
    private short _cssSacUnitType;
    private CSSPrimitiveValue cssPrimitiveValue;

    public CSSPrimitiveValue getCSSPrimitiveValue() {
        return this.cssPrimitiveValue;
    }

    protected DerivedValue() {
    }

    protected DerivedValue(CSSName name, CSSPrimitiveValue cssPrimitiveValue, short cssSACUnitType, String cssText, String cssStringValue) {
        this.cssPrimitiveValue = cssPrimitiveValue;
        this._cssSacUnitType = cssSACUnitType;
        if (cssText == null) {
            throw new XRRuntimeException("CSSValue for '" + name + "' is null after " + "resolving CSS identifier for value '" + cssStringValue + "'");
        }
        this._asString = this.deriveStringValue(cssText, cssStringValue);
    }

    private String deriveStringValue(String cssText, String cssStringValue) {
        switch (this._cssSacUnitType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return cssStringValue == null ? cssText : cssStringValue;
            }
        }
        return cssText;
    }

    public String getStringValue() {
        return this._asString;
    }

    public boolean isDeclaredInherit() {
        return false;
    }

    public short getCssSacUnitType() {
        return this._cssSacUnitType;
    }

    public boolean isAbsoluteUnit() {
        return ValueConstants.isAbsoluteUnit(this._cssSacUnitType);
    }

    public float asFloat() {
        throw new XRRuntimeException("asFloat() needs to be overridden in subclass.");
    }

    public FSColor asColor() {
        throw new XRRuntimeException("asColor() needs to be overridden in subclass.");
    }

    public float getFloatProportionalTo(CSSName cssName, float baseValue, CssContext ctx) {
        throw new XRRuntimeException("getFloatProportionalTo() needs to be overridden in subclass.");
    }

    public String asString() {
        return this.getStringValue();
    }

    public String[] asStringArray() {
        throw new XRRuntimeException("asStringArray() needs to be overridden in subclass.");
    }

    public IdentValue asIdentValue() {
        throw new XRRuntimeException("asIdentValue() needs to be overridden in subclass.");
    }

    public boolean hasAbsoluteUnit() {
        throw new XRRuntimeException("hasAbsoluteUnit() needs to be overridden in subclass.");
    }

    public boolean isIdent() {
        return false;
    }

    public boolean isDependentOnFontSize() {
        return false;
    }
}

