/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class AttributeEventNSImpl
extends DiffXEventBase
implements AttributeEvent {
    private final String uri;
    private final String name;
    private final String value;
    private final int hashCode;

    public AttributeEventNSImpl(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
        this.uri = null;
        this.hashCode = AttributeEventNSImpl.toHashCode(this.uri, name, value);
    }

    public AttributeEventNSImpl(String uri, String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
        this.uri = uri;
        this.hashCode = AttributeEventNSImpl.toHashCode(uri, name, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(DiffXEvent e) {
        if (e.getClass() != this.getClass()) {
            return false;
        }
        AttributeEventNSImpl ae = (AttributeEventNSImpl)e;
        if (!ae.name.equals(this.name)) {
            return false;
        }
        if (!AttributeEventNSImpl.equals(ae.uri, this.uri)) {
            return false;
        }
        return ae.value.equals(this.value);
    }

    public String toString() {
        return "attribute: " + this.name + "=" + this.value + " [" + this.uri + "]";
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.attribute(this.uri, this.name, this.value);
    }

    @Override
    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append(' ');
        xml.append(this.name);
        xml.append("=\"");
        xml.append(ESC.toAttributeValue(this.value));
        xml.append('\"');
        return xml;
    }

    private static boolean equals(String uri1, String uri2) {
        if (uri1 == null && uri2 == null) {
            return true;
        }
        if (uri1 == null || uri2 == null) {
            return false;
        }
        return uri1.equals(uri2);
    }

    private static int toHashCode(String uri, String name, String value) {
        int hash = 17;
        hash = hash * 31 + (uri != null ? uri.hashCode() : 0);
        hash = hash * 31 + (name != null ? name.hashCode() : 0);
        hash = hash * 31 + (value != null ? value.hashCode() : 0);
        return hash;
    }
}

