/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableRowBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.Box;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.FormattingOption;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.table.tr.TrHeight;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTblLayoutType;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STTblLayoutType;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TableHelper {
    private static final String TABLE = "table";
    public static Logger log = LoggerFactory.getLogger(TableHelper.class);
    private XHTMLImporterImpl importer;

    protected TableHelper(XHTMLImporterImpl importer) {
        this.importer = importer;
    }

    protected void setupTblPr(TableBox cssTable, Tbl tbl, XHTMLImporterImpl.TableProperties tableProperties) {
        TblWidth tblInd;
        Element e = cssTable.getElement();
        TblPr tblPr = Context.getWmlObjectFactory().createTblPr();
        tbl.setTblPr(tblPr);
        String cssClass = null;
        if (e.getAttribute("class") != null) {
            cssClass = e.getAttribute("class").trim();
            this.setTableStyle(tblPr, cssClass);
        }
        TblBorders borders = Context.getWmlObjectFactory().createTblBorders();
        borders.setTop(this.copyBorderStyle((Box)cssTable, "top", true));
        borders.setBottom(this.copyBorderStyle((Box)cssTable, "bottom", true));
        borders.setLeft(this.copyBorderStyle((Box)cssTable, "left", true));
        borders.setRight(this.copyBorderStyle((Box)cssTable, "right", true));
        borders.setInsideH(this.createBorderStyle(STBorder.NONE, null, null));
        borders.setInsideV(this.createBorderStyle(STBorder.NONE, null, null));
        tblPr.setTblBorders(borders);
        TblWidth spacingWidth = Context.getWmlObjectFactory().createTblWidth();
        if (cssTable.getStyle().isCollapseBorders()) {
            spacingWidth.setW(BigInteger.ZERO);
            spacingWidth.setType("auto");
        } else {
            int cssSpacing = cssTable.getStyle().getBorderHSpacing((CssContext)this.importer.getRenderer().getLayoutContext());
            spacingWidth.setW(BigInteger.valueOf(cssSpacing / 2));
            spacingWidth.setType("dxa");
        }
        tblPr.setTblCellSpacing(spacingWidth);
        log.debug("list depth:" + this.importer.getListHelper().getDepth());
        if (this.importer.getListHelper().getDepth() > 0) {
            tblInd = tblPr.getTblInd();
            if (tblInd == null) {
                tblInd = new TblWidth();
                tblPr.setTblInd(tblInd);
            }
            tblInd.setType("dxa");
            int totalPadding = this.importer.getListHelper().getAbsoluteIndent((Styleable)cssTable);
            int tableIndentContrib = this.tableIndentContrib(this.importer.getContentContextStack());
            if (this.importer.getListHelper().peekListItemStateStack().isFirstChild) {
                log.debug("Table in list indent case 1: tblInd set for item itself");
                tblInd.setW(BigInteger.valueOf(totalPadding - tableIndentContrib));
                this.importer.getListHelper().peekListItemStateStack().isFirstChild = false;
            } else {
                log.debug("Table in list indent case 2: tblInd set for follwing child");
                tblInd.setW(BigInteger.valueOf(totalPadding + 360 - tableIndentContrib));
            }
        } else if (cssTable.getMargin((CssContext)this.importer.getRenderer().getLayoutContext()) != null && cssTable.getMargin((CssContext)this.importer.getRenderer().getLayoutContext()).left() > 0.0f) {
            log.debug("Calculating TblInd from margin.left: " + cssTable.getMargin((CssContext)this.importer.getRenderer().getLayoutContext()).left());
            tblInd = Context.getWmlObjectFactory().createTblWidth();
            tblInd.setW(BigInteger.valueOf(Math.round(cssTable.getMargin((CssContext)this.importer.getRenderer().getLayoutContext()).left())));
            tblInd.setType("dxa");
            tblPr.setTblInd(tblInd);
        } else {
            CTBorder leftBorder = borders.getLeft();
            if (leftBorder != null && leftBorder.getVal() != null && leftBorder.getVal() != STBorder.NONE && leftBorder.getVal() != STBorder.NIL) {
                log.debug("applying fix to align left edge of table with text");
                TblWidth tblInd2 = Context.getWmlObjectFactory().createTblWidth();
                tblInd2.setW(BigInteger.valueOf(115L));
                tblInd2.setType("dxa");
                tblPr.setTblInd(tblInd2);
            }
        }
        TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
        tblW.setW(BigInteger.ZERO);
        tblW.setType("auto");
        tblPr.setTblW(tblW);
        if (cssTable.getStyle().isIdent(CSSName.TABLE_LAYOUT, IdentValue.AUTO) || cssTable.getStyle().isAutoWidth()) {
            tableProperties.setFixedWidth(false);
        } else {
            tableProperties.setFixedWidth(true);
            CTTblLayoutType tblLayout = Context.getWmlObjectFactory().createCTTblLayoutType();
            tblLayout.setType(STTblLayoutType.FIXED);
            tblPr.setTblLayout(tblLayout);
        }
    }

    protected void setupTblGrid(TableBox cssTable, Tbl tbl, XHTMLImporterImpl.TableProperties tableProperties) {
        TblGrid tblGrid = Context.getWmlObjectFactory().createTblGrid();
        tbl.setTblGrid(tblGrid);
        int[] colPos = tableProperties.getColumnPos();
        log.debug("setupTblGrid " + cssTable.numEffCols() + "  " + colPos.length);
        for (int i = 1; i <= cssTable.numEffCols(); ++i) {
            TblGridCol tblGridCol = Context.getWmlObjectFactory().createTblGridCol();
            tblGrid.getGridCol().add(tblGridCol);
            log.debug("colpos=" + colPos[i]);
            tblGridCol.setW(BigInteger.valueOf(colPos[i] - colPos[i - 1]));
        }
    }

    protected void setupTrPr(TableRowBox trBox, Tr tr) {
        TrPr trPr = Context.getWmlObjectFactory().createTrPr();
        tr.setTrPr(trPr);
        int height = trBox.getHeight();
        if (height != 0) {
            TrHeight thr = new TrHeight();
            thr.set(trPr);
            int twip = UnitsOfMeasurement.pxToTwip((float)(height / 20));
            ((CTHeight)thr.getObject()).setVal(BigInteger.valueOf(twip));
        }
    }

    protected void setupTcPr(TableCellBox tcb, Tc tc, XHTMLImporterImpl.TableProperties tableProperties) {
        FSColor fsColor;
        int effCol = tcb.getTable().colToEffCol(tcb.getCol());
        TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
        tc.setTcPr(tcPr);
        if (tcb.getStyle().getRowSpan() > 1) {
            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
            vm.setVal("restart");
            tcPr.setVMerge(vm);
        }
        try {
            TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
            tblW.setW(BigInteger.valueOf(tableProperties.getColumnWidth(effCol + 1)));
            tblW.setType("dxa");
            tcPr.setTcW(tblW);
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            log.error("Problem with getColumnWidth for col" + (effCol + 1));
        }
        int colspan = tcb.getStyle().getColSpan();
        if (colspan > 1) {
            TcPr tcPr2 = tc.getTcPr();
            if (tcPr2 == null) {
                tcPr2 = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr2);
            }
            TcPrInner.GridSpan gs = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
            gs.setVal(BigInteger.valueOf(colspan));
            tcPr2.setGridSpan(gs);
            this.setCellWidthAuto(tcPr2);
        }
        if ((fsColor = tcb.getStyle().getBackgroundColor()) != null && fsColor instanceof FSRGBColor) {
            FSRGBColor rgbResult = (FSRGBColor)fsColor;
            CTShd shd = Context.getWmlObjectFactory().createCTShd();
            shd.setFill(UnitsOfMeasurement.rgbTripleToHex((float)rgbResult.getRed(), (float)rgbResult.getGreen(), (float)rgbResult.getBlue()));
            tcPr.setShd(shd);
        }
        tcPr.setTcBorders(this.copyCellBorderStyles(tcb));
        IdentValue valign = tcb.getVerticalAlign();
        if (valign != null) {
            CTVerticalJc vjc;
            if ("top".equals(valign.asString())) {
                vjc = new CTVerticalJc();
                vjc.setVal(STVerticalJc.TOP);
                tcPr.setVAlign(vjc);
            } else if ("middle".equals(valign.asString())) {
                vjc = new CTVerticalJc();
                vjc.setVal(STVerticalJc.CENTER);
                tcPr.setVAlign(vjc);
            } else if ("bottom".equals(valign.asString())) {
                vjc = new CTVerticalJc();
                vjc.setVal(STVerticalJc.BOTTOM);
                tcPr.setVAlign(vjc);
            }
        }
        TcMar tcMar = Context.getWmlObjectFactory().createTcMar();
        tcPr.setTcMar(tcMar);
        TblWidth width = this.getCellMargin(tcb.getStyle(), "left");
        if (width != null) {
            tcMar.setLeft(width);
        }
        if ((width = this.getCellMargin(tcb.getStyle(), "right")) != null) {
            tcMar.setRight(width);
        }
        if ((width = this.getCellMargin(tcb.getStyle(), "top")) != null) {
            tcMar.setTop(width);
        }
        if ((width = this.getCellMargin(tcb.getStyle(), "bottom")) != null) {
            tcMar.setBottom(width);
        }
    }

    private TblWidth getCellMargin(CalculatedStyle tcStyle, String side) {
        TblWidth tblWidth = null;
        FSDerivedValue padding = tcStyle.valueByName(CSSName.getByPropertyName((String)("padding-" + side)));
        if (padding != null && padding instanceof LengthValue) {
            int twip = UnitsOfMeasurement.pxToTwip((float)((LengthValue)padding).asFloat());
            if (twip == 0) {
                twip = 15;
            }
            tblWidth = Context.getWmlObjectFactory().createTblWidth();
            tblWidth.setW(BigInteger.valueOf(twip));
            tblWidth.setType("dxa");
        }
        return tblWidth;
    }

    private CTBorder copyBorderStyle(Box box, String side, boolean keepNone) {
        STBorder stBorder;
        FSDerivedValue borderStyle = box.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-style")));
        FSDerivedValue borderColor = box.getStyle().valueByName(CSSName.getByPropertyName((String)("border-" + side + "-color")));
        float width = box.getStyle().getFloatPropertyProportionalHeight(CSSName.getByPropertyName((String)("border-" + side + "-width")), 0.0f, (CssContext)this.importer.getRenderer().getLayoutContext());
        log.debug("border width: " + width);
        if (borderStyle.asIdentValue() == IdentValue.NONE || width == 0.0f) {
            return keepNone ? this.createBorderStyle(STBorder.NONE, null, null) : null;
        }
        if (borderStyle.asIdentValue() == IdentValue.HIDDEN) {
            return this.createBorderStyle(STBorder.NONE, "FFFFFF", BigInteger.ZERO);
        }
        if (borderStyle.asIdentValue() == IdentValue.DOUBLE) {
            width /= 3.0f;
        }
        try {
            stBorder = STBorder.fromValue((String)borderStyle.asString());
        }
        catch (IllegalArgumentException e) {
            stBorder = STBorder.SINGLE;
        }
        if (log.isDebugEnabled()) {
            log.debug(borderStyle.asString() + " -> " + stBorder);
        }
        width = UnitsOfMeasurement.twipToPoint((int)Math.round(width)) * 8.0f;
        log.debug("converted border width: " + width);
        String color = borderColor.asString();
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        return this.createBorderStyle(stBorder, color, BigInteger.valueOf(Math.round(width)));
    }

    private CTBorder createBorderStyle(STBorder val, String color, BigInteger sz) {
        CTBorder border = Context.getWmlObjectFactory().createCTBorder();
        border.setVal(val);
        border.setColor(color);
        border.setSz(sz);
        return border;
    }

    private TcPrInner.TcBorders copyCellBorderStyles(TableCellBox box) {
        TcPrInner.TcBorders tcBorders = Context.getWmlObjectFactory().createTcPrInnerTcBorders();
        tcBorders.setTop(this.copyBorderStyle((Box)box, "top", false));
        tcBorders.setBottom(this.copyBorderStyle((Box)box, "bottom", false));
        tcBorders.setLeft(this.copyBorderStyle((Box)box, "left", false));
        tcBorders.setRight(this.copyBorderStyle((Box)box, "right", false));
        return tcBorders;
    }

    protected void insertDummyVMergedCells(ContentAccessor trContext, TableCellBox tcb, boolean backwards) {
        log.debug("Scanning cells from " + tcb.getRow() + ", " + tcb.getCol() + " to the " + (backwards ? "left" : "right"));
        ArrayList<TableCellBox> adjCells = new ArrayList<TableCellBox>();
        int numEffCols = tcb.getTable().numEffCols();
        for (int i = tcb.getCol(); i >= 0 && i < numEffCols; i += backwards ? -1 : 1) {
            TableSectionBox tsb = null;
            try {
                tsb = (TableSectionBox)MethodUtils.invokeMethod((Object)tcb, (boolean)true, (String)"getSection");
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            TableCellBox adjCell = tsb.cellAt(tcb.getRow(), i);
            if (adjCell == null) {
                log.error("XHTML table import: Null adjCell for row " + tcb.getRow() + ", col " + tcb.getCol() + " at col " + i);
                break;
            }
            if (adjCell == tcb || adjCell == TableCellBox.SPANNING_CELL) continue;
            log.debug("Got adjCell, it is  " + adjCell.getRow() + ", " + adjCell.getCol());
            if (adjCell.getRow() >= tcb.getRow() || adjCell.getStyle() == null || adjCell.getStyle().getRowSpan() <= 1) break;
            adjCells.add(adjCell);
        }
        if (backwards && !adjCells.isEmpty()) {
            Collections.reverse(adjCells);
        }
        for (TableCellBox adjCell : adjCells) {
            Tc dummy = Context.getWmlObjectFactory().createTc();
            trContext.getContent().add(dummy);
            TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
            dummy.setTcPr(tcPr);
            TcPrInner.VMerge vm = Context.getWmlObjectFactory().createTcPrInnerVMerge();
            tcPr.setVMerge(vm);
            int colspan = adjCell.getStyle().getColSpan();
            if (colspan > 1) {
                TcPrInner.GridSpan gs = Context.getWmlObjectFactory().createTcPrInnerGridSpan();
                gs.setVal(BigInteger.valueOf(colspan));
                tcPr.setGridSpan(gs);
            }
            TcPrInner.TcBorders borders = this.copyCellBorderStyles(adjCell);
            borders.setTop(this.createBorderStyle(STBorder.NIL, null, null));
            tcPr.setTcBorders(borders);
            this.setCellWidthAuto(tcPr);
            dummy.getContent().add(new P());
        }
    }

    protected void nestedTableHierarchyFix(ContentAccessor contentContext, Box parent) {
        if (parent == null) {
            return;
        }
        if (parent instanceof TableBox || parent.getElement().getNodeName().equals(TABLE)) {
            log.warn("table: Constructing missing w:tr/w:td..");
            P captionP = null;
            for (int i = 0; i < contentContext.getContent().size(); ++i) {
                Object next = contentContext.getContent().get(i);
                if (!(next instanceof P)) continue;
                captionP = (P)XmlUtils.deepCopy((Object)((P)next));
                contentContext.getContent().remove(i);
                break;
            }
            TblPr tblPr = Context.getWmlObjectFactory().createTblPr();
            contentContext.getContent().add(tblPr);
            String cssClass = null;
            if (parent.getElement().getAttribute("class") != null) {
                cssClass = parent.getElement().getAttribute("class").trim();
            }
            this.setTableStyle(tblPr, cssClass);
            Tr tr = Context.getWmlObjectFactory().createTr();
            contentContext.getContent().add(tr);
            contentContext = tr;
            Tc tc = Context.getWmlObjectFactory().createTc();
            contentContext.getContent().add(tc);
            contentContext = tc;
            if (captionP != null) {
                contentContext.getContent().add(captionP);
            }
        }
    }

    private void setTableStyle(TblPr tblPr, String cssClass) {
        if (!this.importer.getTableFormatting().equals((Object)FormattingOption.IGNORE_CLASS) && cssClass != null && !cssClass.equals("")) {
            Style s;
            int pos = cssClass.indexOf(" ");
            if (pos > -1) {
                cssClass = cssClass.substring(0, pos);
            }
            if ((s = this.importer.stylesByID.get(cssClass)) == null) {
                log.debug("No docx style for @class='" + cssClass + "'");
            } else if (s.getType() != null && s.getType().equals(TABLE)) {
                CTTblPrBase.TblStyle tblStyle = Context.getWmlObjectFactory().createCTTblPrBaseTblStyle();
                tblPr.setTblStyle(tblStyle);
                tblStyle.setVal(cssClass);
            } else {
                log.debug("For docx style for @class='" + cssClass + "', but its not a table style ");
            }
        }
    }

    protected boolean isTableStyle(Style s) {
        return s.getType() != null && s.getType().equals(TABLE);
    }

    private void setCellWidthAuto(TcPr tcPr) {
        TblWidth tblW = Context.getWmlObjectFactory().createTblWidth();
        tblW.setW(BigInteger.ZERO);
        tblW.setType("auto");
        tcPr.setTcW(tblW);
    }

    protected int tableIndentContrib(LinkedList<ContentAccessor> contentContextStack) {
        int tblIndents = 0;
        for (ContentAccessor ca : contentContextStack) {
            Tbl tbl;
            log.debug(ca.getClass().getName());
            if (!(ca instanceof Tbl) || (tbl = (Tbl)ca).getTblPr() == null || tbl.getTblPr().getTblInd() == null || tbl.getTblPr().getTblInd().getW() == null) continue;
            tblIndents += tbl.getTblPr().getTblInd().getW().intValue();
        }
        log.debug("taking into account tbl indent: " + tblIndents);
        return tblIndents;
    }
}

