/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBordersTest {
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws InvalidFormatException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    private List<Object> convert(String xhtml) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        return XHTMLImporter2.convert(xhtml, "");
    }

    private Tbl table(String tableContent) throws Docx4JException {
        List<Object> converted = this.convert("<div>" + tableContent + "</div>");
        return (Tbl)converted.get(1);
    }

    @Test
    public void testTableBorderAbsence() throws Docx4JException {
        Tbl tbl = this.table("<table><tr><td>1</td></tr></table>");
        TblBorders borders = tbl.getTblPr().getTblBorders();
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getTop().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getBottom().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getLeft().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getRight().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideH().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideV().getVal());
        TcPrInner.TcBorders borders2 = ((Tc)((Tr)tbl.getContent().get(0)).getContent().get(0)).getTcPr().getTcBorders();
        Assert.assertNull((Object)borders2.getTop());
        Assert.assertNull((Object)borders2.getBottom());
        Assert.assertNull((Object)borders2.getLeft());
        Assert.assertNull((Object)borders2.getRight());
        Assert.assertNull((Object)borders2.getInsideH());
        Assert.assertNull((Object)borders2.getInsideV());
    }

    @Test
    public void testTableBorderAbsenceExplicit() throws Docx4JException {
        Tbl tbl = this.table("<table border='0'><tr><td>1</td></tr></table>");
        TblBorders borders = tbl.getTblPr().getTblBorders();
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getTop().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getBottom().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getLeft().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getRight().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideH().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideV().getVal());
        TcPrInner.TcBorders borders2 = ((Tc)((Tr)tbl.getContent().get(0)).getContent().get(0)).getTcPr().getTcBorders();
        Assert.assertNull((Object)borders2.getTop());
        Assert.assertNull((Object)borders2.getBottom());
        Assert.assertNull((Object)borders2.getLeft());
        Assert.assertNull((Object)borders2.getRight());
        Assert.assertNull((Object)borders2.getInsideH());
        Assert.assertNull((Object)borders2.getInsideV());
    }

    @Test
    public void testTableBorderPresence() throws Docx4JException {
        Tbl tbl = this.table("<table border='1'><tr><th>1</th></tr></table>");
        TblBorders borders = tbl.getTblPr().getTblBorders();
        Assert.assertEquals((Object)STBorder.INSET, (Object)borders.getTop().getVal());
        Assert.assertEquals((Object)STBorder.INSET, (Object)borders.getBottom().getVal());
        Assert.assertEquals((Object)STBorder.INSET, (Object)borders.getLeft().getVal());
        Assert.assertEquals((Object)STBorder.INSET, (Object)borders.getRight().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideH().getVal());
        Assert.assertEquals((Object)STBorder.NONE, (Object)borders.getInsideV().getVal());
        Assert.assertTrue((borders.getTop().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders.getBottom().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders.getLeft().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders.getRight().getSz().longValue() > 0L ? 1 : 0) != 0);
        TcPrInner.TcBorders borders2 = ((Tc)((Tr)tbl.getContent().get(0)).getContent().get(0)).getTcPr().getTcBorders();
        Assert.assertEquals((Object)STBorder.OUTSET, (Object)borders2.getTop().getVal());
        Assert.assertEquals((Object)STBorder.OUTSET, (Object)borders2.getBottom().getVal());
        Assert.assertEquals((Object)STBorder.OUTSET, (Object)borders2.getLeft().getVal());
        Assert.assertEquals((Object)STBorder.OUTSET, (Object)borders2.getRight().getVal());
        Assert.assertNull((Object)borders2.getInsideH());
        Assert.assertNull((Object)borders2.getInsideV());
        Assert.assertTrue((borders2.getTop().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders2.getBottom().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders2.getLeft().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders2.getRight().getSz().longValue() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTableBorderCollapse() throws Docx4JException {
        Tbl tbl = this.table("<table border='1' style='border-collapse: collapse;'><tr><td>1</td></tr></table>");
        TblWidth spacing = tbl.getTblPr().getTblCellSpacing();
        Assert.assertEquals((Object)"auto", (Object)spacing.getType());
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)spacing.getW());
        tbl = this.table("<table border='1'><tr><td>1</td></tr></table>");
        spacing = tbl.getTblPr().getTblCellSpacing();
        Assert.assertEquals((Object)"dxa", (Object)spacing.getType());
        Assert.assertTrue((spacing.getW().longValue() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTableBorderStyles() throws Docx4JException {
        HashMap<String, STBorder> styles = new HashMap<String, STBorder>();
        styles.put("none", STBorder.NONE);
        styles.put("hidden", STBorder.NONE);
        styles.put("solid", STBorder.SINGLE);
        styles.put("dotted", STBorder.DOTTED);
        styles.put("dashed", STBorder.DASHED);
        styles.put("double", STBorder.DOUBLE);
        styles.put("inset", STBorder.INSET);
        styles.put("outset", STBorder.OUTSET);
        styles.put("groove", STBorder.SINGLE);
        styles.put("ridge", STBorder.SINGLE);
        styles.put("anyOther", STBorder.NONE);
        for (String style : styles.keySet()) {
            Tbl tbl = this.table("<table style='border: 1px " + style + " black;'><tr><td>1</td></tr></table>");
            TblBorders borders = tbl.getTblPr().getTblBorders();
            Assert.assertEquals(styles.get(style), (Object)borders.getTop().getVal());
        }
    }

    @Test
    public void testTableBorderColors() throws Docx4JException {
        Tbl tbl = this.table("<table style='border-style: solid; border-color:#111 #222 #333 #444;'><tr><th>1</th></tr></table>");
        TblBorders borders = tbl.getTblPr().getTblBorders();
        Assert.assertEquals((Object)"111111", (Object)borders.getTop().getColor());
        Assert.assertEquals((Object)"222222", (Object)borders.getRight().getColor());
        Assert.assertEquals((Object)"333333", (Object)borders.getBottom().getColor());
        Assert.assertEquals((Object)"444444", (Object)borders.getLeft().getColor());
    }

    @Test
    public void testTableBorderWidths() throws Docx4JException {
        Tbl tbl = this.table("<table style='border-style: solid; border-width: 0px 1px 2px 3px;'><tr><th>1</th></tr></table>");
        TblBorders borders = tbl.getTblPr().getTblBorders();
        Assert.assertNull((Object)borders.getTop().getSz());
        Assert.assertTrue((borders.getRight().getSz().longValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((borders.getBottom().getSz().longValue() > borders.getRight().getSz().longValue() ? 1 : 0) != 0);
        Assert.assertTrue((borders.getLeft().getSz().longValue() > borders.getBottom().getSz().longValue() ? 1 : 0) != 0);
    }
}

