/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLStreamException;
import org.dhatim.fastexcel.reader.DefaultXMLInputFactory;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.HeaderSignatures;
import org.dhatim.fastexcel.reader.OPCPackage;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.RowSpliterator;
import org.dhatim.fastexcel.reader.SST;
import org.dhatim.fastexcel.reader.Sheet;
import org.dhatim.fastexcel.reader.SimpleXmlReader;

public class ReadableWorkbook
implements Closeable {
    private final OPCPackage pkg;
    private final SST sst;
    private boolean date1904;
    private final List<Sheet> sheets = new ArrayList<Sheet>();

    public ReadableWorkbook(File inputFile) throws IOException {
        this(OPCPackage.open(inputFile));
    }

    public ReadableWorkbook(InputStream inputStream) throws IOException {
        this(OPCPackage.open(inputStream));
    }

    private ReadableWorkbook(OPCPackage pkg) throws IOException {
        try {
            this.pkg = pkg;
            this.sst = SST.fromInputStream(pkg.getSharedStrings());
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
        try (SimpleXmlReader workbookReader = new SimpleXmlReader(DefaultXMLInputFactory.factory, pkg.getWorkbookContent());){
            this.readWorkbook(workbookReader);
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.pkg.close();
    }

    public boolean isDate1904() {
        return this.date1904;
    }

    public Stream<Sheet> getSheets() {
        return this.sheets.stream();
    }

    public Optional<Sheet> getSheet(int index) {
        return index < 0 || index >= this.sheets.size() ? Optional.empty() : Optional.of(this.sheets.get(index));
    }

    public Sheet getFirstSheet() {
        return this.sheets.get(0);
    }

    public Optional<Sheet> findSheet(String name) {
        return this.sheets.stream().filter(sheet -> name.equals(sheet.getName())).findFirst();
    }

    private void readWorkbook(SimpleXmlReader r) throws XMLStreamException {
        while (r.goTo(() -> r.isStartElement("sheets") || r.isStartElement("workbookPr") || r.isEndElement("workbook"))) {
            if ("sheets".equals(r.getLocalName())) {
                r.forEach("sheet", "sheets", this::createSheet);
                continue;
            }
            if (!"workbookPr".equals(r.getLocalName())) break;
            String date1904Value = r.getAttribute("date1904");
            this.date1904 = Boolean.parseBoolean(date1904Value);
        }
    }

    private void createSheet(SimpleXmlReader r) {
        String name = r.getAttribute("name");
        String id = r.getAttribute("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
        int index = this.sheets.size();
        this.sheets.add(new Sheet(this, index, id, name));
    }

    Stream<Row> openStream(Sheet sheet) throws IOException {
        try {
            InputStream inputStream = this.pkg.getSheetContent(sheet);
            Stream<Row> stream = StreamSupport.stream(new RowSpliterator(this, inputStream), false);
            return (Stream)stream.onClose(ReadableWorkbook.asUncheckedRunnable(inputStream));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    SST getSharedStringsTable() {
        return this.sst;
    }

    public static boolean isOOXMLZipHeader(byte[] bytes) {
        return HeaderSignatures.isHeader(bytes, HeaderSignatures.OOXML_FILE_HEADER);
    }

    public static boolean isOLE2Header(byte[] bytes) {
        return HeaderSignatures.isHeader(bytes, HeaderSignatures.OLE_2_SIGNATURE);
    }

    private static Runnable asUncheckedRunnable(Closeable c) {
        return () -> {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

