/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellAddress;
import org.dhatim.fastexcel.reader.CellRangeAddress;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ExcelReaderException;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.SimpleXmlReader;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

class RowSpliterator
implements Spliterator<Row> {
    private final SimpleXmlReader r;
    private final ReadableWorkbook workbook;
    private final HashMap<CellRangeAddress, String> sharedFormula = new HashMap();
    private int rowCapacity = 16;

    public RowSpliterator(ReadableWorkbook workbook, InputStream inputStream) throws XMLStreamException {
        this.workbook = workbook;
        this.r = new SimpleXmlReader(workbook.getXmlFactory(), inputStream);
        this.r.goTo("sheetData");
    }

    @Override
    public boolean tryAdvance(Consumer<? super Row> action) {
        try {
            if (this.hasNext()) {
                action.accept(this.next());
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new ExcelReaderException(e);
        }
    }

    @Override
    public Spliterator<Row> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1297;
    }

    private boolean hasNext() throws XMLStreamException {
        if (this.r.goTo(() -> this.r.isStartElement("row") || this.r.isEndElement("sheetData"))) {
            return "row".equals(this.r.getLocalName());
        }
        return false;
    }

    private Row next() throws XMLStreamException {
        if (!"row".equals(this.r.getLocalName())) {
            throw new NoSuchElementException();
        }
        int rowIndex = this.r.getIntAttribute("r");
        ArrayList<Cell> cells = new ArrayList<Cell>(this.rowCapacity);
        int physicalCellCount = 0;
        while (this.r.goTo(() -> this.r.isStartElement("c") || this.r.isEndElement("row")) && !"row".equals(this.r.getLocalName())) {
            String rawValue;
            CellType cellType;
            String formula;
            String value;
            String cellRef = this.r.getAttribute("r");
            CellAddress addr = new CellAddress(cellRef);
            String type = this.r.getOptionalAttribute("t").orElse("n");
            if ("inlineStr".equals(type)) {
                String v = null;
                String f = null;
                String rv = null;
                while (this.r.goTo(() -> this.r.isStartElement("is") || this.r.isEndElement("c") || this.r.isStartElement("f"))) {
                    if ("is".equals(this.r.getLocalName())) {
                        rv = this.r.getValueUntilEndElement("is");
                        XSSFRichTextString rtss = new XSSFRichTextString(rv);
                        v = rtss.toString();
                        continue;
                    }
                    if (!"f".equals(this.r.getLocalName())) break;
                    f = this.r.getValueUntilEndElement("f");
                }
                value = v;
                formula = f;
                cellType = f == null ? CellType.STRING : CellType.FORMULA;
                rawValue = rv;
            } else if ("s".equals(type)) {
                this.r.goTo("v");
                int index = Integer.parseInt(this.r.getValueUntilEndElement("v"));
                CTRst ctrst = this.workbook.getSharedStringsTable().getEntryAt(index);
                String rtss = new XSSFRichTextString(ctrst);
                value = rtss.toString();
                cellType = CellType.STRING;
                formula = null;
                rawValue = ctrst.xmlText();
            } else {
                Function<String, Object> parser;
                CellType definedType;
                switch (type) {
                    case "b": {
                        definedType = CellType.BOOLEAN;
                        parser = RowSpliterator::parseBoolean;
                        break;
                    }
                    case "e": {
                        definedType = CellType.ERROR;
                        parser = Function.identity();
                        break;
                    }
                    case "n": {
                        definedType = CellType.NUMBER;
                        parser = RowSpliterator::parseNumber;
                        break;
                    }
                    case "str": {
                        definedType = CellType.FORMULA;
                        parser = Function.identity();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell type : " + type);
                    }
                }
                Object v = null;
                String f = null;
                String rv = null;
                while (this.r.goTo(() -> this.r.isStartElement("v") || this.r.isEndElement("c") || this.r.isStartElement("f"))) {
                    if ("v".equals(this.r.getLocalName())) {
                        rv = this.r.getValueUntilEndElement("v");
                        v = "".equals(rv) ? null : parser.apply(rv);
                        continue;
                    }
                    if (!"f".equals(this.r.getLocalName())) break;
                    String ref = this.r.getAttribute("ref");
                    String t = this.r.getAttribute("t");
                    f = this.r.getValueUntilEndElement("f");
                    if (!"array".equals(t) || ref == null) continue;
                    CellRangeAddress range = CellRangeAddress.valueOf(ref);
                    this.sharedFormula.put(range, f);
                }
                if (f == null) {
                    f = this.getSharedFormula(addr).orElse(null);
                }
                if (f == null && definedType == CellType.NUMBER && v == null) {
                    cellType = CellType.EMPTY;
                    formula = null;
                    value = null;
                    rawValue = rv;
                } else {
                    cellType = f == null ? definedType : CellType.FORMULA;
                    formula = f;
                    value = v;
                    rawValue = rv;
                }
            }
            if (addr.getColumn() >= cells.size()) {
                RowSpliterator.setSize(cells, addr.getColumn() + 1);
            }
            Cell cell = new Cell(this.workbook, cellType, value, addr, formula, rawValue);
            cells.set(addr.getColumn(), cell);
            ++physicalCellCount;
        }
        this.rowCapacity = Math.max(this.rowCapacity, cells.size());
        return new Row(rowIndex, physicalCellCount, cells.toArray(new Cell[cells.size()]));
    }

    private Optional<String> getSharedFormula(CellAddress addr) {
        for (Map.Entry<CellRangeAddress, String> entry : this.sharedFormula.entrySet()) {
            if (!entry.getKey().isInRange(addr.getRow(), addr.getColumn())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private static BigDecimal parseNumber(String s) {
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new ExcelReaderException("Cannot parse number : " + s, e);
        }
    }

    private static Boolean parseBoolean(String s) {
        if ("0".equals(s)) {
            return Boolean.FALSE;
        }
        if ("1".equals(s)) {
            return Boolean.TRUE;
        }
        throw new ExcelReaderException("Invalid boolean cell value: '" + s + "'. Expecting '0' or '1'.");
    }

    private static void setSize(List<?> list, int newSize) {
        block4: {
            if (list.size() == newSize) break block4;
            if (list.size() < newSize) {
                int toAdd = newSize - list.size();
                for (int i = 0; i < toAdd; ++i) {
                    list.add(null);
                }
            } else {
                for (int i = list.size() - 1; i > newSize; --i) {
                    list.remove(i);
                }
            }
        }
    }
}

