/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellAddress;

public class Row
implements Iterable<Cell> {
    private final int rowNum;
    private final Cell[] cells;
    private final int physicalCellCount;

    public Row(int rowNum, int physicalCellCount, Cell[] cells) {
        this.rowNum = rowNum;
        this.physicalCellCount = physicalCellCount;
        this.cells = (Cell[])cells.clone();
    }

    public Cell getCell(int index) {
        if (index < 0 || index >= this.cells.length) {
            throw new IndexOutOfBoundsException("row-index: " + this.rowNum + ", index: " + index + ", count: " + this.cells.length);
        }
        return this.cells[index];
    }

    public Cell getCell(CellAddress address) {
        if (this.rowNum != address.getRow()) {
            throw new IllegalArgumentException("The given address " + address + " concerns another row (" + this.rowNum + ")");
        }
        return this.getCell(address.getColumn());
    }

    public List<Cell> getCells(int beginIndex, int endIndex) {
        return Arrays.asList(Arrays.copyOfRange(this.cells, beginIndex, endIndex));
    }

    public Optional<Cell> getOptionalCell(int index) {
        return index < 0 || index >= this.cells.length ? Optional.empty() : Optional.ofNullable(this.cells[index]);
    }

    public Optional<Cell> getFirstNonEmptyCell() {
        return this.stream().filter(Objects::nonNull).filter(cell -> !cell.getText().isEmpty()).findFirst();
    }

    public int getCellCount() {
        return this.cells.length;
    }

    public boolean hasCell(int index) {
        return index >= 0 && index < this.cells.length && this.cells[index] != null;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getPhysicalCellCount() {
        return this.physicalCellCount;
    }

    public String toString() {
        return "Row " + this.rowNum + ' ' + Arrays.toString(this.cells);
    }

    @Override
    public Iterator<Cell> iterator() {
        return Arrays.asList(this.cells).iterator();
    }

    public Stream<Cell> stream() {
        return Arrays.stream(this.cells);
    }

    public Optional<String> getCellAsString(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::asString);
    }

    public Optional<LocalDateTime> getCellAsDate(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::asDate);
    }

    public Optional<BigDecimal> getCellAsNumber(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::asNumber);
    }

    public Optional<Boolean> getCellAsBoolean(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::asBoolean);
    }

    public String getCellText(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::getText).orElse("");
    }

    public Optional<String> getCellRawValue(int cellIndex) {
        return this.getOptionalCell(cellIndex).map(Cell::getRawValue);
    }
}

