/*
 * Decompiled with CFR 0.152.
 */
package org.devlib.schmidt.imageinfo;

import java.io.DataInput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class ImageInfo {
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_GIF = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    public static final int FORMAT_PCX = 4;
    public static final int FORMAT_IFF = 5;
    public static final int FORMAT_RAS = 6;
    public static final int FORMAT_PBM = 7;
    public static final int FORMAT_PGM = 8;
    public static final int FORMAT_PPM = 9;
    public static final int FORMAT_PSD = 10;
    private static final String[] FORMAT_NAMES = new String[]{"JPEG", "GIF", "PNG", "BMP", "PCX", "IFF", "RAS", "PBM", "PGM", "PPM", "PSD"};
    private static final String[] MIME_TYPE_STRINGS = new String[]{"image/jpeg", "image/gif", "image/png", "image/bmp", "image/pcx", "image/iff", "image/ras", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/psd"};
    private int width;
    private int height;
    private int bitsPerPixel;
    private boolean progressive;
    private int format;
    private InputStream in;
    private DataInput din;
    private boolean collectComments = true;
    private Vector comments;
    private boolean determineNumberOfImages;
    private int numberOfImages;
    private int physicalHeightDpi;
    private int physicalWidthDpi;
    private int bitBuf;
    private int bitPos;

    private void addComment(String string) {
        if (this.comments == null) {
            this.comments = new Vector();
        }
        this.comments.addElement(string);
    }

    public boolean check() {
        this.format = -1;
        this.width = -1;
        this.height = -1;
        this.bitsPerPixel = -1;
        this.numberOfImages = 1;
        this.physicalHeightDpi = -1;
        this.physicalWidthDpi = -1;
        this.comments = null;
        try {
            int n = this.read() & 0xFF;
            int n2 = this.read() & 0xFF;
            if (n == 71 && n2 == 73) {
                return this.checkGif();
            }
            if (n == 137 && n2 == 80) {
                return this.checkPng();
            }
            if (n == 255 && n2 == 216) {
                return this.checkJpeg();
            }
            if (n == 66 && n2 == 77) {
                return this.checkBmp();
            }
            if (n == 10 && n2 < 6) {
                return this.checkPcx();
            }
            if (n == 70 && n2 == 79) {
                return this.checkIff();
            }
            if (n == 89 && n2 == 166) {
                return this.checkRas();
            }
            if (n == 80 && n2 >= 49 && n2 <= 54) {
                return this.checkPnm(n2 - 48);
            }
            if (n == 56 && n2 == 66) {
                return this.checkPsd();
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean checkBmp() throws IOException {
        int n;
        byte[] byArray = new byte[44];
        if (this.read(byArray) != byArray.length) {
            return false;
        }
        this.width = ImageInfo.getIntLittleEndian(byArray, 16);
        this.height = ImageInfo.getIntLittleEndian(byArray, 20);
        if (this.width < 1 || this.height < 1) {
            return false;
        }
        this.bitsPerPixel = ImageInfo.getShortLittleEndian(byArray, 26);
        if (this.bitsPerPixel != 1 && this.bitsPerPixel != 4 && this.bitsPerPixel != 8 && this.bitsPerPixel != 16 && this.bitsPerPixel != 24 && this.bitsPerPixel != 32) {
            return false;
        }
        int n2 = (int)((double)ImageInfo.getIntLittleEndian(byArray, 36) * 0.0254);
        if (n2 > 0) {
            this.setPhysicalWidthDpi(n2);
        }
        if ((n = (int)((double)ImageInfo.getIntLittleEndian(byArray, 40) * 0.0254)) > 0) {
            this.setPhysicalHeightDpi(n);
        }
        this.format = 3;
        return true;
    }

    private boolean checkGif() throws IOException {
        int n;
        byte[] byArray = new byte[]{70, 56, 55, 97};
        byte[] byArray2 = new byte[]{70, 56, 57, 97};
        byte[] byArray3 = new byte[11];
        if (this.read(byArray3) != 11) {
            return false;
        }
        if (!ImageInfo.equals(byArray3, 0, byArray2, 0, 4) && !ImageInfo.equals(byArray3, 0, byArray, 0, 4)) {
            return false;
        }
        this.format = 1;
        this.width = ImageInfo.getShortLittleEndian(byArray3, 4);
        this.height = ImageInfo.getShortLittleEndian(byArray3, 6);
        int n2 = byArray3[8] & 0xFF;
        this.bitsPerPixel = (n2 >> 4 & 7) + 1;
        if (!this.determineNumberOfImages) {
            return true;
        }
        if ((n2 & 0x80) != 0) {
            n = (1 << (n2 & 7) + 1) * 3;
            this.skip(n);
        }
        this.numberOfImages = 0;
        do {
            n = this.read();
            switch (n) {
                case 44: {
                    int n3;
                    if (this.read(byArray3, 0, 9) != 9) {
                        return false;
                    }
                    n2 = byArray3[8] & 0xFF;
                    this.progressive = (n2 & 0x40) != 0;
                    int n4 = (n2 & 7) + 1;
                    if (n4 > this.bitsPerPixel) {
                        this.bitsPerPixel = n4;
                    }
                    if ((n2 & 0x80) != 0) {
                        this.skip((1 << n4) * 3);
                    }
                    this.skip(1);
                    do {
                        if ((n3 = this.read()) > 0) {
                            this.skip(n3);
                            continue;
                        }
                        if (n3 != -1) continue;
                        return false;
                    } while (n3 > 0);
                    ++this.numberOfImages;
                    break;
                }
                case 33: {
                    int n3;
                    int n4 = this.read();
                    if (this.collectComments && n4 == 254) {
                        int n5;
                        StringBuffer stringBuffer = new StringBuffer();
                        do {
                            if ((n5 = this.read()) == -1) {
                                return false;
                            }
                            if (n5 <= 0) continue;
                            for (int i = 0; i < n5; ++i) {
                                int n6 = this.read();
                                if (n6 == -1) {
                                    return false;
                                }
                                stringBuffer.append((char)n6);
                            }
                        } while (n5 > 0);
                        break;
                    }
                    do {
                        if ((n3 = this.read()) > 0) {
                            this.skip(n3);
                            continue;
                        }
                        if (n3 != -1) continue;
                        return false;
                    } while (n3 > 0);
                    break;
                }
                case 59: {
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (n != 59);
        return true;
    }

    private boolean checkIff() throws IOException {
        byte[] byArray = new byte[10];
        if (this.read(byArray, 0, 10) != 10) {
            return false;
        }
        byte[] byArray2 = new byte[]{82, 77};
        if (!ImageInfo.equals(byArray, 0, byArray2, 0, 2)) {
            return false;
        }
        int n = ImageInfo.getIntBigEndian(byArray, 6);
        if (n != 1229734477 && n != 1346522400) {
            return false;
        }
        while (this.read(byArray, 0, 8) == 8) {
            int n2 = ImageInfo.getIntBigEndian(byArray, 0);
            int n3 = ImageInfo.getIntBigEndian(byArray, 4);
            if ((n3 & 1) == 1) {
                ++n3;
            }
            if (n2 == 1112361028) {
                if (this.read(byArray, 0, 9) != 9) {
                    return false;
                }
                this.format = 5;
                this.width = ImageInfo.getShortBigEndian(byArray, 0);
                this.height = ImageInfo.getShortBigEndian(byArray, 2);
                this.bitsPerPixel = byArray[8] & 0xFF;
                return this.width > 0 && this.height > 0 && this.bitsPerPixel > 0 && this.bitsPerPixel < 33;
            }
            this.skip(n3);
        }
        return false;
    }

    private boolean checkJpeg() throws IOException {
        byte[] byArray = new byte[12];
        while (this.read(byArray, 0, 4) == 4) {
            byte[] byArray2;
            int n = ImageInfo.getShortBigEndian(byArray, 0);
            int n2 = ImageInfo.getShortBigEndian(byArray, 2);
            if ((n & 0xFF00) != 65280) {
                return false;
            }
            if (n == 65504) {
                if (n2 < 14) {
                    return false;
                }
                if (this.read(byArray, 0, 12) != 12) {
                    return false;
                }
                byArray2 = new byte[]{74, 70, 73, 70, 0};
                if (ImageInfo.equals(byArray2, 0, byArray, 0, 5)) {
                    if (byArray[7] == 1) {
                        this.setPhysicalWidthDpi(ImageInfo.getShortBigEndian(byArray, 8));
                        this.setPhysicalHeightDpi(ImageInfo.getShortBigEndian(byArray, 10));
                    } else if (byArray[7] == 2) {
                        int n3 = ImageInfo.getShortBigEndian(byArray, 8);
                        int n4 = ImageInfo.getShortBigEndian(byArray, 10);
                        this.setPhysicalWidthDpi((int)((float)n3 * 2.54f));
                        this.setPhysicalHeightDpi((int)((float)n4 * 2.54f));
                    }
                }
                this.skip(n2 - 14);
                continue;
            }
            if (this.collectComments && n2 > 2 && n == 65534) {
                byArray2 = new byte[n2 -= 2];
                if (this.read(byArray2, 0, n2) != n2) {
                    return false;
                }
                String string = new String(byArray2, "iso-8859-1");
                string = string.trim();
                this.addComment(string);
                continue;
            }
            if (n >= 65472 && n <= 65487 && n != 65476 && n != 65480) {
                if (this.read(byArray, 0, 6) != 6) {
                    return false;
                }
                this.format = 0;
                this.bitsPerPixel = (byArray[0] & 0xFF) * (byArray[5] & 0xFF);
                this.progressive = n == 65474 || n == 65478 || n == 65482 || n == 65486;
                this.width = ImageInfo.getShortBigEndian(byArray, 3);
                this.height = ImageInfo.getShortBigEndian(byArray, 1);
                return true;
            }
            this.skip(n2 - 2);
        }
        return false;
    }

    private boolean checkPcx() throws IOException {
        byte[] byArray = new byte[64];
        if (this.read(byArray) != byArray.length) {
            return false;
        }
        if (byArray[0] != 1) {
            return false;
        }
        int n = ImageInfo.getShortLittleEndian(byArray, 2);
        int n2 = ImageInfo.getShortLittleEndian(byArray, 4);
        int n3 = ImageInfo.getShortLittleEndian(byArray, 6);
        int n4 = ImageInfo.getShortLittleEndian(byArray, 8);
        if (n < 0 || n3 < n || n2 < 0 || n4 < n2) {
            return false;
        }
        this.width = n3 - n + 1;
        this.height = n4 - n2 + 1;
        int n5 = byArray[1];
        byte by = byArray[63];
        if (by == 1 && (n5 == 1 || n5 == 2 || n5 == 4 || n5 == 8)) {
            this.bitsPerPixel = n5;
        } else if (by == 3 && n5 == 8) {
            this.bitsPerPixel = 24;
        } else {
            return false;
        }
        this.setPhysicalWidthDpi(ImageInfo.getShortLittleEndian(byArray, 10));
        this.setPhysicalHeightDpi(ImageInfo.getShortLittleEndian(byArray, 10));
        this.format = 4;
        return true;
    }

    private boolean checkPng() throws IOException {
        byte[] byArray = new byte[]{78, 71, 13, 10, 26, 10};
        byte[] byArray2 = new byte[27];
        if (this.read(byArray2) != 27) {
            return false;
        }
        if (!ImageInfo.equals(byArray2, 0, byArray, 0, 6)) {
            return false;
        }
        this.format = 2;
        this.width = ImageInfo.getIntBigEndian(byArray2, 14);
        this.height = ImageInfo.getIntBigEndian(byArray2, 18);
        this.bitsPerPixel = byArray2[22] & 0xFF;
        int n = byArray2[23] & 0xFF;
        if (n == 2 || n == 6) {
            this.bitsPerPixel *= 3;
        }
        this.progressive = (byArray2[26] & 0xFF) != 0;
        return true;
    }

    private boolean checkPnm(int n) throws IOException {
        int n2;
        String string;
        if (n < 1 || n > 6) {
            return false;
        }
        int[] nArray = new int[]{7, 8, 9};
        this.format = nArray[(n - 1) % 3];
        boolean bl = false;
        while (true) {
            if ((string = this.readLine()) != null) {
                string = string.trim();
            }
            if (string == null || string.length() < 1) continue;
            if (string.charAt(0) == '#') {
                if (!this.collectComments || string.length() <= 1) continue;
                this.addComment(string.substring(1));
                continue;
            }
            if (bl) break;
            n2 = string.indexOf(32);
            if (n2 == -1) {
                return false;
            }
            String string2 = string.substring(0, n2);
            n2 = string.lastIndexOf(32);
            if (n2 == -1) {
                return false;
            }
            String string3 = string.substring(n2 + 1);
            try {
                this.width = Integer.parseInt(string2);
                this.height = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (this.width < 1 || this.height < 1) {
                return false;
            }
            if (this.format == 7) {
                this.bitsPerPixel = 1;
                return true;
            }
            bl = true;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        for (int i = 0; i < 25; ++i) {
            if (n2 >= 1 << i + 1) continue;
            this.bitsPerPixel = i + 1;
            if (this.format == 9) {
                this.bitsPerPixel *= 3;
            }
            return true;
        }
        return false;
    }

    private boolean checkPsd() throws IOException {
        byte[] byArray = new byte[24];
        if (this.read(byArray) != byArray.length) {
            return false;
        }
        byte[] byArray2 = new byte[]{80, 83};
        if (!ImageInfo.equals(byArray, 0, byArray2, 0, 2)) {
            return false;
        }
        this.format = 10;
        this.width = ImageInfo.getIntBigEndian(byArray, 16);
        this.height = ImageInfo.getIntBigEndian(byArray, 12);
        int n = ImageInfo.getShortBigEndian(byArray, 10);
        int n2 = ImageInfo.getShortBigEndian(byArray, 20);
        this.bitsPerPixel = n * n2;
        return this.width > 0 && this.height > 0 && this.bitsPerPixel > 0 && this.bitsPerPixel <= 64;
    }

    private boolean checkRas() throws IOException {
        byte[] byArray = new byte[14];
        if (this.read(byArray) != byArray.length) {
            return false;
        }
        byte[] byArray2 = new byte[]{106, -107};
        if (!ImageInfo.equals(byArray, 0, byArray2, 0, 2)) {
            return false;
        }
        this.format = 6;
        this.width = ImageInfo.getIntBigEndian(byArray, 2);
        this.height = ImageInfo.getIntBigEndian(byArray, 6);
        this.bitsPerPixel = ImageInfo.getIntBigEndian(byArray, 10);
        return this.width > 0 && this.height > 0 && this.bitsPerPixel > 0 && this.bitsPerPixel <= 24;
    }

    private static boolean determineVerbosity(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"-c".equals(stringArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public String getComment(int n) {
        if (this.comments == null || n < 0 || n >= this.comments.size()) {
            throw new IllegalArgumentException("Not a valid comment index: " + n);
        }
        return (String)this.comments.elementAt(n);
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        if (this.format >= 0 && this.format < FORMAT_NAMES.length) {
            return FORMAT_NAMES[this.format];
        }
        return "?";
    }

    public int getHeight() {
        return this.height;
    }

    private static int getIntBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getIntLittleEndian(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public String getMimeType() {
        if (this.format >= 0 && this.format < MIME_TYPE_STRINGS.length) {
            if (this.format == 0 && this.progressive) {
                return "image/pjpeg";
            }
            return MIME_TYPE_STRINGS[this.format];
        }
        return null;
    }

    public int getNumberOfComments() {
        if (this.comments == null) {
            return 0;
        }
        return this.comments.size();
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public int getPhysicalHeightDpi() {
        return this.physicalHeightDpi;
    }

    public float getPhysicalHeightInch() {
        int n = this.getHeight();
        int n2 = this.getPhysicalHeightDpi();
        if (n > 0 && n2 > 0) {
            return (float)n / (float)n2;
        }
        return -1.0f;
    }

    public int getPhysicalWidthDpi() {
        return this.physicalWidthDpi;
    }

    public float getPhysicalWidthInch() {
        int n = this.getWidth();
        int n2 = this.getPhysicalWidthDpi();
        if (n > 0 && n2 > 0) {
            return (float)n / (float)n2;
        }
        return -1.0f;
    }

    private static int getShortBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getShortLittleEndian(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isProgressive() {
        return this.progressive;
    }

    public static void main(String[] stringArray) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setDetermineImageNumber(true);
        boolean bl = ImageInfo.determineVerbosity(stringArray);
        if (stringArray.length == 0) {
            ImageInfo.run(null, System.in, imageInfo, bl);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                InputStream inputStream = null;
                try {
                    String string = stringArray[n++];
                    System.out.print(string + ";");
                    inputStream = string.startsWith("http://") ? new URL(string).openConnection().getInputStream() : new FileInputStream(string);
                    ImageInfo.run(string, inputStream, imageInfo, bl);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
        }
    }

    private static void print(String string, ImageInfo imageInfo, boolean bl) {
        if (bl) {
            ImageInfo.printVerbose(string, imageInfo);
        } else {
            ImageInfo.printCompact(string, imageInfo);
        }
    }

    private static void printCompact(String string, ImageInfo imageInfo) {
        System.out.println(string + "\t" + imageInfo.getFormatName() + "\t" + imageInfo.getMimeType() + "\t" + imageInfo.getWidth() + "\t" + imageInfo.getHeight() + "\t" + imageInfo.getBitsPerPixel() + "\t" + imageInfo.getNumberOfImages() + "\t" + imageInfo.getPhysicalWidthDpi() + "\t" + imageInfo.getPhysicalHeightDpi() + "\t" + imageInfo.getPhysicalWidthInch() + "\t" + imageInfo.getPhysicalHeightInch() + "\t" + imageInfo.isProgressive());
    }

    private static void printLine(int n, String string, float f, float f2) {
        if (f < f2) {
            return;
        }
        ImageInfo.printLine(n, string, Float.toString(f));
    }

    private static void printLine(int n, String string, int n2, int n3) {
        if (n2 >= n3) {
            ImageInfo.printLine(n, string, Integer.toString(n2));
        }
    }

    private static void printLine(int n, String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        while (n-- > 0) {
            System.out.print("\t");
        }
        if (string != null && string.length() > 0) {
            System.out.print(string);
            System.out.print(" ");
        }
        System.out.println(string2);
    }

    private static void printVerbose(String string, ImageInfo imageInfo) {
        ImageInfo.printLine(0, null, string);
        ImageInfo.printLine(1, "File format: ", imageInfo.getFormatName());
        ImageInfo.printLine(1, "MIME type: ", imageInfo.getMimeType());
        ImageInfo.printLine(1, "Width (pixels): ", imageInfo.getWidth(), 1);
        ImageInfo.printLine(1, "Height (pixels): ", imageInfo.getHeight(), 1);
        ImageInfo.printLine(1, "Bits per pixel: ", imageInfo.getBitsPerPixel(), 1);
        ImageInfo.printLine(1, "Progressive: ", imageInfo.isProgressive() ? "yes" : "no");
        ImageInfo.printLine(1, "Number of images: ", imageInfo.getNumberOfImages(), 1);
        ImageInfo.printLine(1, "Physical width (dpi): ", imageInfo.getPhysicalWidthDpi(), 1);
        ImageInfo.printLine(1, "Physical height (dpi): ", imageInfo.getPhysicalHeightDpi(), 1);
        ImageInfo.printLine(1, "Physical width (inches): ", imageInfo.getPhysicalWidthInch(), 1.0f);
        ImageInfo.printLine(1, "Physical height (inches): ", imageInfo.getPhysicalHeightInch(), 1.0f);
        int n = imageInfo.getNumberOfComments();
        ImageInfo.printLine(1, "Number of textual comments: ", n, 1);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ImageInfo.printLine(2, null, imageInfo.getComment(i));
            }
        }
    }

    private int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        return this.din.readByte();
    }

    private int read(byte[] byArray) throws IOException {
        if (this.in != null) {
            return this.in.read(byArray);
        }
        this.din.readFully(byArray);
        return byArray.length;
    }

    private int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in != null) {
            return this.in.read(byArray, n, n2);
        }
        this.din.readFully(byArray, n, n2);
        return n2;
    }

    private String readLine() throws IOException {
        return this.readLine(new StringBuffer());
    }

    private String readLine(StringBuffer stringBuffer) throws IOException {
        boolean bl;
        do {
            int n;
            boolean bl2 = bl = (n = this.read()) == -1 || n == 10;
            if (bl) continue;
            stringBuffer.append((char)n);
        } while (!bl);
        return stringBuffer.toString();
    }

    private long readUBits(int n) throws IOException {
        int n2;
        if (n == 0) {
            return 0L;
        }
        int n3 = n;
        long l = 0L;
        if (this.bitPos == 0) {
            this.bitBuf = this.in != null ? this.in.read() : (int)this.din.readByte();
            this.bitPos = 8;
        }
        while ((n2 = n3 - this.bitPos) > 0) {
            l |= (long)(this.bitBuf << n2);
            n3 -= this.bitPos;
            this.bitBuf = this.in != null ? this.in.read() : (int)this.din.readByte();
            this.bitPos = 8;
        }
        this.bitPos -= n3;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return l |= (long)(this.bitBuf >> -n2);
    }

    private int readSBits(int n) throws IOException {
        long l = this.readUBits(n);
        if ((l & 1L << n - 1) != 0L) {
            l |= -1L << n;
        }
        return (int)l;
    }

    private static void run(String string, InputStream inputStream, ImageInfo imageInfo, boolean bl) {
        imageInfo.setInput(inputStream);
        imageInfo.setDetermineImageNumber(true);
        imageInfo.setCollectComments(bl);
        if (imageInfo.check()) {
            ImageInfo.print(string, imageInfo, bl);
        }
    }

    public void setCollectComments(boolean bl) {
        this.collectComments = bl;
    }

    public void setDetermineImageNumber(boolean bl) {
        this.determineNumberOfImages = bl;
    }

    public void setInput(DataInput dataInput) {
        this.din = dataInput;
        this.in = null;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
        this.din = null;
    }

    private void setPhysicalHeightDpi(int n) {
        this.physicalWidthDpi = n;
    }

    private void setPhysicalWidthDpi(int n) {
        this.physicalHeightDpi = n;
    }

    private void skip(int n) throws IOException {
        while (n > 0) {
            long l = this.in != null ? this.in.skip(n) : (long)this.din.skipBytes(n);
            if (l <= 0L) continue;
            n = (int)((long)n - l);
        }
    }
}

