/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.omnihub;

public enum Framework {
    SAMEDIFF(0),
    PYTORCH(1),
    TENSORFLOW(2),
    KERAS(3),
    DL4J(4),
    ONNX(5),
    HUGGINGFACE(6);

    private final int frameworkIndex;

    private Framework(int index) {
        this.frameworkIndex = index;
    }

    public int frameworkIndex() {
        return this.frameworkIndex;
    }

    public static boolean isInput(Framework framework) {
        switch (framework) {
            case TENSORFLOW: 
            case KERAS: 
            case PYTORCH: 
            case ONNX: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOutput(Framework framework) {
        return !Framework.isInput(framework);
    }

    public static Framework outputFrameworkFor(Framework framework) {
        if (!Framework.isInput(framework)) {
            throw new IllegalArgumentException("Input framework " + framework.name() + " is not an input framework");
        }
        switch (framework) {
            case TENSORFLOW: 
            case PYTORCH: 
            case ONNX: {
                return SAMEDIFF;
            }
        }
        return DL4J;
    }
}

