/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.RnnOutputLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class TextGenerationLSTM
extends ZooModel {
    private long seed;
    private int maxLength;
    private int totalUniqueCharacters;
    private int[] inputShape;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private TextGenerationLSTM() {
        this.inputShape = new int[]{this.maxLength, this.totalUniqueCharacters};
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return MultiLayerNetwork.class;
    }

    public MultiLayerConfiguration conf() {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(12345L).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).l2(0.001).weightInit(WeightInit.XAVIER).updater(this.updater).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).list().layer(0, (Layer)((GravesLSTM.Builder)((GravesLSTM.Builder)((GravesLSTM.Builder)new GravesLSTM.Builder().nIn(this.inputShape[1])).nOut(256)).activation(Activation.TANH)).build()).layer(1, (Layer)((GravesLSTM.Builder)((GravesLSTM.Builder)new GravesLSTM.Builder().nOut(256)).activation(Activation.TANH)).build()).layer(2, (Layer)((RnnOutputLayer.Builder)((RnnOutputLayer.Builder)new RnnOutputLayer.Builder(LossFunctions.LossFunction.MCXENT).activation(Activation.SOFTMAX)).nOut(this.totalUniqueCharacters)).build()).backpropType(BackpropType.TruncatedBPTT).tBPTTForwardLength(50).tBPTTBackwardLength(50).pretrain(false).backprop(true).build();
        return conf;
    }

    public Model init() {
        MultiLayerNetwork network = new MultiLayerNetwork(this.conf());
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.RNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int $default$maxLength() {
        return 40;
    }

    private static int $default$totalUniqueCharacters() {
        return 47;
    }

    private static IUpdater $default$updater() {
        return new RmsProp(0.01);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static TextGenerationLSTMBuilder builder() {
        return new TextGenerationLSTMBuilder();
    }

    public TextGenerationLSTM(long seed, int maxLength, int totalUniqueCharacters, int[] inputShape, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.inputShape = new int[]{this.maxLength, this.totalUniqueCharacters};
        this.seed = seed;
        this.maxLength = maxLength;
        this.totalUniqueCharacters = totalUniqueCharacters;
        this.inputShape = inputShape;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class TextGenerationLSTMBuilder {
        private boolean seed$set;
        private long seed;
        private boolean maxLength$set;
        private int maxLength;
        private boolean totalUniqueCharacters$set;
        private int totalUniqueCharacters;
        private int[] inputShape;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        TextGenerationLSTMBuilder() {
        }

        public TextGenerationLSTMBuilder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            this.maxLength$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder totalUniqueCharacters(int totalUniqueCharacters) {
            this.totalUniqueCharacters = totalUniqueCharacters;
            this.totalUniqueCharacters$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            return this;
        }

        public TextGenerationLSTMBuilder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public TextGenerationLSTMBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public TextGenerationLSTM build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = TextGenerationLSTM.$default$seed();
            }
            int maxLength = this.maxLength;
            if (!this.maxLength$set) {
                maxLength = TextGenerationLSTM.$default$maxLength();
            }
            int totalUniqueCharacters = this.totalUniqueCharacters;
            if (!this.totalUniqueCharacters$set) {
                totalUniqueCharacters = TextGenerationLSTM.$default$totalUniqueCharacters();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = TextGenerationLSTM.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = TextGenerationLSTM.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = TextGenerationLSTM.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = TextGenerationLSTM.$default$cudnnAlgoMode();
            }
            return new TextGenerationLSTM(seed, maxLength, totalUniqueCharacters, this.inputShape, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "TextGenerationLSTM.TextGenerationLSTMBuilder(seed=" + this.seed + ", maxLength=" + this.maxLength + ", totalUniqueCharacters=" + this.totalUniqueCharacters + ", inputShape=" + Arrays.toString(this.inputShape) + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

