/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class Darknet19
extends ZooModel {
    private int[] inputShape = new int[]{3, 224, 224};
    private int numLabels;
    private long seed;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public Darknet19(int numLabels, long seed) {
        this(numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public Darknet19(int numLabels, long seed, WorkspaceMode workspaceMode) {
        this.numLabels = numLabels;
        this.seed = seed;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            if (this.inputShape[1] == 448 && this.inputShape[2] == 448) {
                return "http://blob.deeplearning4j.org/models/darknet19_448_dl4j_inference.v1.zip";
            }
            return "http://blob.deeplearning4j.org/models/darknet19_dl4j_inference.v1.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            if (this.inputShape[1] == 448 && this.inputShape[2] == 448) {
                return 870575230L;
            }
            return 3952910425L;
        }
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.DARKNET19;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).updater((IUpdater)new Nesterovs(0.001, 0.9)).l2(1.0E-5).activation(Activation.IDENTITY).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 32, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 32, 64, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 64, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 4, 1, 128, 64, 0);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 64, 128, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 128, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 7, 1, 256, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 128, 256, 2);
        DarknetHelper.addLayers(graphBuilder, 9, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 10, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 11, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 12, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 13, 3, 256, 512, 2);
        DarknetHelper.addLayers(graphBuilder, 14, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 15, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 16, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 17, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 18, 3, 512, 1024, 0);
        int layerNumber = 19;
        graphBuilder.addLayer("convolution2d_" + layerNumber, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(this.numLabels)).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).build(), new String[]{"activation_" + (layerNumber - 1)}).addLayer("globalpooling", (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build(), new String[]{"convolution2d_" + layerNumber}).addLayer("softmax", (Layer)new ActivationLayer.Builder().activation(Activation.SOFTMAX).build(), new String[]{"globalpooling"}).addLayer("loss", (Layer)new LossLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).build(), new String[]{"softmax"}).setOutputs(new String[]{"loss"}).backprop(true).pretrain(false);
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public Darknet19() {
    }
}

