/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model.helper;

import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.graph.ScaleVertex;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.activations.Activation;

public class InceptionResNetHelper {
    public static String nameLayer(String blockName, String layerName, int i) {
        return blockName + "-" + layerName + "-" + i;
    }

    public static ComputationGraphConfiguration.GraphBuilder inceptionV1ResA(ComputationGraphConfiguration.GraphBuilder graph, String blockName, int scale, double activationScale, String input) {
        String previousBlock = input;
        for (int i = 1; i <= scale; ++i) {
            graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn1", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(192).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch1", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn2", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(192).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch2", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn3", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same).nIn(32).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch3", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn3", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn4", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(192).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch4", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn4", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn5", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same).nIn(32).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch4", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch5", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn5", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn6", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same).nIn(32).nOut(32).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch5", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch6", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(32)).nOut(32)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn6", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "merge1", i), (GraphVertex)new MergeVertex(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch1", i), InceptionResNetHelper.nameLayer(blockName, "batch3", i), InceptionResNetHelper.nameLayer(blockName, "batch6", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn7", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 3}).convolutionMode(ConvolutionMode.Same).nIn(96).nOut(192).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "merge1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch7", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn7", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "scaling", i), (GraphVertex)new ScaleVertex(activationScale), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch7", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i), (Layer)new ActivationLayer.Builder().activation(Activation.IDENTITY).build(), new String[]{previousBlock}).addVertex(InceptionResNetHelper.nameLayer(blockName, "shortcut", i), (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{InceptionResNetHelper.nameLayer(blockName, "scaling", i), InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i)});
            if (i == scale) {
                graph.addLayer(blockName, (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            } else {
                graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "activation", i), (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            }
            previousBlock = InceptionResNetHelper.nameLayer(blockName, "activation", i);
        }
        return graph;
    }

    public static ComputationGraphConfiguration.GraphBuilder inceptionV1ResB(ComputationGraphConfiguration.GraphBuilder graph, String blockName, int scale, double activationScale, String input) {
        graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "activation1", 0), (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{input});
        String previousBlock = InceptionResNetHelper.nameLayer(blockName, "activation1", 0);
        for (int i = 1; i <= scale; ++i) {
            graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn1", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(576).nOut(128).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch1", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn2", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(576).nOut(128).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch2", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn3", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 3}).convolutionMode(ConvolutionMode.Same).nIn(128).nOut(128).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch3", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn3", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn4", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 1}).convolutionMode(ConvolutionMode.Same).nIn(128).nOut(128).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch3", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch4", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(128)).nOut(128)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn4", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "merge1", i), (GraphVertex)new MergeVertex(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch1", i), InceptionResNetHelper.nameLayer(blockName, "batch4", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn5", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(256).nOut(576).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "merge1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch5", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(576)).nOut(576)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn5", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "scaling", i), (GraphVertex)new ScaleVertex(activationScale), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch5", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i), (Layer)new ActivationLayer.Builder().activation(Activation.IDENTITY).build(), new String[]{previousBlock}).addVertex(InceptionResNetHelper.nameLayer(blockName, "shortcut", i), (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{InceptionResNetHelper.nameLayer(blockName, "scaling", i), InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i)});
            if (i == scale) {
                graph.addLayer(blockName, (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            } else {
                graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "activation", i), (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            }
            previousBlock = InceptionResNetHelper.nameLayer(blockName, "activation", i);
        }
        return graph;
    }

    public static ComputationGraphConfiguration.GraphBuilder inceptionV1ResC(ComputationGraphConfiguration.GraphBuilder graph, String blockName, int scale, double activationScale, String input) {
        String previousBlock = input;
        for (int i = 1; i <= scale; ++i) {
            graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn1", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(1344).nOut(192).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch1", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn2", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(1344).nOut(192).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{previousBlock}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch2", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn3", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 3}).convolutionMode(ConvolutionMode.Same).nIn(192).nOut(192).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch2", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch3", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).nIn(192)).nOut(192)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn3", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn4", i), (Layer)new ConvolutionLayer.Builder(new int[]{3, 1}).convolutionMode(ConvolutionMode.Same).nIn(192).nOut(192).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch3", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch4", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).activation(Activation.TANH)).nIn(192)).nOut(192)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn4", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "merge1", i), (GraphVertex)new MergeVertex(), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch1", i), InceptionResNetHelper.nameLayer(blockName, "batch4", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "cnn5", i), (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same).nIn(384).nOut(1344).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "merge1", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "batch5", i), (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).decay(0.995).eps(0.001).activation(Activation.TANH)).nIn(1344)).nOut(1344)).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "cnn5", i)}).addVertex(InceptionResNetHelper.nameLayer(blockName, "scaling", i), (GraphVertex)new ScaleVertex(activationScale), new String[]{InceptionResNetHelper.nameLayer(blockName, "batch5", i)}).addLayer(InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i), (Layer)new ActivationLayer.Builder().activation(Activation.IDENTITY).build(), new String[]{previousBlock}).addVertex(InceptionResNetHelper.nameLayer(blockName, "shortcut", i), (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{InceptionResNetHelper.nameLayer(blockName, "scaling", i), InceptionResNetHelper.nameLayer(blockName, "shortcut-identity", i)});
            if (i == scale) {
                graph.addLayer(blockName, (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            } else {
                graph.addLayer(InceptionResNetHelper.nameLayer(blockName, "activation", i), (Layer)new ActivationLayer.Builder().activation(Activation.TANH).build(), new String[]{InceptionResNetHelper.nameLayer(blockName, "shortcut", i)});
            }
            previousBlock = InceptionResNetHelper.nameLayer(blockName, "activation", i);
        }
        return graph;
    }
}

