/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class ResNet50
extends ZooModel {
    private int[] inputShape = new int[]{3, 224, 224};
    private long seed;
    private int iterations;
    private int numClasses;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public ResNet50(int numLabels, long seed, int iterations) {
        this(numLabels, seed, iterations, WorkspaceMode.SEPARATE);
    }

    public ResNet50(int outputNum, long seed, int iterations, WorkspaceMode workspaceMode) {
        this.seed = seed;
        this.numClasses = outputNum;
        this.iterations = iterations;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return "http://blob.deeplearning4j.org/models/resnet50_dl4j_inference.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 1982516793L;
        }
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.RESNET50;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    private void identityBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, String input) {
        String convName = "res" + stage + block + "_branch";
        String batchName = "bn" + stage + block + "_branch";
        String activationName = "act" + stage + block + "_branch";
        String shortcutName = "short" + stage + block + "_branch";
        graph.addLayer(convName + "2a", (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[0]).cudnnAlgoMode(this.cudnnAlgoMode).build(), new String[]{input}).addLayer(batchName + "2a", (Layer)new BatchNormalization(), new String[]{convName + "2a"}).addLayer(activationName + "2a", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2a"}).addLayer(convName + "2b", (Layer)new ConvolutionLayer.Builder(kernelSize).nOut(filters[1]).cudnnAlgoMode(this.cudnnAlgoMode).convolutionMode(ConvolutionMode.Same).build(), new String[]{activationName + "2a"}).addLayer(batchName + "2b", (Layer)new BatchNormalization(), new String[]{convName + "2b"}).addLayer(activationName + "2b", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2b"}).addLayer(convName + "2c", (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[2]).cudnnAlgoMode(this.cudnnAlgoMode).build(), new String[]{activationName + "2b"}).addLayer(batchName + "2c", (Layer)new BatchNormalization(), new String[]{convName + "2c"}).addVertex(shortcutName, (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{batchName + "2c", input}).addLayer(convName, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{shortcutName});
    }

    private void convBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, String input) {
        this.convBlock(graph, kernelSize, filters, stage, block, new int[]{2, 2}, input);
    }

    private void convBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, int[] stride, String input) {
        String convName = "res" + stage + block + "_branch";
        String batchName = "bn" + stage + block + "_branch";
        String activationName = "act" + stage + block + "_branch";
        String shortcutName = "short" + stage + block + "_branch";
        graph.addLayer(convName + "2a", (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}, stride).nOut(filters[0]).build(), new String[]{input}).addLayer(batchName + "2a", (Layer)new BatchNormalization(), new String[]{convName + "2a"}).addLayer(activationName + "2a", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2a"}).addLayer(convName + "2b", (Layer)new ConvolutionLayer.Builder(kernelSize).nOut(filters[1]).convolutionMode(ConvolutionMode.Same).build(), new String[]{activationName + "2a"}).addLayer(batchName + "2b", (Layer)new BatchNormalization(), new String[]{convName + "2b"}).addLayer(activationName + "2b", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2b"}).addLayer(convName + "2c", (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[2]).build(), new String[]{activationName + "2b"}).addLayer(batchName + "2c", (Layer)new BatchNormalization(), new String[]{convName + "2c"}).addLayer(convName + "1", (Layer)new ConvolutionLayer.Builder(new int[]{1, 1}, stride).nOut(filters[2]).build(), new String[]{input}).addLayer(batchName + "1", (Layer)new BatchNormalization(), new String[]{convName + "1"}).addVertex(shortcutName, (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{batchName + "2c", batchName + "1"}).addLayer(convName, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{shortcutName});
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).iterations(this.iterations).activation(Activation.IDENTITY).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater((IUpdater)new RmsProp(0.1, 0.96, 0.001)).weightInit(WeightInit.DISTRIBUTION).dist((Distribution)new NormalDistribution(0.0, 0.5)).regularization(true).l1(1.0E-7).l2(5.0E-5).miniBatch(true).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])}).addLayer("stem-zero", (Layer)new ZeroPaddingLayer.Builder(3, 3).build(), new String[]{"input"}).addLayer("stem-cnn1", (Layer)new ConvolutionLayer.Builder(new int[]{7, 7}, new int[]{2, 2}).nOut(64).build(), new String[]{"stem-zero"}).addLayer("stem-batch1", (Layer)new BatchNormalization(), new String[]{"stem-cnn1"}).addLayer("stem-act1", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"stem-batch1"}).addLayer("stem-maxpool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).build(), new String[]{"stem-act1"});
        this.convBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "a", new int[]{2, 2}, "stem-maxpool1");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "b", "res2a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "c", "res2b_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "a", "res2c_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "b", "res3a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "c", "res3b_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "d", "res3c_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "a", "res3d_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "b", "res4a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "c", "res4b_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "d", "res4c_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "e", "res4d_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "f", "res4e_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "a", "res4f_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "b", "res5a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "c", "res5b_branch");
        graph.addLayer("avgpool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}).build(), new String[]{"res5c_branch"}).addLayer("output", (Layer)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).nOut(this.numClasses)).activation(Activation.SOFTMAX)).build(), new String[]{"avgpool"}).setOutputs(new String[]{"output"}).backprop(true).pretrain(false);
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public ResNet50() {
    }
}

