/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.tsne;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.core.storage.StatsStorage;
import org.deeplearning4j.core.storage.StatsStorageEvent;
import org.deeplearning4j.nn.conf.serde.JsonMappers;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.nd4j.shade.jackson.core.JsonProcessingException;

public class TsneModule
implements UIModule {
    private static final String UPLOADED_FILE = "UploadedFile";
    private Map<String, List<String>> knownSessionIDs = Collections.synchronizedMap(new LinkedHashMap());
    private List<String> uploadedFileLines = null;

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Route> getRoutes() {
        Route r1 = new Route("/tsne", HttpMethod.GET, (path, rc) -> rc.response().sendFile("templates/Tsne.html"));
        Route r2 = new Route("/tsne/sessions", HttpMethod.GET, (path, rc) -> this.listSessions((RoutingContext)rc));
        Route r3 = new Route("/tsne/coords/:sid", HttpMethod.GET, (path, rc) -> this.getCoords((String)path.get(0), (RoutingContext)rc));
        Route r4 = new Route("/tsne/upload", HttpMethod.POST, (path, rc) -> this.uploadFile((RoutingContext)rc));
        Route r5 = new Route("/tsne/post/:sid", HttpMethod.POST, (path, rc) -> this.postFile((String)path.get(0), (RoutingContext)rc));
        return Arrays.asList(r1, r2, r3, r4, r5);
    }

    @Override
    public void reportStorageEvents(Collection<StatsStorageEvent> events) {
    }

    @Override
    public void onAttach(StatsStorage statsStorage) {
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
    }

    @Override
    public List<I18NResource> getInternationalizationResources() {
        return Collections.emptyList();
    }

    private String asJson(Object o) {
        try {
            return JsonMappers.getMapper().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error converting object to JSON", e);
        }
    }

    private void listSessions(RoutingContext rc) {
        ArrayList<String> list = new ArrayList<String>(this.knownSessionIDs.keySet());
        if (this.uploadedFileLines != null) {
            list.add(UPLOADED_FILE);
        }
        rc.response().putHeader("content-type", "application/json").end(this.asJson(list));
    }

    private void getCoords(String sessionId, RoutingContext rc) {
        if (UPLOADED_FILE.equals(sessionId) && this.uploadedFileLines != null) {
            rc.response().putHeader("content-type", "application/json").end(this.asJson(this.uploadedFileLines));
        } else if (this.knownSessionIDs.containsKey(sessionId)) {
            rc.response().putHeader("content-type", "application/json").end(this.asJson(this.knownSessionIDs.get(sessionId)));
        } else {
            rc.response().end();
        }
    }

    private void uploadFile(RoutingContext rc) {
        this.postFile(null, rc);
    }

    private void postFile(String sid, RoutingContext rc) {
        List lines;
        Set files = rc.fileUploads();
        if (files == null || files.isEmpty()) {
            rc.response().end();
            return;
        }
        FileUpload u = (FileUpload)files.iterator().next();
        File f = new File(u.uploadedFileName());
        try {
            lines = FileUtils.readLines((File)f, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            rc.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Could not read from uploaded file");
            return;
        }
        if (sid == null) {
            this.uploadedFileLines = lines;
        } else {
            this.knownSessionIDs.put(sid, lines);
        }
        rc.response().end("File uploaded: " + u.fileName() + ", " + u.contentType());
    }
}

