/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ScrollableDataSetIterator
implements DataSetIterator {
    private int thisPart = 0;
    private int top = 0;
    private int bottom = 0;
    protected DataSetIterator backedIterator;
    protected AtomicLong counter = new AtomicLong(0L);
    protected AtomicBoolean resetPending = new AtomicBoolean(false);
    protected DataSet firstTrain = null;
    protected MultiDataSet firstMultiTrain = null;
    private double ratio;
    private long totalExamples;
    private long itemsPerPart;
    private long current;

    public ScrollableDataSetIterator(int num, DataSetIterator backedIterator, AtomicLong counter, AtomicBoolean resetPending, DataSet firstTrain, double ratio, int totalExamples) {
        this.thisPart = num;
        this.backedIterator = backedIterator;
        this.counter = counter;
        this.resetPending = resetPending;
        this.firstTrain = firstTrain;
        this.ratio = ratio;
        this.totalExamples = totalExamples;
        this.itemsPerPart = (long)((double)totalExamples * ratio);
        this.current = 0L;
    }

    public ScrollableDataSetIterator(int num, DataSetIterator backedIterator, AtomicLong counter, AtomicBoolean resetPending, DataSet firstTrain, int[] itemsPerPart) {
        this.thisPart = num;
        this.bottom = itemsPerPart[0];
        this.top = this.bottom + itemsPerPart[1];
        this.itemsPerPart = this.top;
        this.backedIterator = backedIterator;
        this.counter = counter;
        this.firstTrain = firstTrain;
        this.current = 0L;
    }

    public DataSet next(int i) {
        throw new UnsupportedOperationException();
    }

    public List<String> getLabels() {
        return this.backedIterator.getLabels();
    }

    public int inputColumns() {
        return this.backedIterator.inputColumns();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalOutcomes() {
        return this.backedIterator.totalOutcomes();
    }

    public boolean resetSupported() {
        return this.backedIterator.resetSupported();
    }

    public boolean asyncSupported() {
        return this.backedIterator.asyncSupported();
    }

    public void reset() {
        this.resetPending.set(true);
    }

    public int batch() {
        return this.backedIterator.batch();
    }

    public void setPreProcessor(DataSetPreProcessor dataSetPreProcessor) {
        this.backedIterator.setPreProcessor(dataSetPreProcessor);
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.backedIterator.getPreProcessor();
    }

    public boolean hasNext() {
        if (this.resetPending.get()) {
            if (this.resetSupported()) {
                this.backedIterator.reset();
                this.counter.set(0L);
                this.current = 0L;
                this.resetPending.set(false);
            } else {
                throw new UnsupportedOperationException("Reset isn't supported by underlying iterator");
            }
        }
        boolean state = false;
        if (this.current >= (long)this.top) {
            return false;
        }
        state = this.backedIterator.hasNext();
        if (!state) {
            return false;
        }
        return state && this.counter.get() < this.itemsPerPart;
    }

    public DataSet next() {
        this.counter.incrementAndGet();
        if (this.current == 0L && this.bottom != 0) {
            long cnt;
            this.backedIterator.reset();
            for (cnt = this.current; cnt < (long)this.bottom; ++cnt) {
                if (!this.backedIterator.hasNext()) continue;
                this.backedIterator.next();
            }
            this.current = cnt + 1L;
        } else {
            ++this.current;
        }
        DataSet p = (DataSet)this.backedIterator.next();
        return p;
    }
}

