/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow;

import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.deeplearning4j.ui.flow.beans.ModelInfo;
import org.deeplearning4j.ui.flow.beans.ModelState;
import org.deeplearning4j.ui.flow.beans.NodeReport;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;

@Path(value="/flow")
public class FlowResource {
    private SessionStorage storage = SessionStorage.getInstance();

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getInfo(@QueryParam(value="sid") String sessionId) {
        ModelInfo model = (ModelInfo)this.storage.getObject(sessionId, ObjectType.FLOW);
        return Response.ok((Object)model).build();
    }

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    public Response getState(@QueryParam(value="sid") String sessionId) {
        ModelState modelState = (ModelState)this.storage.getObject(sessionId, ObjectType.FLOW_STATE);
        return Response.ok((Object)modelState).build();
    }

    @POST
    @Path(value="/info")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postInfo(ModelInfo info, @QueryParam(value="sid") String sessionId) {
        this.storage.putObject(sessionId, ObjectType.FLOW, info);
        return Response.ok(Collections.singletonMap("status", "ok")).build();
    }

    @POST
    @Path(value="/state")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postState(ModelState state, @QueryParam(value="sid") String sessionId) {
        this.storage.putObject(sessionId, ObjectType.FLOW_STATE, state);
        return Response.ok(Collections.singletonMap("status", "ok")).build();
    }

    @GET
    @Path(value="/action/{id}")
    @Produces(value={"text/html"})
    public Response getAction(@PathParam(value="id") long id) {
        return Response.ok().build();
    }

    @POST
    @Path(value="/action/{id}")
    @Consumes(value={"application/json"})
    public Response postState(@PathParam(value="id") long id, NodeReport report) {
        return Response.ok().build();
    }
}

