/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.ui.storage.def.ObjectType;

public class SessionStorage {
    private static final SessionStorage INSTANCE = new SessionStorage();
    private Table<String, ObjectType, Object> storage = HashBasedTable.create();
    private ConcurrentHashMap<String, AtomicLong> accessTime = new ConcurrentHashMap();
    private ReentrantReadWriteLock singleLock = new ReentrantReadWriteLock();

    private SessionStorage() {
    }

    public static SessionStorage getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String sessionId, ObjectType type) {
        try {
            this.singleLock.readLock().lock();
            if (!this.accessTime.containsKey(sessionId)) {
                this.accessTime.put(sessionId, new AtomicLong(System.currentTimeMillis()));
            }
            this.accessTime.get(sessionId).set(System.currentTimeMillis());
            Object object = this.storage.get((Object)sessionId, (Object)type);
            return object;
        }
        finally {
            this.singleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String sessionId, ObjectType type, Object object) {
        try {
            this.singleLock.writeLock().lock();
            if (!this.accessTime.containsKey(sessionId)) {
                this.accessTime.put(sessionId, new AtomicLong(System.currentTimeMillis()));
            }
            this.accessTime.get(sessionId).set(System.currentTimeMillis());
            this.truncateUnused();
            this.storage.put((Object)sessionId, (Object)type, object);
        }
        finally {
            this.singleLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateUnused() {
        ArrayList<String> sessions = Collections.list(this.accessTime.keys());
        ArrayList<Pair> removals = new ArrayList<Pair>();
        for (String session : sessions) {
            long time = this.accessTime.get(session).get();
            if (time >= System.currentTimeMillis() - 1800000L) continue;
            this.accessTime.remove(session);
            try {
                this.singleLock.readLock().lock();
                Map map = this.storage.row((Object)session);
                for (ObjectType type : map.keySet()) {
                    removals.add(Pair.makePair((Object)session, (Object)((Object)type)));
                }
            }
            finally {
                this.singleLock.readLock().unlock();
            }
        }
        try {
            this.singleLock.writeLock().lock();
            for (Pair objects : removals) {
                this.storage.remove(objects.getFirst(), objects.getSecond());
            }
        }
        finally {
            this.singleLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ObjectType>> getSessions() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        try {
            this.singleLock.readLock().lock();
            Set sessions = this.storage.rowKeySet();
            for (String session : sessions) {
                Map map = this.storage.row((Object)session);
                for (ObjectType type : map.keySet()) {
                    if (!result.containsKey(session)) {
                        result.put(session, new ArrayList());
                    }
                    ((List)result.get(session)).add(type);
                }
            }
            ConcurrentHashMap concurrentHashMap = result;
            return concurrentHashMap;
        }
        finally {
            this.singleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessions(ObjectType type) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.singleLock.readLock().lock();
            Map map = this.storage.column((Object)type);
            for (String session : map.keySet()) {
                results.add(session);
            }
        }
        finally {
            this.singleLock.readLock().unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ObjectType, List<String>> getEvents() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        try {
            this.singleLock.readLock().lock();
            Set events = this.storage.columnKeySet();
            for (ObjectType type : events) {
                Map map = this.storage.column((Object)type);
                for (String session : map.keySet()) {
                    if (!result.containsKey((Object)type)) {
                        result.put(type, new ArrayList());
                    }
                    ((List)result.get((Object)type)).add(session);
                }
            }
            ConcurrentHashMap concurrentHashMap = result;
            return concurrentHashMap;
        }
        finally {
            this.singleLock.readLock().unlock();
        }
    }
}

