/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.rl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.ui.rl.beans.ReportBean;
import org.deeplearning4j.ui.storage.HistoryStorage;

@Path(value="/rl")
public class RlResource {
    private HistoryStorage storage = HistoryStorage.getInstance();
    private String key = "RL";

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    public Response getState(@QueryParam(value="sid") String sessionId) {
        List<Object> rewards = this.storage.getSorted(this.key, HistoryStorage.SortOutput.ASCENDING);
        ArrayList<String> conv = new ArrayList<String>();
        for (Object object : rewards) {
            ReportBean bean = (ReportBean)object;
            conv.add(new String("" + bean.getEpochId() + "|" + bean.getReward() + "|Epoch_" + bean.getEpochId()));
        }
        return Response.ok(conv).build();
    }

    @POST
    @Path(value="/state")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postState(@QueryParam(value="sid") String sessionId, ReportBean bean) {
        this.storage.put(this.key, (Pair<Integer, Integer>)Pair.newPair((Object)((int)bean.getEpochId()), (Object)0), bean);
        return Response.ok(Collections.singletonMap("status", "ok")).build();
    }
}

