/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.flow.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.deeplearning4j.ui.flow.beans.LayerInfo;

public class ModelInfo
implements Serializable {
    private static final long serialVersionUID = 119L;
    private long time = System.currentTimeMillis();
    private transient int counter = 0;
    private List<LayerInfo> layers = new ArrayList<LayerInfo>();

    public synchronized void addLayer(@NonNull LayerInfo layer) {
        if (layer == null) {
            throw new NullPointerException("layer");
        }
        if (!this.layers.contains(layer)) {
            layer.setId(this.counter);
            this.layers.add(layer);
            ++this.counter;
        }
    }

    public LayerInfo getLayerInfoByName(String name) {
        for (LayerInfo layerInfo : this.layers) {
            if (!layerInfo.getName().equalsIgnoreCase(name)) continue;
            return layerInfo;
        }
        return null;
    }

    public LayerInfo getLayerInfoByCoords(int x, int y) {
        for (LayerInfo layerInfo : this.layers) {
            if (layerInfo.getX() != x || layerInfo.getY() != y) continue;
            return layerInfo;
        }
        return null;
    }

    public int size() {
        return this.layers.size();
    }

    public Set<String> getLayerTypes() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (LayerInfo layerInfo : this.layers) {
            set.add(layerInfo.getLayerType());
        }
        return set;
    }

    public Set<LayerInfo> getLayersByType(String layerType) {
        LinkedHashSet<LayerInfo> set = new LinkedHashSet<LayerInfo>();
        for (LayerInfo layerInfo : this.layers) {
            if (!layerInfo.getLayerType().equals(layerType)) continue;
            set.add(layerInfo);
        }
        return set;
    }

    public long getTime() {
        return this.time;
    }

    public int getCounter() {
        return this.counter;
    }

    public List<LayerInfo> getLayers() {
        return this.layers;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void setLayers(List<LayerInfo> layers) {
        this.layers = layers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelInfo)) {
            return false;
        }
        ModelInfo other = (ModelInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        List<LayerInfo> this$layers = this.getLayers();
        List<LayerInfo> other$layers = other.getLayers();
        return !(this$layers == null ? other$layers != null : !((Object)this$layers).equals(other$layers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        List<LayerInfo> $layers = this.getLayers();
        result = result * 59 + ($layers == null ? 0 : ((Object)$layers).hashCode());
        return result;
    }

    public String toString() {
        return "ModelInfo(time=" + this.getTime() + ", counter=" + this.getCounter() + ", layers=" + this.getLayers() + ")";
    }
}

