/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.defaults;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.deeplearning4j.ui.storage.SessionStorage;
import org.deeplearning4j.ui.storage.def.ObjectType;

@Path(value="/")
@Produces(value={"text/html"})
public class DefaultResource {
    private SessionStorage storage = SessionStorage.getInstance();

    @GET
    @Path(value="/whatsup")
    @Produces(value={"application/json"})
    public Response getWhatsUp() {
        return Response.ok(this.storage.getSessions()).build();
    }

    @GET
    @Path(value="/events")
    @Produces(value={"application/json"})
    public Response getEvents() {
        return Response.ok(this.storage.getEvents()).build();
    }

    @GET
    @Path(value="/sessions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSessions(@QueryParam(value="event") String event) {
        ObjectType type = ObjectType.valueOf(event);
        if (type == null) {
            return Response.noContent().build();
        }
        return Response.ok(this.storage.getSessions(type)).build();
    }
}

