/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.renders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.ui.renders.PathUpdate;

@Path(value="/filters")
@Produces(value={"text/html"})
public class RendersResource {
    private String imagePath = "render.png";

    @POST
    @Path(value="/update")
    @Produces(value={"application/json"})
    public Response update(PathUpdate path) {
        this.imagePath = path.getPath();
        return Response.ok(Collections.singletonMap("status", "updated path")).build();
    }

    @GET
    @Path(value="/img")
    @Produces(value={"image/png"})
    public Response image() {
        if (this.imagePath == null) {
            throw new WebApplicationException(404);
        }
        final File f = new File(this.imagePath);
        if (!f.exists()) {
            throw new WebApplicationException(404);
        }
        return Response.ok().entity((Object)new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                FileInputStream fis = new FileInputStream(f);
                byte[] bytes = IOUtils.toByteArray((InputStream)fis);
                fis.close();
                output.write(bytes);
                output.flush();
            }
        }).build();
    }
}

