/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.ui.providers.ObjectMapperProvider;
import org.deeplearning4j.ui.weights.ModelAndGradient;

public class HistogramIterationListener
implements IterationListener {
    private Client client = (Client)((Client)ClientBuilder.newClient().register(JacksonJsonProvider.class)).register((Object)new ObjectMapperProvider());
    private WebTarget target;
    private int iterations = 1;

    public HistogramIterationListener(int iterations) {
        this.iterations = iterations;
        this.target = this.client.target("http://localhost:8080").path("weights").path("update");
    }

    public boolean invoked() {
        return false;
    }

    public void invoke() {
    }

    public void iterationDone(Model model, int iteration) {
        if (iteration % this.iterations == 0) {
            ModelAndGradient g = new ModelAndGradient();
            g.setGradients(model.gradient().gradientForVariable());
            g.setParameters(model.paramTable());
            g.setScore(model.score());
            Response resp = this.target.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(Entity.entity((Object)g, (String)"application/json"));
            System.out.println(resp);
        }
    }
}

