/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui;

import com.google.common.collect.ImmutableMap;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewBundle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.UIConfiguration;
import org.deeplearning4j.ui.nearestneighbors.NearestNeighborsResource;
import org.deeplearning4j.ui.renders.RendersResource;
import org.deeplearning4j.ui.tsne.TsneResource;
import org.deeplearning4j.ui.weights.WeightResource;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.springframework.core.io.ClassPathResource;

public class UiServer
extends Application<UIConfiguration> {
    private UIConfiguration conf;

    public void run(UIConfiguration uiConfiguration, Environment environment) throws Exception {
        this.conf = uiConfiguration;
        environment.jersey().register(MultiPartFeature.class);
        environment.jersey().register((Object)new TsneResource(this.conf.getUploadPath()));
        environment.jersey().register((Object)new NearestNeighborsResource(this.conf.getUploadPath()));
        environment.jersey().register((Object)new WeightResource());
        environment.jersey().register((Object)new RendersResource());
        environment.jersey().register((Object)new org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsResource(this.conf.getUploadPath()));
        this.configureCors(environment);
    }

    public void initialize(Bootstrap<UIConfiguration> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ViewBundle<UIConfiguration>(){

            public ImmutableMap<String, ImmutableMap<String, String>> getViewConfiguration(UIConfiguration arg0) {
                return ImmutableMap.of();
            }
        });
        bootstrap.addBundle((Bundle)new AssetsBundle());
    }

    public static void main(String[] args) throws Exception {
        ClassPathResource resource = new ClassPathResource("dropwizard.yml");
        InputStream is = resource.getInputStream();
        File tmpConfig = new File("dropwizard-render.yml");
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpConfig));
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        bos.flush();
        bos.close();
        is.close();
        tmpConfig.deleteOnExit();
        new UiServer().run(new String[]{"server", tmpConfig.getAbsolutePath()});
    }

    private void configureCors(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        filter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin");
        filter.setInitParameter("allowCredentials", "true");
    }
}

